/*
 * Decompiled with CFR 0.152.
 */
package jxl.report;

import freemarker.cache.StringTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.TemplateException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jxl.Cell;
import jxl.CellType;
import jxl.Range;
import jxl.Workbook;
import jxl.WorkbookSettings;
import jxl.report.FreemarkerHelper;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableCell;
import jxl.write.WritableCellFeatures;
import jxl.write.WritableImage;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportEnginer {
    private static Logger LOG = Logger.getLogger(ReportEnginer.class);
    public static final String DIRECTIVE_NUMBER = "?number";
    public static final String DIRECTIVE_IMAGE = "?image";
    public static final String[] ftlTags = new String[]{"${", "<#", "</#"};
    private static final String REMOVE_ROW = "1";
    private static final String REMOVE_COLUMN = "2";
    private static final String NOT_REMOVE_ROW = "3";
    private static final String NOT_REMOVE_COLUMN = "4";
    private static final String FTL_ROW_OR_COLUMN = "5";
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private Map<String, String> inListTagCells = new LinkedHashMap<String, String>();

    public void excute(String templateFile, Map<String, Object> context, String destFile) throws Exception {
        FileInputStream input = null;
        OutputStream out = null;
        try {
            input = new FileInputStream(templateFile);
            out = new FileOutputStream(destFile);
            this.excute(input, context, out);
        }
        finally {
            if (input != null) {
                ((InputStream)input).close();
            }
            if (out != null) {
                out.close();
            }
        }
    }

    public void excute(InputStream input, Map<String, Object> context, OutputStream out) throws Exception {
        Workbook workbook = null;
        WritableWorkbook writableWorkbook = null;
        try {
            workbook = Workbook.getWorkbook((InputStream)input);
            writableWorkbook = Workbook.createWorkbook((OutputStream)out, (Workbook)workbook, (WorkbookSettings)new WorkbookSettings());
            WritableSheet[] sheets = writableWorkbook.getSheets();
            int i = 0;
            while (i < sheets.length) {
                WritableSheet writableSheet = sheets[i];
                try {
                    this.prepare(writableSheet);
                    String ftl = this.convertSheetAsFtl(writableSheet);
                    if (StringUtils.isBlank((String)ftl)) {
                        LOG.debug((Object)(String.valueOf(writableSheet.getName()) + " no freemarker tag context"));
                    } else {
                        LOG.debug((Object)ftl);
                        String ftlResult = this.convertFtl(context, ftl.trim(), writableSheet.getName());
                        if (StringUtils.isBlank((String)ftlResult)) {
                            LOG.debug((Object)(String.valueOf(writableSheet.getName()) + " no out context"));
                        } else {
                            this.exportResultToSheet(writableSheet, ftlResult.trim());
                        }
                    }
                }
                finally {
                    this.cleanup(writableSheet);
                }
                ++i;
            }
        }
        finally {
            if (workbook != null) {
                try {
                    workbook.close();
                }
                catch (Exception exception) {}
            }
            if (writableWorkbook != null) {
                writableWorkbook.write();
                writableWorkbook.close();
            }
        }
    }

    private void prepare(WritableSheet writableSheet) {
        writableSheet.insertRow(0);
        writableSheet.insertColumn(0);
        LOG.debug((Object)"prepare");
    }

    private void cleanup(WritableSheet writableSheet) {
        writableSheet.removeRow(0);
        writableSheet.removeColumn(0);
        LOG.debug((Object)"clean up");
    }

    private String convertSheetAsFtl(WritableSheet writableSheet) throws RowsExceededException, WriteException {
        LinkedHashMap<Integer, List<WritableCell>> tagCells = new LinkedHashMap<Integer, List<WritableCell>>();
        int rows = writableSheet.getRows();
        int columns = writableSheet.getColumns();
        StringBuffer ftl = new StringBuffer();
        int listStartCounter = 0;
        int listEndCounter = 0;
        int ifStartCounter = 0;
        int ifEndCounter = 0;
        int row = 0;
        while (row < rows) {
            ArrayList<WritableCell> rowTags = null;
            StringBuffer rowFtl = new StringBuffer();
            this.rowStart(row, rowFtl);
            int column = 0;
            while (column < columns) {
                WritableCell writableCell = writableSheet.getWritableCell(column, row);
                String contents = writableCell.getContents();
                boolean listStart = this.isListStartTag(contents);
                boolean listEnd = this.isListEndTag(contents);
                boolean ifStart = this.isIfStartTag(contents);
                boolean ifEnd = this.isIfEndTag(contents);
                if (listStart) {
                    ++listStartCounter;
                }
                if (listEnd) {
                    ++listEndCounter;
                }
                if (ifStart) {
                    ++ifStartCounter;
                }
                if (ifEnd) {
                    ++ifEndCounter;
                }
                if (listStart || listEnd || ifStart || ifEnd) {
                    rowFtl.append(contents);
                    if (rowTags == null) {
                        rowTags = new ArrayList<WritableCell>();
                    }
                    rowTags.add(writableCell);
                } else {
                    this.parseCell(writableSheet, writableCell, row, column, rowFtl, listStartCounter > listEndCounter, ifStartCounter > ifEndCounter);
                }
                ++column;
            }
            this.rowEnd(row, rowFtl);
            if (rowTags != null) {
                tagCells.put(row, rowTags);
            }
            if (this.rowHasContents(row, rowFtl)) {
                ftl.append(rowFtl);
                this.lineEnd(ftl);
            }
            ++row;
        }
        this.markRemoveRowClumn(writableSheet, tagCells);
        return ftl.toString();
    }

    public String convertFtl(Map<String, Object> context, String ftl, String id) throws TemplateException, IOException {
        StringTemplateLoader stringTemplateLoader = new StringTemplateLoader();
        stringTemplateLoader.putTemplate(id, ftl);
        StringWriter stringWriter = FreemarkerHelper.produceAsStringWriter((TemplateLoader)stringTemplateLoader, context, "UTF-8", null, id, "UTF-8");
        if (stringWriter != null) {
            return stringWriter.toString();
        }
        return null;
    }

    private void exportResultToSheet(WritableSheet writableSheet, String result) throws RowsExceededException, NumberFormatException, WriteException, IOException, Exception {
        BufferedReader in = new BufferedReader(new StringReader(result));
        String line = null;
        int toRow = -1;
        LinkedHashMap<Integer, Integer> firstFilledRows = new LinkedHashMap<Integer, Integer>();
        LinkedHashMap<Integer, Integer> firstFilledColumns = new LinkedHashMap<Integer, Integer>();
        LinkedHashMap<String, Integer> copyRows = new LinkedHashMap<String, Integer>();
        LinkedHashMap<String, Integer> copyColumns = new LinkedHashMap<String, Integer>();
        LinkedHashMap<String, String> mergeCells = new LinkedHashMap<String, String>();
        while ((line = in.readLine()) != null) {
            int startInd = line.indexOf("<r_");
            if (startInd == -1) {
                LOG.debug((Object)(String.valueOf(line) + " is not a row !"));
                continue;
            }
            int startEndInd = line.indexOf(">");
            int orgRow = Integer.parseInt(line.substring(startInd + 3, startEndInd));
            String endTag = "</r_" + orgRow + ">";
            int newRow = orgRow + this.getInsertBeforeRows(copyRows, orgRow);
            if (toRow < newRow) {
                toRow = newRow;
                toRow = this.computeToRow(writableSheet, toRow);
            } else {
                Integer fromRow = (Integer)firstFilledRows.get(orgRow);
                if (fromRow == null) {
                    fromRow = orgRow;
                }
                ++toRow;
                Range[] mergedCell = writableSheet.getMergedCells();
                int i = 0;
                while (i < mergedCell.length) {
                    int x1 = mergedCell[i].getTopLeft().getRow();
                    int x2 = mergedCell[i].getBottomRight().getRow();
                    if (fromRow == x1) {
                        toRow += x2 - x1;
                        break;
                    }
                    ++i;
                }
                String key = fromRow + "-" + toRow;
                if (!copyRows.containsKey(key)) {
                    this.copyRow(writableSheet, mergeCells, fromRow, toRow);
                    copyRows.put(key, toRow);
                }
            }
            int endInd = line.indexOf(endTag);
            line = line.substring(startEndInd + 1, endInd);
            if (firstFilledRows.get(orgRow) == null) {
                firstFilledRows.put(orgRow, toRow);
            }
            this.exportLineToRow(writableSheet, mergeCells, line, toRow, copyColumns, firstFilledColumns);
        }
        this.mergeCells(writableSheet, mergeCells);
        this.removeRowColumn(writableSheet, copyRows, copyColumns);
    }

    private void mergeCells(WritableSheet writableSheet, Map<String, String> mergeCells) throws RowsExceededException, NumberFormatException, WriteException {
        for (String str : mergeCells.values()) {
            String[] arr = str.split(",");
            if (arr.length != 4) continue;
            writableSheet.mergeCells(Integer.parseInt(arr[1]), Integer.parseInt(arr[0]), Integer.parseInt(arr[3]), Integer.parseInt(arr[2]));
        }
    }

    private void exportLineToRow(WritableSheet writableSheet, Map<String, String> mergeCells, String line, int toRow, Map<String, Integer> copyColumns, Map<Integer, Integer> firstFilledColumns) throws Exception {
        int toColumn = -1;
        int startInd = -1;
        while ((startInd = line.indexOf("<c_")) != -1) {
            int startEndInd = line.indexOf(">");
            String colStr = line.substring(startInd + 3, startEndInd);
            int orgColumn = 0;
            try {
                orgColumn = Integer.parseInt(colStr);
            }
            catch (Exception e) {
                LOG.info((Object)(String.valueOf(toRow) + " : " + line));
                LOG.error((Object)e.getMessage());
                throw e;
            }
            String endTag = "</c_" + orgColumn + ">";
            int newColumn = orgColumn + this.getInsertBeforeColumns(copyColumns, orgColumn);
            if (toColumn < newColumn) {
                toColumn = newColumn;
                toColumn = this.computeToColumn(writableSheet, toColumn);
            } else {
                Integer fromColumn = firstFilledColumns.get(orgColumn);
                if (fromColumn == null) {
                    fromColumn = orgColumn;
                }
                ++toColumn;
                Range[] mergedCell = writableSheet.getMergedCells();
                int i = 0;
                while (i < mergedCell.length) {
                    int y1 = mergedCell[i].getTopLeft().getColumn();
                    int y2 = mergedCell[i].getBottomRight().getColumn();
                    if (fromColumn == y1) {
                        toColumn += y2 - y1;
                        break;
                    }
                    ++i;
                }
                String key = fromColumn + "-" + toColumn;
                if (!copyColumns.containsKey(key)) {
                    this.copyColumn(writableSheet, mergeCells, fromColumn, toColumn);
                    copyColumns.put(key, toColumn);
                }
            }
            if (firstFilledColumns.get(orgColumn) == null) {
                firstFilledColumns.put(orgColumn, toColumn);
            }
            int endInd = line.indexOf(endTag);
            String contents = line.substring(startEndInd + 1, endInd);
            this.exportCell(writableSheet, mergeCells, toRow, toColumn, contents);
            if (line.length() <= endInd + endTag.length()) break;
            line = line.substring(endInd + endTag.length());
        }
        int columns = writableSheet.getColumns();
        int col = 0;
        while (col < columns) {
            boolean ftlTag;
            WritableCell writableCell = writableSheet.getWritableCell(col, toRow);
            boolean bl = ftlTag = StringUtils.indexOfAny((String)writableCell.getContents(), (String[])ftlTags) != -1;
            if (ftlTag) {
                this.setCell(writableSheet, mergeCells, toRow, col, "");
            }
            ++col;
        }
    }

    private int computeToColumn(WritableSheet writableSheet, int toColumn) {
        int cols = writableSheet.getColumns();
        int i = toColumn;
        while (i < cols) {
            Cell cell = writableSheet.getCell(i, 0);
            if (!CellType.LABEL.equals(cell.getType()) || !REMOVE_COLUMN.equals(cell.getContents())) break;
            ++i;
        }
        return i;
    }

    private int computeToRow(WritableSheet writableSheet, int toRow) {
        int rows = writableSheet.getRows();
        int i = toRow;
        while (i < rows) {
            Cell cell = writableSheet.getCell(0, i);
            if (!CellType.LABEL.equals(cell.getType()) || !REMOVE_ROW.equals(cell.getContents())) break;
            ++i;
        }
        return i;
    }

    private void exportCell(WritableSheet writableSheet, Map<String, String> mergeCells, int row, int column, String contents) throws Exception {
        this.setCell(writableSheet, mergeCells, row, column, contents);
        this.setCell(writableSheet, mergeCells, row, 0, NOT_REMOVE_ROW);
        this.setCell(writableSheet, mergeCells, 0, column, NOT_REMOVE_COLUMN);
    }

    private boolean setCell(WritableSheet writableSheet, Map<String, String> mergeCells, int row, int column, String contents) throws RowsExceededException, WriteException {
        WritableCell writableCell = writableSheet.getWritableCell(column, row);
        if (this.isNumberDirective(contents)) {
            if (this.setNumberCell(writableSheet, row, column, contents)) {
                return true;
            }
            contents = StringUtils.substringBeforeLast((String)contents, (String)"?");
        }
        if (this.isImageDirective(contents)) {
            if (this.setImageCell(writableSheet, mergeCells, row, column, contents)) {
                return true;
            }
            contents = StringUtils.substringBeforeLast((String)contents, (String)"?");
        }
        if (CellType.LABEL.equals(writableCell.getType())) {
            ((Label)writableCell).setString(contents);
        } else {
            Label newWritableCell = new Label(column, row, contents);
            if (writableCell.getWritableCellFeatures() != null) {
                newWritableCell.setCellFeatures(writableCell.getWritableCellFeatures());
            }
            if (writableCell.getCellFormat() != null) {
                newWritableCell.setCellFormat(writableCell.getCellFormat());
            }
            writableSheet.addCell((WritableCell)newWritableCell);
        }
        return true;
    }

    private boolean setNumberCell(WritableSheet writableSheet, int row, int column, String contents) throws RowsExceededException, WriteException {
        try {
            WritableCell writableCell = writableSheet.getWritableCell(column, row);
            int start = contents.indexOf("?");
            String num = contents.substring(0, start).trim();
            double val = Double.parseDouble(num);
            if (CellType.NUMBER.equals(writableCell.getType())) {
                ((Number)writableCell).setValue(val);
            } else {
                Number newWritableCell = new Number(column, row, val);
                if (writableCell.getWritableCellFeatures() != null) {
                    newWritableCell.setCellFeatures(writableCell.getWritableCellFeatures());
                }
                if (writableCell.getCellFormat() != null) {
                    newWritableCell.setCellFormat(writableCell.getCellFormat());
                }
                writableSheet.addCell((WritableCell)newWritableCell);
            }
            return true;
        }
        catch (NumberFormatException ne) {
            LOG.error((Object)("Error: " + row + "," + column + ":" + contents + ne.getMessage()));
            return false;
        }
    }

    private boolean setImageCell(WritableSheet writableSheet, Map<String, String> mergeCells, int row, int column, String contents) throws RowsExceededException, WriteException {
        int start = contents.indexOf("?");
        String filePath = contents.substring(0, start).trim();
        if (!StringUtils.endsWithIgnoreCase((String)(filePath = StringUtils.replace((String)filePath, (String)"\\", (String)"/")), (String)".png")) {
            LOG.warn((Object)("Only support png image file : " + filePath));
            return false;
        }
        File file = new File(filePath);
        if (!file.exists()) {
            LOG.warn((Object)("Not found file " + filePath));
            return false;
        }
        if (file.isDirectory()) {
            LOG.warn((Object)("Excepted a png image file,but got a directory : " + filePath));
            return false;
        }
        int width = 1;
        int height = 1;
        for (String str : mergeCells.values()) {
            String[] arr = str.split(",");
            if (arr.length != 4) continue;
            int x1 = Integer.parseInt(arr[0]);
            int y1 = Integer.parseInt(arr[1]);
            if (x1 != row || y1 != column) continue;
            int x2 = Integer.parseInt(arr[2]);
            int y2 = Integer.parseInt(arr[3]);
            width = x2 - x1 + 1;
            height = y2 - y1 + 1;
            break;
        }
        Range[] mergedCell = writableSheet.getMergedCells();
        int i = 0;
        while (i < mergedCell.length) {
            int x1 = mergedCell[i].getTopLeft().getRow();
            int y1 = mergedCell[i].getTopLeft().getColumn();
            if (x1 == row && y1 == column) {
                int x2 = mergedCell[i].getBottomRight().getRow();
                int y2 = mergedCell[i].getBottomRight().getColumn();
                width = x2 - x1 + 1;
                height = y2 - y1 + 1;
                break;
            }
            ++i;
        }
        WritableImage writableImage = new WritableImage((double)(column - 1), (double)(row - 1), (double)height, (double)width, file);
        writableSheet.addImage(writableImage);
        return true;
    }

    private boolean isNumberDirective(String contents) {
        return contents != null && contents.lastIndexOf(DIRECTIVE_NUMBER) != -1;
    }

    private boolean isImageDirective(String contents) {
        return contents != null && contents.lastIndexOf(DIRECTIVE_IMAGE) != -1;
    }

    private void setComment(WritableSheet writableSheet, int row, int column, String comment) throws RowsExceededException, WriteException {
        WritableCell writableCell = writableSheet.getWritableCell(column, row);
        WritableCellFeatures cellFeatures = writableCell.getWritableCellFeatures();
        if (cellFeatures == null) {
            cellFeatures = new WritableCellFeatures();
            writableCell.setCellFeatures(cellFeatures);
        }
        cellFeatures.setComment(comment);
    }

    private Integer getInsertBeforeRows(Map<String, Integer> copyRows, int row) {
        int result = 0;
        for (String key : copyRows.keySet()) {
            String[] arr = key.split("-");
            int org = Integer.parseInt(arr[0]);
            if (org >= row) continue;
            ++result;
        }
        if (result > 0) {
            LOG.debug((Object)(" ====================== row " + row + " \u524d\u9762\u589e\u52a0\u4e86  " + result));
        }
        return result;
    }

    private int getInsertBeforeColumns(Map<String, Integer> copyColumns, int column) {
        int result = 0;
        for (String key : copyColumns.keySet()) {
            String[] arr = key.split("-");
            int org = Integer.parseInt(arr[0]);
            if (org >= column) continue;
            ++result;
        }
        if (result > 0) {
            LOG.debug((Object)(" ====================== column " + column + " \u524d\u9762\u589e\u52a0\u4e86  " + result));
        }
        return result;
    }

    private void cleanCellContents(WritableCell cell) {
        if (CellType.LABEL.equals(cell.getType())) {
            ((Label)cell).setString("");
        } else if (CellType.NUMBER.equals(cell.getType())) {
            ((Number)cell).setValue(0.0);
        }
    }

    private void copyRow(WritableSheet writableSheet, Map<String, String> mergeCells, int from, int to) throws RowsExceededException, WriteException {
        writableSheet.insertRow(to);
        int columns = writableSheet.getColumns();
        int col = 0;
        while (col < columns) {
            WritableCell writableCell = writableSheet.getWritableCell(col, from);
            WritableCell newWritableCell = writableCell.copyTo(col, to);
            writableSheet.addCell(newWritableCell);
            if (this.inListTagCells.get(String.valueOf(writableSheet.getName()) + "," + from + "," + col) != null) {
                this.cleanCellContents(newWritableCell);
                this.inListTagCells.put(String.valueOf(writableSheet.getName()) + "," + to + "," + col, "");
            }
            ++col;
        }
        Range[] mergedCell = writableSheet.getMergedCells();
        int i = 0;
        while (i < mergedCell.length) {
            int x1 = mergedCell[i].getTopLeft().getRow();
            if (from == x1) {
                int y1 = mergedCell[i].getTopLeft().getColumn();
                int x2 = mergedCell[i].getBottomRight().getRow();
                int y2 = mergedCell[i].getBottomRight().getColumn();
                int newX1 = to;
                int newY1 = y1;
                int newX2 = newX1 + (x2 - x1);
                int newY2 = y2;
                String key = String.valueOf(newX1) + "," + newY1 + "," + newX2 + "," + newY2;
                mergeCells.put(key, key);
                int ind = newX1;
                while (ind <= newX2) {
                    this.setCell(writableSheet, mergeCells, ind, 0, NOT_REMOVE_ROW);
                    ++ind;
                }
                ind = newY1;
                while (ind <= newY2) {
                    this.setCell(writableSheet, mergeCells, 0, ind, NOT_REMOVE_COLUMN);
                    ++ind;
                }
            }
            ++i;
        }
    }

    private void copyColumn(WritableSheet writableSheet, Map<String, String> mergeCells, int from, int to) throws RowsExceededException, WriteException {
        writableSheet.insertColumn(to);
        int rows = writableSheet.getRows();
        int row = 0;
        while (row < rows) {
            WritableCell writableCell = writableSheet.getWritableCell(from, row);
            WritableCell newWritableCell = writableCell.copyTo(to, row);
            writableSheet.addCell(newWritableCell);
            if (this.inListTagCells.get(String.valueOf(writableSheet.getName()) + "," + row + "," + from) != null) {
                this.cleanCellContents(newWritableCell);
                this.inListTagCells.put(String.valueOf(writableSheet.getName()) + "," + row + "," + to, "");
            }
            ++row;
        }
        Range[] mergedCell = writableSheet.getMergedCells();
        int i = 0;
        while (i < mergedCell.length) {
            int y1 = mergedCell[i].getTopLeft().getColumn();
            if (from == y1) {
                int x1 = mergedCell[i].getTopLeft().getRow();
                int x2 = mergedCell[i].getBottomRight().getRow();
                int y2 = mergedCell[i].getBottomRight().getColumn();
                int newX1 = x1;
                int newY1 = to;
                int newX2 = x2;
                int newY2 = to + (y2 - y1);
                String key = String.valueOf(newX1) + "," + newY1 + "," + newX2 + "," + newY2;
                mergeCells.put(key, key);
                int ind = newX1;
                while (ind <= newX2) {
                    this.setCell(writableSheet, mergeCells, ind, 0, NOT_REMOVE_ROW);
                    ++ind;
                }
                ind = newY1;
                while (ind <= newY2) {
                    this.setCell(writableSheet, mergeCells, 0, ind, NOT_REMOVE_COLUMN);
                    ++ind;
                }
            }
            ++i;
        }
        LOG.debug((Object)(String.valueOf(writableSheet.getName()) + " copy column " + from + " to " + to));
    }

    private void markRemoveRowClumn(WritableSheet writableSheet, Map<Integer, List<WritableCell>> tagCells) throws RowsExceededException, WriteException {
        if (tagCells == null) {
            return;
        }
        for (Integer row : tagCells.keySet()) {
            List<WritableCell> rowTags = tagCells.get(row);
            if (rowTags.size() == 0) continue;
            if (rowTags.size() == 1) {
                this.setCell(writableSheet, null, row, 0, REMOVE_ROW);
                LOG.debug((Object)(String.valueOf(writableSheet.getName()) + " row " + row + " is freemarker tag"));
                continue;
            }
            if (rowTags.size() % 2 == 1) {
                throw new RuntimeException("row  " + row + " : tag error \u6ca1\u6709\u6b63\u786e\u7ed3\u675f");
            }
            int listEndTagCounter = 0;
            int ifEndTagCounter = 0;
            for (WritableCell writableCell : rowTags) {
                if (this.isListEndTag(writableCell.getContents())) {
                    ++listEndTagCounter;
                }
                if (!this.isIfEndTag(writableCell.getContents())) continue;
                ++ifEndTagCounter;
            }
            if (listEndTagCounter > 0 && listEndTagCounter != rowTags.size() / 2 || ifEndTagCounter > 0 && ifEndTagCounter != rowTags.size() / 2) {
                throw new RuntimeException("row  " + row + " : tag error \u5f00\u59cb\u548c\u7ed3\u675f\u4e2a\u6570\u4e0d\u5339\u914d");
            }
            for (WritableCell writableCell : rowTags) {
                int column = writableCell.getColumn();
                this.setCell(writableSheet, null, 0, column, REMOVE_COLUMN);
                LOG.debug((Object)(String.valueOf(writableSheet.getName()) + " column " + column + " is freemarker tags"));
            }
        }
    }

    private void removeRowColumn(WritableSheet writableSheet, Map<String, Integer> copyRows, Map<String, Integer> copyColumns) {
        Cell cell;
        int rows = writableSheet.getRows();
        int columns = writableSheet.getColumns();
        ArrayList<Integer> delRows = new ArrayList<Integer>();
        ArrayList<Integer> delColumns = new ArrayList<Integer>();
        int i = 1;
        while (i < columns) {
            cell = writableSheet.getCell(i, 0);
            if (CellType.LABEL.equals(cell.getType()) && !StringUtils.isBlank((String)cell.getContents()) && !NOT_REMOVE_COLUMN.equals(cell.getContents())) {
                writableSheet.removeColumn(i);
                delColumns.add(i);
                LOG.debug((Object)(String.valueOf(writableSheet.getName()) + " remove column " + i));
                --i;
            }
            ++i;
        }
        i = 1;
        while (i < rows) {
            cell = writableSheet.getCell(0, i);
            if (CellType.LABEL.equals(cell.getType()) && !StringUtils.isBlank((String)cell.getContents()) && !NOT_REMOVE_ROW.equals(cell.getContents())) {
                writableSheet.removeRow(i);
                delRows.add(i);
                LOG.debug((Object)(String.valueOf(writableSheet.getName()) + " remove row " + i));
                --i;
            }
            ++i;
        }
        i = 0;
        if (delRows.size() != 0 || delColumns.size() != 0) {
            try {
                while (true) {
                    WritableImage image;
                    if ((image = writableSheet.getImage(i)) != null) {
                        double r = image.getY();
                        double c = image.getX();
                        int cutR = 0;
                        for (Integer delR : delRows) {
                            if (!((double)delR.intValue() <= r)) continue;
                            ++cutR;
                        }
                        if (cutR != 0) {
                            image.setY(r - (double)cutR);
                        }
                        int cutC = 0;
                        for (Integer delC : delColumns) {
                            if (!((double)delC.intValue() <= c)) continue;
                            ++cutC;
                        }
                        if (cutC != 0) {
                            image.setX(c - (double)cutC);
                        }
                    }
                    ++i;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void parseCell(WritableSheet writableSheet, WritableCell writableCell, int row, int column, StringBuffer ftl, boolean inListTag, boolean inIfTag) throws RowsExceededException, WriteException {
        if (CellType.LABEL.equals(writableCell.getType())) {
            boolean ftlTag;
            String contents = writableCell.getContents();
            boolean bl = ftlTag = StringUtils.indexOfAny((String)contents, (String[])ftlTags) != -1;
            if (inListTag || inIfTag || ftlTag) {
                this.cellStart(row, column, ftl);
                ftl.append(contents);
                if (inListTag && ftlTag) {
                    this.inListTagCells.put(String.valueOf(writableSheet.getName()) + "," + writableCell.getRow() + "," + writableCell.getColumn(), "");
                }
                this.cellEnd(row, column, ftl);
                this.setCell(writableSheet, null, row, 0, FTL_ROW_OR_COLUMN);
                this.setCell(writableSheet, null, 0, column, FTL_ROW_OR_COLUMN);
            }
        }
    }

    private boolean rowHasContents(int row, StringBuffer rowFtl) {
        StringBuffer _temp = new StringBuffer();
        this.rowStart(row, _temp);
        this.rowEnd(row, _temp);
        if (rowFtl.toString().equals(_temp.toString())) {
            return false;
        }
        int len = ("<r_" + row + ">").length();
        if (this.isListStartTag(rowFtl.toString()) || this.isListEndTag(rowFtl.toString()) || this.isIfStartTag(rowFtl.toString()) || this.isIfEndTag(rowFtl.toString())) {
            rowFtl.delete(0, len);
            rowFtl.delete(rowFtl.length() - len - 1, rowFtl.length());
        }
        return true;
    }

    private boolean isListStartTag(String contents) {
        return contents.indexOf("<#list ") != -1 && StringUtils.countMatches((String)contents, (String)"<#list ") != StringUtils.countMatches((String)contents, (String)"</#list>");
    }

    private boolean isListEndTag(String contents) {
        return contents.indexOf("</#list>") != -1 && StringUtils.countMatches((String)contents, (String)"<#list ") != StringUtils.countMatches((String)contents, (String)"</#list>");
    }

    private boolean isIfStartTag(String contents) {
        return contents.indexOf("<#if ") != -1 && StringUtils.countMatches((String)contents, (String)"<#if ") != StringUtils.countMatches((String)contents, (String)"</#if>");
    }

    private boolean isIfEndTag(String contents) {
        return contents.indexOf("</#if>") != -1 && StringUtils.countMatches((String)contents, (String)"<#if ") != StringUtils.countMatches((String)contents, (String)"</#if>");
    }

    private void cellStart(int row, int column, StringBuffer ftl) {
        ftl.append("<c_").append(column).append(">");
    }

    private void cellEnd(int row, int column, StringBuffer ftl) {
        ftl.append("</c_").append(column).append(">");
    }

    private void rowStart(int row, StringBuffer ftl) {
        ftl.append("<r_").append(row).append(">");
    }

    private void rowEnd(int row, StringBuffer ftl) {
        ftl.append("</r_").append(row).append(">");
    }

    private void lineEnd(StringBuffer ftl) {
        ftl.append(LINE_SEPARATOR);
    }
}

