/*
 * Decompiled with CFR 0.152.
 */
package com.letousky.lottery.rule.type;

import com.letousky.exception.LotteryException;
import com.letousky.lottery.rule.type.AbstractLotteryItem;
import com.letousky.lottery.rule.type.CombTool;
import com.letousky.lottery.rule.type.Item;
import com.letousky.lottery.rule.type.LotteryTool;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BiColorItem
extends AbstractLotteryItem {
    private void splitCode(int manner, String code, String multiple) throws LotteryException {
        this.lotteryItem.manner = manner;
        this.lotteryItem.code = code;
        this.lotteryItem.multiple = multiple;
        try {
            switch (this.lotteryItem.getManner()) {
                case 1: {
                    String[] danShi = code.split(",");
                    int i = 0;
                    while (i < danShi.length) {
                        String[] voteNumber = danShi[i].split("//");
                        String[] qiQuNumber = voteNumber[0].split("/");
                        String[] houQuNumber = voteNumber[1].split("/");
                        Item item = new Item();
                        int i1 = 0;
                        while (i1 < qiQuNumber.length) {
                            item.preBalls.add(new Integer(qiQuNumber[i1]));
                            ++i1;
                        }
                        int i2 = 0;
                        while (i2 < houQuNumber.length) {
                            item.backBalls.add(new Integer(houQuNumber[i2]));
                            ++i2;
                        }
                        this.lotteryItem.getItems().add(item);
                        ++i;
                    }
                    break;
                }
                case 2: {
                    String[] fuShi = code.split("//");
                    String[] qiQuNumber = fuShi[0].split("/");
                    String[] houQiNumber = fuShi[1].split("/");
                    Item item = new Item();
                    int i = 0;
                    while (i < qiQuNumber.length) {
                        item.preBalls.add(new Integer(qiQuNumber[i]));
                        ++i;
                    }
                    i = 0;
                    while (i < houQiNumber.length) {
                        item.backBalls.add(new Integer(houQiNumber[i]));
                        ++i;
                    }
                    this.lotteryItem.getItems().add(item);
                    break;
                }
                default: {
                    throw new LotteryException("S032");
                }
            }
        }
        catch (LotteryException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new LotteryException("S032");
        }
    }

    @Override
    public void checkValid(int manner, String code, String multiple) {
        this.splitCode(manner, code, multiple);
        if (!LotteryTool.isMultipleBound(this.lotteryItem.multiple)) {
            throw new LotteryException("U032");
        }
        if (this.lotteryItem.getManner() == 1) {
            int index = 1;
            for (Item record : this.lotteryItem.getItems()) {
                HashSet<Integer> temp = new HashSet<Integer>();
                if (record.preBalls.size() != 6) {
                    throw new LotteryException("U035");
                }
                if (record.backBalls.size() != 1) {
                    throw new LotteryException("U035");
                }
                temp.addAll(record.preBalls);
                if (temp.size() != record.preBalls.size()) {
                    throw new LotteryException("U035");
                }
                temp.clear();
                temp.addAll(record.backBalls);
                if (temp.size() != record.backBalls.size()) {
                    throw new LotteryException("U035");
                }
                if (!CombTool.isIn(record.preBalls, 1, 33)) {
                    throw new LotteryException("U035");
                }
                if (!CombTool.isIn(record.backBalls, 1, 16)) {
                    throw new LotteryException("U035");
                }
                ++index;
            }
        } else if (this.lotteryItem.getManner() == 2) {
            HashSet<Integer> temp = new HashSet<Integer>();
            if (this.lotteryItem.getItems().get((int)0).preBalls.size() < 6) {
                throw new LotteryException("U033");
            }
            if (this.lotteryItem.getItems().get((int)0).backBalls.size() < 1) {
                throw new LotteryException("U034");
            }
            temp.addAll(this.lotteryItem.getItems().get((int)0).preBalls);
            if (temp.size() != this.lotteryItem.getItems().get((int)0).preBalls.size()) {
                throw new LotteryException("U036");
            }
            temp.clear();
            temp.addAll(this.lotteryItem.getItems().get((int)0).backBalls);
            if (temp.size() != this.lotteryItem.getItems().get((int)0).backBalls.size()) {
                throw new LotteryException("U037");
            }
            if (!CombTool.isIn(this.lotteryItem.getItems().get((int)0).preBalls, 1, 33)) {
                throw new LotteryException("U038");
            }
            if (!CombTool.isIn(this.lotteryItem.getItems().get((int)0).backBalls, 1, 16)) {
                throw new LotteryException("U039");
            }
            if (this.lotteryItem.getItems().get((int)0).preBalls.size() + this.lotteryItem.getItems().get((int)0).backBalls.size() < 8) {
                throw new LotteryException("U035");
            }
        }
    }

    @Override
    public int getRecordCount() {
        if (this.lotteryItem.getManner() == 1) {
            return this.lotteryItem.getItems().size();
        }
        if (this.lotteryItem.getManner() == 2) {
            int preCount = this.lotteryItem.getItems().get((int)0).preBalls.size();
            int backCount = this.lotteryItem.getItems().get((int)0).backBalls.size();
            preCount = CombTool.getCombCount(preCount, 6);
            backCount = CombTool.getCombCount(backCount, 1);
            return preCount * backCount;
        }
        this.lotteryItem.getManner();
        return 1;
    }

    @Override
    public int getVoteMoney() {
        return this.getRecordCount() * 2 * Integer.parseInt(this.lotteryItem.getMultiple());
    }

    @Override
    public List<Item> getAllRecodes() {
        ArrayList<Item> ret = new ArrayList<Item>();
        if (this.lotteryItem.getManner() == 1) {
            return this.lotteryItem.items;
        }
        if (this.lotteryItem.getManner() == 2) {
            List<List<Integer>> preComb = CombTool.getCombList(this.lotteryItem.items.get((int)0).preBalls, 6);
            List<List<Integer>> backComb = CombTool.getCombList(this.lotteryItem.items.get((int)0).backBalls, 1);
            int preSize = preComb.size();
            int backSize = backComb.size();
            int i = 0;
            while (i < preSize) {
                int k = 0;
                while (k < backSize) {
                    Item item = new Item();
                    item.preBalls.addAll((Collection<Integer>)preComb.get(i));
                    item.backBalls.addAll((Collection<Integer>)backComb.get(k));
                    ret.add(item);
                    ++k;
                }
                ++i;
            }
        } else {
            this.lotteryItem.getManner();
        }
        return ret;
    }

    public int getManage() {
        return this.lotteryItem.getManner();
    }
}

