/*
 * Decompiled with CFR 0.152.
 */
package com.letousky.lottery.rule.type;

import com.letousky.exception.LotteryException;
import com.letousky.lottery.rule.type.AbstractLotteryItem;
import com.letousky.lottery.rule.type.CombTool;
import com.letousky.lottery.rule.type.Item;
import com.letousky.lottery.rule.type.LotteryTool;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BigLotteryItem
extends AbstractLotteryItem {
    private void splitCode(int manner, String code, String multiple) throws LotteryException {
        this.lotteryItem.manner = manner;
        this.lotteryItem.code = code;
        this.lotteryItem.multiple = multiple;
        try {
            switch (this.lotteryItem.manner) {
                case 1: 
                case 5: 
                case 8: {
                    String[] danShi = code.split(",");
                    int i = 0;
                    while (i < danShi.length) {
                        String[] voteNumber = danShi[i].split("//");
                        String[] qiQuNumber = voteNumber[0].split("/");
                        Item item = new Item();
                        int i1 = 0;
                        while (i1 < qiQuNumber.length) {
                            item.preBalls.add(new Integer(qiQuNumber[i1]));
                            ++i1;
                        }
                        if (voteNumber.length == 2) {
                            String[] houQuNumber = voteNumber[1].split("/");
                            int i2 = 0;
                            while (i2 < houQuNumber.length) {
                                item.backBalls.add(new Integer(houQuNumber[i2]));
                                ++i2;
                            }
                        }
                        this.lotteryItem.getItems().add(item);
                        ++i;
                    }
                    break;
                }
                case 2: 
                case 6: {
                    String[] fuShi = code.split("//");
                    String[] qiQuNumber = fuShi[0].split("/");
                    String[] houQiNumber = fuShi[1].split("/");
                    Item item = new Item();
                    int i = 0;
                    while (i < qiQuNumber.length) {
                        item.preBalls.add(new Integer(qiQuNumber[i]));
                        ++i;
                    }
                    i = 0;
                    while (i < houQiNumber.length) {
                        item.backBalls.add(new Integer(houQiNumber[i]));
                        ++i;
                    }
                    this.lotteryItem.getItems().add(item);
                    break;
                }
                case 3: 
                case 7: {
                    int k;
                    int k2;
                    Item item1 = new Item();
                    String[] nums = code.split(",");
                    String[] prenums = nums[0].split("//");
                    String[] preInc = null;
                    String[] preI = null;
                    if (prenums.length == 2) {
                        preInc = prenums[0].split("/");
                        preI = prenums[1].split("/");
                        k2 = 0;
                        while (k2 < preInc.length) {
                            this.lotteryItem.preInclude.add(Integer.valueOf(preInc[k2]));
                            ++k2;
                        }
                    } else if (prenums.length == 1) {
                        preI = prenums[0].split("/");
                    }
                    k2 = 0;
                    while (k2 < preI.length) {
                        item1.preBalls.add(Integer.valueOf(preI[k2]));
                        ++k2;
                    }
                    String[] backnums = nums[1].split("//");
                    String[] backInc = null;
                    String[] backI = null;
                    if (backnums.length == 2) {
                        backInc = backnums[0].split("/");
                        backI = backnums[1].split("/");
                        k = 0;
                        while (k < backInc.length) {
                            this.lotteryItem.backInclude.add(Integer.valueOf(backInc[k]));
                            ++k;
                        }
                    } else if (backnums.length == 1) {
                        backI = backnums[0].split("/");
                    }
                    k = 0;
                    while (k < backI.length) {
                        item1.backBalls.add(Integer.valueOf(backI[k]));
                        ++k;
                    }
                    this.lotteryItem.items.add(item1);
                    break;
                }
                case 9: {
                    String[] reds = code.split("/");
                    Item item2 = new Item();
                    int k = 0;
                    while (k < reds.length) {
                        item2.preBalls.add(Integer.valueOf(reds[k]));
                        ++k;
                    }
                    this.lotteryItem.items.add(item2);
                    break;
                }
                default: {
                    throw new LotteryException("U085");
                }
            }
        }
        catch (NumberFormatException e) {
            throw new LotteryException("U040");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new LotteryException("U041");
        }
    }

    @Override
    public void checkValid(int manner, String code, String multiple) throws LotteryException {
        this.splitCode(manner, code, multiple);
        if (!LotteryTool.isMultipleBound(this.lotteryItem.multiple)) {
            throw new LotteryException("U032");
        }
        if (this.lotteryItem.manner == 1 || this.lotteryItem.manner == 5) {
            int index = 1;
            for (Item record : this.lotteryItem.items) {
                HashSet<Integer> temp = new HashSet<Integer>();
                if (record.preBalls.size() != 5) {
                    throw new LotteryException("U035");
                }
                if (record.backBalls.size() != 2) {
                    throw new LotteryException("U035");
                }
                temp.addAll(record.preBalls);
                if (temp.size() != record.preBalls.size()) {
                    throw new LotteryException("U035");
                }
                temp.clear();
                temp.addAll(record.backBalls);
                if (temp.size() != record.backBalls.size()) {
                    throw new LotteryException("U035");
                }
                if (!CombTool.isIn(record.preBalls, 1, 35)) {
                    throw new LotteryException("U035");
                }
                if (!CombTool.isIn(record.backBalls, 1, 12)) {
                    throw new LotteryException("U035");
                }
                ++index;
            }
        } else if (this.lotteryItem.manner == 2 || this.lotteryItem.manner == 6) {
            HashSet<Integer> temp = new HashSet<Integer>();
            if (this.lotteryItem.items.get((int)0).preBalls.size() < 5) {
                throw new LotteryException("U089");
            }
            if (this.lotteryItem.items.get((int)0).preBalls.size() == 5 && this.lotteryItem.items.get((int)0).backBalls.size() == 2) {
                throw new LotteryException("U090");
            }
            if (this.lotteryItem.items.get((int)0).backBalls.size() < 2) {
                throw new LotteryException("U091");
            }
            temp.addAll(this.lotteryItem.items.get((int)0).preBalls);
            if (temp.size() != this.lotteryItem.items.get((int)0).preBalls.size()) {
                throw new LotteryException("U092");
            }
            temp.clear();
            temp.addAll(this.lotteryItem.items.get((int)0).backBalls);
            if (temp.size() != this.lotteryItem.items.get((int)0).backBalls.size()) {
                throw new LotteryException("U093");
            }
            if (!CombTool.isIn(this.lotteryItem.items.get((int)0).preBalls, 1, 35)) {
                throw new LotteryException("U094");
            }
            if (!CombTool.isIn(this.lotteryItem.items.get((int)0).backBalls, 1, 12)) {
                throw new LotteryException("U095");
            }
        } else if (this.lotteryItem.manner == 3 || this.lotteryItem.manner == 7) {
            if (this.lotteryItem.items.get((int)0).preBalls.size() + this.lotteryItem.preInclude.size() < 5) {
                throw new LotteryException("U096");
            }
            if (this.lotteryItem.items.get((int)0).backBalls.size() + this.lotteryItem.backInclude.size() < 2) {
                throw new LotteryException("U097");
            }
            if (this.lotteryItem.items.get((int)0).preBalls.size() + this.lotteryItem.preInclude.size() == 5 && this.lotteryItem.items.get((int)0).backBalls.size() + this.lotteryItem.backInclude.size() == 2) {
                throw new LotteryException("U098");
            }
            if (this.lotteryItem.preInclude.size() == 0 && this.lotteryItem.backInclude.size() == 0) {
                throw new LotteryException("U099");
            }
            if (this.lotteryItem.preInclude.size() > 4) {
                throw new LotteryException("U125");
            }
            if (this.lotteryItem.backInclude.size() > 1) {
                throw new LotteryException("U126");
            }
            HashSet<Integer> temp = new HashSet<Integer>();
            temp.addAll(this.lotteryItem.items.get((int)0).preBalls);
            if (temp.size() != this.lotteryItem.items.get((int)0).preBalls.size()) {
                throw new LotteryException("U100");
            }
            temp.clear();
            temp.addAll(this.lotteryItem.items.get((int)0).backBalls);
            if (temp.size() != this.lotteryItem.items.get((int)0).backBalls.size()) {
                throw new LotteryException("U101");
            }
            temp.clear();
            temp.addAll(this.lotteryItem.preInclude);
            if (temp.size() != this.lotteryItem.preInclude.size()) {
                throw new LotteryException("U102");
            }
            temp.clear();
            temp.addAll(this.lotteryItem.backInclude);
            if (temp.size() != this.lotteryItem.backInclude.size()) {
                throw new LotteryException("U103");
            }
            if (!CombTool.isIn(this.lotteryItem.items.get((int)0).preBalls, 1, 35)) {
                throw new LotteryException("U094");
            }
            if (!CombTool.isIn(this.lotteryItem.items.get((int)0).backBalls, 1, 12)) {
                throw new LotteryException("U095");
            }
            if (!CombTool.isIn(this.lotteryItem.preInclude, 1, 35)) {
                throw new LotteryException("U104");
            }
            if (!CombTool.isIn(this.lotteryItem.backInclude, 1, 12)) {
                throw new LotteryException("U105");
            }
            if (CombTool.isIn(this.lotteryItem.preInclude, this.lotteryItem.items.get((int)0).preBalls)) {
                throw new LotteryException("U106");
            }
            if (CombTool.isIn(this.lotteryItem.backInclude, this.lotteryItem.items.get((int)0).backBalls)) {
                throw new LotteryException("U107");
            }
        } else if (this.lotteryItem.manner == 8) {
            int index = 1;
            for (Item record : this.lotteryItem.items) {
                HashSet<Integer> temp = new HashSet<Integer>();
                if (record.preBalls.size() != 2) {
                    throw new LotteryException("U035");
                }
                temp.addAll(record.preBalls);
                if (temp.size() != record.preBalls.size()) {
                    throw new LotteryException("U035");
                }
                temp.clear();
                if (!CombTool.isIn(record.preBalls, 1, 12)) {
                    throw new LotteryException("U035");
                }
                ++index;
            }
        } else if (this.lotteryItem.manner == 9) {
            HashSet<Integer> temp = new HashSet<Integer>();
            if (this.lotteryItem.items.get((int)0).preBalls.size() <= 2) {
                throw new LotteryException("U108");
            }
            temp.addAll(this.lotteryItem.items.get((int)0).preBalls);
            if (temp.size() != this.lotteryItem.items.get((int)0).preBalls.size()) {
                throw new LotteryException("U044");
            }
            if (!CombTool.isIn(this.lotteryItem.items.get((int)0).preBalls, 1, 12)) {
                throw new LotteryException("U054");
            }
        }
    }

    @Override
    public int getRecordCount() {
        if (this.lotteryItem.getManner() == 1 || this.lotteryItem.getManner() == 5 || this.lotteryItem.getManner() == 8) {
            return this.lotteryItem.items.size();
        }
        if (this.lotteryItem.getManner() == 2 || this.lotteryItem.getManner() == 6) {
            int preCount = this.lotteryItem.items.get((int)0).preBalls.size();
            int backCount = this.lotteryItem.items.get((int)0).backBalls.size();
            preCount = CombTool.getCombCount(preCount, 5);
            backCount = CombTool.getCombCount(backCount, 2);
            return preCount * backCount;
        }
        if (this.lotteryItem.getManner() == 3 || this.lotteryItem.getManner() == 7) {
            int preCount = this.lotteryItem.items.get((int)0).preBalls.size();
            int backCount = this.lotteryItem.items.get((int)0).backBalls.size();
            int preInc = this.lotteryItem.preInclude.size();
            int backInc = this.lotteryItem.backInclude.size();
            preCount = CombTool.getCombCount(preCount, 5 - preInc);
            backCount = CombTool.getCombCount(backCount, 2 - backInc);
            return preCount * backCount;
        }
        if (this.lotteryItem.getManner() == 2 || this.lotteryItem.getManner() == 9) {
            int preCount = this.lotteryItem.items.get((int)0).preBalls.size();
            preCount = CombTool.getCombCount(preCount, 2);
            return preCount;
        }
        return 0;
    }

    @Override
    public int getVoteMoney() {
        if (this.lotteryItem.getManner() == 5 || this.lotteryItem.getManner() == 6 || this.lotteryItem.getManner() == 7) {
            return this.getRecordCount() * 3 * Integer.parseInt(this.lotteryItem.getMultiple());
        }
        return this.getRecordCount() * 2 * Integer.parseInt(this.lotteryItem.getMultiple());
    }

    @Override
    public List<Item> getAllRecodes() {
        ArrayList<Item> ret;
        block7: {
            block8: {
                block6: {
                    ret = new ArrayList<Item>();
                    if (this.lotteryItem.getManner() == 1 || this.lotteryItem.getManner() == 5 || this.lotteryItem.getManner() == 8) {
                        return this.lotteryItem.items;
                    }
                    if (this.lotteryItem.getManner() != 2 && this.lotteryItem.getManner() != 6) break block6;
                    List<List<Integer>> preComb = CombTool.getCombList(this.lotteryItem.items.get((int)0).preBalls, 5);
                    List<List<Integer>> backComb = CombTool.getCombList(this.lotteryItem.items.get((int)0).backBalls, 2);
                    int preSize = preComb.size();
                    int backSize = backComb.size();
                    int i = 0;
                    while (i < preSize) {
                        int k = 0;
                        while (k < backSize) {
                            Item item = new Item();
                            item.preBalls.addAll((Collection<Integer>)preComb.get(i));
                            item.backBalls.addAll((Collection<Integer>)backComb.get(k));
                            ret.add(item);
                            ++k;
                        }
                        ++i;
                    }
                    break block7;
                }
                if (this.lotteryItem.getManner() != 9) break block8;
                List<List<Integer>> preComb = CombTool.getCombList(this.lotteryItem.items.get((int)0).preBalls, 2);
                int preSize = preComb.size();
                int i = 0;
                while (i < preSize) {
                    Item item = new Item();
                    item.preBalls.addAll((Collection<Integer>)preComb.get(i));
                    ret.add(item);
                    ++i;
                }
                break block7;
            }
            if (this.lotteryItem.getManner() != 3 && this.lotteryItem.getManner() != 7) break block7;
            CombTool tool = new CombTool();
            int preInc = this.lotteryItem.preInclude.size();
            int backInc = this.lotteryItem.backInclude.size();
            List<List<Integer>> preComb = CombTool.getCombList(this.lotteryItem.items.get((int)0).preBalls, 5 - preInc);
            List<List<Integer>> backComb = CombTool.getCombList(this.lotteryItem.items.get((int)0).backBalls, 2 - backInc);
            int preSize = preComb.size();
            int backSize = backComb.size();
            int i = 0;
            while (i < preSize) {
                int k = 0;
                while (k < backSize) {
                    Item item = new Item();
                    item.preBalls.addAll(this.lotteryItem.preInclude);
                    item.preBalls.addAll((Collection<Integer>)preComb.get(i));
                    item.backBalls.addAll(this.lotteryItem.backInclude);
                    item.backBalls.addAll((Collection<Integer>)backComb.get(k));
                    ret.add(item);
                    ++k;
                }
                ++i;
            }
        }
        return ret;
    }

    public int getCosts() {
        if (this.lotteryItem.getManner() > 4 && this.lotteryItem.getManner() < 8) {
            return this.getRecordCount() * 3 * Integer.valueOf(this.lotteryItem.multiple);
        }
        return this.getRecordCount() * 2 * Integer.valueOf(this.lotteryItem.multiple);
    }
}

