/*
 * Decompiled with CFR 0.152.
 */
package com.letousky.lottery.rule.type;

import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CombTool {
    List<Integer> init;
    ArrayList<Integer> end = new ArrayList();
    List<List<Integer>> dest = new ArrayList<List<Integer>>();
    int n;
    int m;

    public static boolean isIn(List<Integer> source, int start, int end) {
        boolean ret = true;
        for (int i : source) {
            if (i >= start && i <= end) continue;
            return false;
        }
        return ret;
    }

    public static boolean isIn(List<Integer> source, List<Integer> source2) {
        int i = 0;
        while (i < source.size()) {
            if (source2.contains(source.get(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static List<List<Integer>> getCombList(List<Integer> source, int m) {
        CombTool tool = new CombTool();
        tool.init = source;
        int i = 0;
        while (i < m) {
            tool.end.add(0);
            ++i;
        }
        tool.m = m;
        tool.combo();
        return tool.dest;
    }

    public void combo() {
        this.n = this.init.size();
        this.choose(0, 0);
    }

    public void choose(int k, int l) {
        if (l == this.m) {
            this.dest.add((List)this.end.clone());
        } else if (this.n - k == this.m - l) {
            int i = 0;
            while (i < this.m - l) {
                this.end.set(l + i, this.init.get(k + i));
                ++i;
            }
            this.dest.add((List)this.end.clone());
        } else {
            this.end.set(l, this.init.get(k));
            this.choose(k + 1, l + 1);
            this.choose(k + 1, l);
        }
    }

    public static int getCombCount(int m, int n) {
        if (m < n) {
            throw new RuntimeException("getCombCount m>n");
        }
        if (n > m / 2) {
            n = m - n;
        }
        if (n == 0) {
            return 1;
        }
        long ret = CombTool.getPermutation(m, n);
        int iret = (int)(ret /= CombTool.stepMul(n));
        if ((long)iret != ret) {
            throw new RuntimeException("getCombCount bigger than integer");
        }
        return iret;
    }

    public static long getPermutation(int m, int n) {
        if (m < n) {
            throw new RuntimeException("getPermutation m>n");
        }
        long ret = 1L;
        int i = 0;
        while (i < n) {
            ret *= (long)(m - i);
            ++i;
        }
        return ret;
    }

    public static long stepMul(int n) {
        if (n == 1) {
            return 1L;
        }
        return (long)n * CombTool.stepMul(n - 1);
    }

    public static void main(String[] args) {
        System.out.println("test:" + CombTool.getCombCount(7, 2));
    }
}

