/*
 * Decompiled with CFR 0.152.
 */
package com.letousky.lottery.rule.type;

import com.letousky.exception.LotteryException;
import com.letousky.lottery.rule.type.AbstractLotteryItem;
import com.letousky.lottery.rule.type.CombTool;
import com.letousky.lottery.rule.type.Item;
import com.letousky.lottery.rule.type.LotteryTool;
import com.letousky.lottery.rule.util.PGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class P3Item
extends AbstractLotteryItem {
    private void splitCode(int manner, String code, String multiple) throws LotteryException {
        this.lotteryItem.manner = manner;
        this.lotteryItem.code = code;
        this.lotteryItem.multiple = multiple;
        try {
            switch (this.lotteryItem.getManner()) {
                case 11: 
                case 13: 
                case 16: {
                    String[] danzhus = code.split(",");
                    int i = 0;
                    while (i < danzhus.length) {
                        String[] reds = danzhus[i].split("/");
                        if (reds.length != 3) {
                            throw new LotteryException("U053");
                        }
                        Item item = new Item();
                        int k = 0;
                        while (k < reds.length) {
                            item.preBalls.add(Integer.valueOf(reds[k]));
                            ++k;
                        }
                        if (!CombTool.isIn(item.preBalls, 0, 9)) {
                            throw new LotteryException("U054");
                        }
                        if (this.lotteryItem.getManner() == 13 && LotteryTool.getUniqueCount(item.preBalls) != 2) {
                            throw new LotteryException("U055");
                        }
                        if (this.lotteryItem.getManner() == 16 && LotteryTool.getUniqueCount(item.preBalls) != 3) {
                            throw new LotteryException("U056");
                        }
                        this.lotteryItem.items.add(item);
                        ++i;
                    }
                    break;
                }
                case 21: {
                    String[] nums = code.split("//");
                    String[] bei = nums[0].split("/");
                    String[] shi = nums[1].split("/");
                    String[] ge = nums[2].split("/");
                    if (nums.length > 3 || nums.length < 2) {
                        throw new LotteryException("U035");
                    }
                    if (!LotteryTool.isUnique(bei)) {
                        throw new LotteryException("U057");
                    }
                    if (!LotteryTool.isIn(bei, 0, 9)) {
                        throw new LotteryException("U054");
                    }
                    if (!LotteryTool.isUnique(shi)) {
                        throw new LotteryException("U058");
                    }
                    if (!LotteryTool.isIn(shi, 0, 9)) {
                        throw new LotteryException("U054");
                    }
                    if (!LotteryTool.isUnique(ge)) {
                        throw new LotteryException("U059");
                    }
                    if (!LotteryTool.isIn(ge, 0, 9)) {
                        throw new LotteryException("U054");
                    }
                    int i = 0;
                    while (i < bei.length) {
                        int j = 0;
                        while (j < shi.length) {
                            int k = 0;
                            while (k < ge.length) {
                                Item item = new Item();
                                item.preBalls.add(Integer.valueOf(bei[i]));
                                item.preBalls.add(Integer.valueOf(shi[j]));
                                item.preBalls.add(Integer.valueOf(ge[k]));
                                this.lotteryItem.items.add(item);
                                ++k;
                            }
                            ++j;
                        }
                        ++i;
                    }
                    break;
                }
                case 23: 
                case 26: 
                case 31: 
                case 32: {
                    String[] numszhu3 = code.split("/");
                    if (!LotteryTool.isUnique(numszhu3)) {
                        throw new LotteryException("U044");
                    }
                    Item item = new Item();
                    int i = 0;
                    while (i < numszhu3.length) {
                        item.preBalls.add(Integer.valueOf(numszhu3[i]));
                        ++i;
                    }
                    this.lotteryItem.items.add(item);
                    break;
                }
                case 51: {
                    String[] hao = code.split("//");
                    String[] danHao = hao[0].split("/");
                    String[] touHao = hao[1].split("/");
                    if (danHao.length <= 0 || danHao.length > 2) {
                        throw new LotteryException("U188");
                    }
                    int length = danHao.length + touHao.length;
                    if (length < 4) {
                        throw new LotteryException("U189");
                    }
                    Item zhiXuanDantouItem = new Item();
                    int i = 0;
                    while (i < danHao.length) {
                        this.lotteryItem.preInclude.add(Integer.parseInt(danHao[i]));
                        ++i;
                    }
                    i = 0;
                    while (i < touHao.length) {
                        zhiXuanDantouItem.preBalls.add(Integer.parseInt(touHao[i]));
                        ++i;
                    }
                    i = 0;
                    while (i < this.lotteryItem.preInclude.size()) {
                        if (zhiXuanDantouItem.preBalls.contains(this.lotteryItem.preInclude.get(i))) {
                            throw new LotteryException("U190");
                        }
                        ++i;
                    }
                    ArrayList<Item> splitList = new ArrayList<Item>();
                    int preInc = this.lotteryItem.preInclude.size();
                    List<List<Integer>> preComb = CombTool.getCombList(zhiXuanDantouItem.preBalls, 3 - preInc);
                    int preSize = preComb.size();
                    int i2 = 0;
                    while (i2 < preSize) {
                        Item tempItem = new Item();
                        tempItem.preBalls.addAll(this.lotteryItem.preInclude);
                        tempItem.preBalls.addAll((Collection<Integer>)preComb.get(i2));
                        splitList.add(tempItem);
                        ++i2;
                    }
                    i2 = 0;
                    while (i2 < splitList.size()) {
                        Item splitItem = (Item)splitList.get(i2);
                        String splitHao = splitItem.getItemStr(splitItem);
                        String[] splitHaoStr = splitHao.split("/");
                        PGenerator permutation = new PGenerator(splitHaoStr.length);
                        while (permutation.hasMore()) {
                            int[] indices = permutation.getNext();
                            Item item_a = new Item();
                            int j = 0;
                            while (j < indices.length) {
                                item_a.preBalls.add(Integer.parseInt(splitHaoStr[indices[j]]));
                                ++j;
                            }
                            this.lotteryItem.items.add(item_a);
                        }
                        ++i2;
                    }
                    break;
                }
                case 52: {
                    Item tempItem;
                    String[] sanHao = code.split("//");
                    String[] sanDanHao = sanHao[0].split("/");
                    String[] sanTouHao = sanHao[1].split("/");
                    if (sanDanHao.length != 1) {
                        throw new LotteryException("U191");
                    }
                    if (sanTouHao.length < 2 || sanTouHao.length > 9) {
                        throw new LotteryException("U192");
                    }
                    Item zuXuanSanDanTouItem = new Item();
                    int i = 0;
                    while (i < sanDanHao.length) {
                        this.lotteryItem.preInclude.add(Integer.parseInt(sanDanHao[i]));
                        ++i;
                    }
                    i = 0;
                    while (i < sanTouHao.length) {
                        zuXuanSanDanTouItem.preBalls.add(Integer.parseInt(sanTouHao[i]));
                        ++i;
                    }
                    ArrayList splitTempList = new ArrayList();
                    int preIncc = this.lotteryItem.preInclude.size();
                    List<List<Integer>> preCombb = CombTool.getCombList(zuXuanSanDanTouItem.preBalls, 1);
                    int preSizes = preCombb.size();
                    int i3 = 0;
                    while (i3 < preSizes) {
                        tempItem = new Item();
                        tempItem.preBalls.addAll(this.lotteryItem.preInclude);
                        tempItem.preBalls.addAll(this.lotteryItem.preInclude);
                        tempItem.preBalls.addAll((Collection<Integer>)preCombb.get(i3));
                        this.lotteryItem.items.add(tempItem);
                        ++i3;
                    }
                    i3 = 0;
                    while (i3 < preSizes) {
                        tempItem = new Item();
                        tempItem.preBalls.addAll(this.lotteryItem.preInclude);
                        tempItem.preBalls.addAll((Collection<Integer>)preCombb.get(i3));
                        tempItem.preBalls.addAll((Collection<Integer>)preCombb.get(i3));
                        this.lotteryItem.items.add(tempItem);
                        ++i3;
                    }
                    break;
                }
                case 53: {
                    String[] zuLiuHao = code.split("//");
                    String[] zuLiuDanHao = zuLiuHao[0].split("/");
                    String[] zuLiuTouHao = zuLiuHao[1].split("/");
                    if (zuLiuDanHao.length <= 0 || zuLiuDanHao.length > 2) {
                        throw new LotteryException("U188");
                    }
                    int zuLiuLength = zuLiuDanHao.length + zuLiuTouHao.length;
                    if (zuLiuLength < 4) {
                        throw new LotteryException("U189");
                    }
                    Item zuLiuDantouItem = new Item();
                    int i = 0;
                    while (i < zuLiuDanHao.length) {
                        this.lotteryItem.preInclude.add(Integer.parseInt(zuLiuDanHao[i]));
                        ++i;
                    }
                    i = 0;
                    while (i < zuLiuTouHao.length) {
                        zuLiuDantouItem.preBalls.add(Integer.parseInt(zuLiuTouHao[i]));
                        ++i;
                    }
                    i = 0;
                    while (i < this.lotteryItem.preInclude.size()) {
                        if (zuLiuDantouItem.preBalls.contains(this.lotteryItem.preInclude.get(i))) {
                            throw new LotteryException("U190");
                        }
                        ++i;
                    }
                    ArrayList<Item> zuLiuSplitList = new ArrayList<Item>();
                    int preInccc = this.lotteryItem.preInclude.size();
                    List<List<Integer>> preCombbb = CombTool.getCombList(zuLiuDantouItem.preBalls, 3 - preInccc);
                    int preSizeeee = preCombbb.size();
                    int i4 = 0;
                    while (i4 < preSizeeee) {
                        Item tempItem = new Item();
                        tempItem.preBalls.addAll(this.lotteryItem.preInclude);
                        tempItem.preBalls.addAll((Collection<Integer>)preCombbb.get(i4));
                        zuLiuSplitList.add(tempItem);
                        ++i4;
                    }
                    i4 = 0;
                    while (i4 < zuLiuSplitList.size()) {
                        Item splitItem = (Item)zuLiuSplitList.get(i4);
                        String splitHao = splitItem.getItemStr(splitItem);
                        String[] splitHaoStr = splitHao.split("/");
                        PGenerator permutation = new PGenerator(splitHaoStr.length);
                        while (permutation.hasMore()) {
                            int[] indices = permutation.getNext();
                            Item item_a = new Item();
                            int j = 0;
                            while (j < indices.length) {
                                item_a.preBalls.add(Integer.parseInt(splitHaoStr[indices[j]]));
                                ++j;
                            }
                            if (this.lotteryItem.items.contains(item_a)) continue;
                            this.lotteryItem.items.add(item_a);
                        }
                        ++i4;
                    }
                    break;
                }
                default: {
                    throw new LotteryException("U085");
                }
            }
        }
        catch (NumberFormatException e) {
            throw new LotteryException("U040");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new LotteryException("U041");
        }
    }

    @Override
    public void checkValid(int manner, String code, String multiple) throws LotteryException {
        this.splitCode(manner, code, multiple);
        if (!LotteryTool.isMultipleBound(this.lotteryItem.multiple)) {
            throw new LotteryException("U032");
        }
        switch (this.lotteryItem.manner) {
            case 11: 
            case 13: 
            case 16: {
                break;
            }
            case 21: {
                if (this.lotteryItem.items.size() >= 2) break;
                throw new LotteryException("U060");
            }
            case 23: {
                if (this.lotteryItem.items.get((int)0).preBalls.size() > 10) {
                    throw new LotteryException("U061");
                }
                if (this.lotteryItem.items.get((int)0).preBalls.size() >= 2) break;
                throw new LotteryException("U062");
            }
            case 26: {
                if (this.lotteryItem.items.get((int)0).preBalls.size() <= 10 && this.lotteryItem.items.get((int)0).preBalls.size() >= 4) break;
                throw new LotteryException("U063");
            }
            case 31: {
                if (this.lotteryItem.items.get((int)0).preBalls.size() != 1) {
                    throw new LotteryException("U064");
                }
                int sum = this.lotteryItem.items.get((int)0).preBalls.get(0);
                if (sum >= 0 && sum <= 27) break;
                throw new LotteryException("U065");
            }
            case 32: {
                if (this.lotteryItem.items.get((int)0).preBalls.size() != 1) {
                    throw new LotteryException("U064");
                }
                int sum = this.lotteryItem.items.get((int)0).preBalls.get(0);
                if (sum >= 1 && sum <= 26) break;
                throw new LotteryException("U066");
            }
        }
    }

    @Override
    public int getRecordCount() {
        int r = 0;
        switch (this.lotteryItem.manner) {
            case 11: 
            case 13: 
            case 16: 
            case 21: 
            case 51: 
            case 52: 
            case 53: {
                r = this.lotteryItem.items.size();
                break;
            }
            case 23: {
                r = this.lotteryItem.items.get((int)0).preBalls.size() * (this.lotteryItem.items.get((int)0).preBalls.size() - 1);
                break;
            }
            case 26: {
                r = CombTool.getCombCount(this.lotteryItem.items.get((int)0).preBalls.size(), 3);
                break;
            }
            case 31: {
                int i = 0;
                while (i < 10) {
                    int j = 0;
                    while (j < 10) {
                        int k = 0;
                        while (k < 10) {
                            if (i + j + k == this.lotteryItem.items.get((int)0).preBalls.get(0)) {
                                ++r;
                            }
                            ++k;
                        }
                        ++j;
                    }
                    ++i;
                }
                break;
            }
            case 32: {
                int i = 0;
                while (i < 10) {
                    int j = i;
                    while (j < 10) {
                        int k = j;
                        while (k < 10) {
                            if (i + j + k == this.lotteryItem.items.get((int)0).preBalls.get(0) && (i != j || j != k)) {
                                ++r;
                            }
                            ++k;
                        }
                        ++j;
                    }
                    ++i;
                }
                break;
            }
        }
        return r;
    }

    @Override
    public int getVoteMoney() {
        return this.getRecordCount() * 2 * Integer.parseInt(this.lotteryItem.getMultiple());
    }

    @Override
    public List<Item> getAllRecodes() {
        ArrayList<Item> ret = new ArrayList<Item>();
        switch (this.lotteryItem.getManner()) {
            case 11: 
            case 13: 
            case 16: 
            case 21: 
            case 51: 
            case 52: 
            case 53: {
                ret.addAll(this.lotteryItem.items);
                break;
            }
            case 23: {
                int i = 0;
                while (i < this.lotteryItem.items.get((int)0).preBalls.size()) {
                    int j = i;
                    while (j < this.lotteryItem.items.get((int)0).preBalls.size()) {
                        int k = j;
                        while (k < this.lotteryItem.items.get((int)0).preBalls.size()) {
                            if (!(this.lotteryItem.items.get((int)0).preBalls.get(i).equals(this.lotteryItem.items.get((int)0).preBalls.get(j)) && this.lotteryItem.items.get((int)0).preBalls.get(j).equals(this.lotteryItem.items.get((int)0).preBalls.get(k)) || !this.lotteryItem.items.get((int)0).preBalls.get(i).equals(this.lotteryItem.items.get((int)0).preBalls.get(j)) && !this.lotteryItem.items.get((int)0).preBalls.get(j).equals(this.lotteryItem.items.get((int)0).preBalls.get(k)))) {
                                Item item = new Item();
                                item.preBalls.add(this.lotteryItem.items.get((int)0).preBalls.get(i));
                                item.preBalls.add(this.lotteryItem.items.get((int)0).preBalls.get(j));
                                item.preBalls.add(this.lotteryItem.items.get((int)0).preBalls.get(k));
                                ret.add(item);
                            }
                            ++k;
                        }
                        ++j;
                    }
                    ++i;
                }
                break;
            }
            case 26: {
                int i = 0;
                while (i < this.lotteryItem.items.get((int)0).preBalls.size()) {
                    int j = i + 1;
                    while (j < this.lotteryItem.items.get((int)0).preBalls.size()) {
                        int k = j + 1;
                        while (k < this.lotteryItem.items.get((int)0).preBalls.size()) {
                            Item item = new Item();
                            item.preBalls.add(this.lotteryItem.items.get((int)0).preBalls.get(i));
                            item.preBalls.add(this.lotteryItem.items.get((int)0).preBalls.get(j));
                            item.preBalls.add(this.lotteryItem.items.get((int)0).preBalls.get(k));
                            ret.add(item);
                            ++k;
                        }
                        ++j;
                    }
                    ++i;
                }
                break;
            }
            case 31: {
                int i = 0;
                while (i < 10) {
                    int j = 0;
                    while (j < 10) {
                        int k = 0;
                        while (k < 10) {
                            if (i + j + k == this.lotteryItem.items.get((int)0).preBalls.get(0)) {
                                Item item = new Item();
                                item.preBalls.add(i);
                                item.preBalls.add(j);
                                item.preBalls.add(k);
                                ret.add(item);
                            }
                            ++k;
                        }
                        ++j;
                    }
                    ++i;
                }
                break;
            }
            case 32: {
                int i = 0;
                while (i < 10) {
                    int j = i;
                    while (j < 10) {
                        int k = j;
                        while (k < 10) {
                            if (i + j + k == this.lotteryItem.items.get((int)0).preBalls.get(0) && (i != j || j != k)) {
                                Item item = new Item();
                                item.preBalls.add(i);
                                item.preBalls.add(j);
                                item.preBalls.add(k);
                                ret.add(item);
                            }
                            ++k;
                        }
                        ++j;
                    }
                    ++i;
                }
                break;
            }
        }
        return ret;
    }
}

