/*
 * Decompiled with CFR 0.152.
 */
package com.letousky.lottery.rule.util;

import java.math.BigInteger;

public class PGenerator {
    private int[] a;
    private BigInteger numLeft;
    private BigInteger total;

    public PGenerator(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("Min 1");
        }
        this.a = new int[n];
        this.total = PGenerator.getFactorial(n);
        this.reset();
    }

    public void reset() {
        int i = 0;
        while (i < this.a.length) {
            this.a[i] = i;
            ++i;
        }
        this.numLeft = new BigInteger(this.total.toString());
    }

    public BigInteger getNumLeft() {
        return this.numLeft;
    }

    public BigInteger getTotal() {
        return this.total;
    }

    public boolean hasMore() {
        return this.numLeft.compareTo(BigInteger.ZERO) == 1;
    }

    private static BigInteger getFactorial(int n) {
        BigInteger fact = BigInteger.ONE;
        int i = n;
        while (i > 1) {
            fact = fact.multiply(new BigInteger(Integer.toString(i)));
            --i;
        }
        return fact;
    }

    public int[] getNext() {
        if (this.numLeft.equals(this.total)) {
            this.numLeft = this.numLeft.subtract(BigInteger.ONE);
            return this.a;
        }
        int j = this.a.length - 2;
        while (this.a[j] > this.a[j + 1]) {
            --j;
        }
        int k = this.a.length - 1;
        while (this.a[j] > this.a[k]) {
            --k;
        }
        int temp = this.a[k];
        this.a[k] = this.a[j];
        this.a[j] = temp;
        int r = this.a.length - 1;
        int s = j + 1;
        while (r > s) {
            temp = this.a[s];
            this.a[s] = this.a[r];
            this.a[r] = temp;
            --r;
            ++s;
        }
        this.numLeft = this.numLeft.subtract(BigInteger.ONE);
        return this.a;
    }

    public static void main(String[] args) {
        String hao = "a/b/c";
        String[] elements = hao.split("/");
        PGenerator x = new PGenerator(elements.length);
        while (x.hasMore()) {
            StringBuffer permutation = new StringBuffer();
            int[] indices = x.getNext();
            int i = 0;
            while (i < indices.length) {
                System.out.println("indices=[" + i + "]=" + indices[i]);
                ++i;
            }
            i = 0;
            while (i < indices.length) {
                if (i == indices.length - 1) {
                    permutation.append(elements[indices[i]]);
                } else {
                    permutation.append(elements[indices[i]]).append("/");
                }
                ++i;
            }
            System.out.println(permutation.toString());
        }
    }
}

