/*
 * Decompiled with CFR 0.152.
 */
package com.letousky.lottery.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.util.Vector;

public class FileHandle {
    private File file = null;

    public String[] getRowsArray(String fileName) throws Exception {
        try {
            String rowStr;
            Vector<String> rowList = new Vector<String>();
            BufferedReader reader = new BufferedReader(new InputStreamReader(Thread.currentThread().getContextClassLoader().getResourceAsStream(fileName)));
            while ((rowStr = reader.readLine()) != null) {
                if (rowStr.trim().startsWith("#") || rowStr.trim().equals("")) continue;
                rowList.addElement(rowStr.trim());
            }
            reader.close();
            Object[] rowListArray = new String[rowList.size()];
            rowList.copyInto(rowListArray);
            return rowListArray;
        }
        catch (Exception e) {
            System.err.println("Read Rows From File Error.\n");
            e.printStackTrace();
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean createFileFromBytes(byte[] byteArray, String fileName) throws Exception {
        boolean flag = false;
        try {
            int len = 10240;
            byte[] buffer = new byte[len];
            this.file = new File(fileName);
            if (this.file.exists() && !this.file.delete()) {
                System.err.println("Error: File " + fileName + " delete error.");
                this.file = null;
                return false;
            }
            try {
                int bytesRead;
                if (!this.file.createNewFile()) {
                    System.out.println("Note: File " + fileName + " create error.");
                    this.file = null;
                    return false;
                }
                BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(this.file));
                ByteArrayInputStream bis = new ByteArrayInputStream(byteArray);
                while ((bytesRead = bis.read(buffer)) != -1) {
                    bos.write(buffer, 0, bytesRead);
                }
                bos.flush();
                bos.close();
                bos = null;
                flag = true;
                return flag;
            }
            catch (Exception e) {
                System.err.println("Create File From Byte Array Error.\n");
                e.printStackTrace();
            }
            return flag;
        }
        finally {
            if (this.file != null) {
                this.file = null;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] getBytesFromFile(String fileName) throws Exception {
        byte[] byteArray = null;
        try {
            this.file = new File(fileName);
            if (!this.file.exists()) {
                this.file = null;
                return null;
            }
            try {
                if (!this.file.canRead()) {
                    this.file = null;
                    return null;
                }
                BufferedInputStream bis = new BufferedInputStream(new FileInputStream(this.file));
                byteArray = new byte[bis.available()];
                bis.read(byteArray);
                bis.close();
                bis = null;
                return byteArray;
            }
            catch (Exception e) {
                System.err.println("Get Byte Array From File Error.\n");
                e.printStackTrace();
            }
            return byteArray;
        }
        finally {
            if (this.file != null) {
                this.file = null;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BufferedInputStream getBISFromFile(String fileName) throws Exception {
        BufferedInputStream bis = null;
        try {
            this.file = new File(fileName);
            if (!this.file.exists()) {
                this.file = null;
                return null;
            }
            try {
                if (!this.file.canRead()) {
                    this.file = null;
                    return null;
                }
                bis = new BufferedInputStream(new FileInputStream(this.file));
                return bis;
            }
            catch (Exception e) {
                System.err.println("Get BufferedInputStream From File Error.\n");
                e.printStackTrace();
            }
            return bis;
        }
        finally {
            if (this.file != null) {
                this.file = null;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean createFileFromBIS(BufferedInputStream bis, String fileName) throws Exception {
        boolean flag = false;
        try {
            this.file = new File(fileName);
            if (this.file.exists() && !this.file.delete()) {
                System.err.println("Error: File " + fileName + " delete error.");
                this.file = null;
                return false;
            }
            try {
                if (!this.file.createNewFile()) {
                    System.out.println("Note: File " + fileName + " create error.");
                    this.file = null;
                    return false;
                }
                BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(this.file));
                byte[] byteArray = new byte[bis.available()];
                bis.read(byteArray);
                bos.write(byteArray);
                bos.flush();
                bos.close();
                bos = null;
                bis.close();
                bis = null;
                byteArray = null;
                flag = true;
                return flag;
            }
            catch (Exception e) {
                System.err.println("Create File From BufferedInputStream Error.\n");
                e.printStackTrace();
            }
            return flag;
        }
        finally {
            if (this.file != null) {
                this.file = null;
            }
        }
    }

    public boolean deleteFile(String fileName) throws Exception {
        boolean flag;
        block8: {
            flag = false;
            try {
                try {
                    this.file = new File(fileName);
                    if (!this.file.exists()) break block8;
                    if (!this.file.delete()) {
                        System.err.println("Error: File " + fileName + " delete error.");
                        break block8;
                    }
                    flag = true;
                }
                catch (Exception e) {
                    System.err.println("File Delete Error.\n");
                    e.printStackTrace();
                    if (this.file != null) {
                        this.file = null;
                    }
                }
            }
            finally {
                if (this.file != null) {
                    this.file = null;
                }
            }
        }
        return flag;
    }

    public boolean copyFile(String sourceFile, String objectFile) throws Exception {
        boolean flag = false;
        try {
            this.createFileFromBytes(this.getBytesFromFile(sourceFile), objectFile);
            flag = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return flag;
    }

    public boolean moveFile(String sourceFile, String objectFile) throws Exception {
        boolean flag = false;
        try {
            this.copyFile(sourceFile, objectFile);
            this.deleteFile(sourceFile);
            flag = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return flag;
    }

    public boolean isExist(String sourceFile) throws Exception {
        boolean flag = false;
        try {
            try {
                this.file = new File(sourceFile);
                if (this.file.exists()) {
                    flag = true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (this.file != null) {
                    this.file = null;
                }
            }
        }
        finally {
            if (this.file != null) {
                this.file = null;
            }
        }
        return flag;
    }
}

