/*
 * Decompiled with CFR 0.152.
 */
package com.letousky.lottery.util;

import java.lang.reflect.Method;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.EJBLocalObject;
import javax.jms.Queue;
import javax.jms.QueueConnectionFactory;
import javax.jms.Topic;
import javax.jms.TopicConnectionFactory;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import javax.sql.DataSource;

public final class ServiceLocator {
    private static ServiceLocator serviceLocator = new ServiceLocator();
    private static String prefix = "java:comp/env/";
    private Map caches = Collections.synchronizedMap(new HashMap());
    private Context context = null;

    private ServiceLocator() {
        try {
            Hashtable env = new Hashtable();
            this.context = new InitialContext(env);
        }
        catch (NamingException e) {
            e.printStackTrace();
            throw new RuntimeException("err.jndi.ServiceLocatorNamingNotFoundError");
        }
    }

    public static ServiceLocator getInstance() {
        return serviceLocator;
    }

    public static EJBLocalObject getEJBLocalInterface(String ejbJNDI) {
        try {
            ServiceLocator locator = ServiceLocator.getInstance();
            EJBLocalHome home = locator.getLocalHome(ejbJNDI);
            Method m = home.getClass().getMethod("create", null);
            return (EJBLocalObject)m.invoke((Object)home, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
    }

    public EJBLocalHome getLocalHome(String jndiHomeName) throws Exception {
        jndiHomeName = String.valueOf(prefix) + jndiHomeName;
        EJBLocalHome home = null;
        try {
            if (this.caches.containsKey(jndiHomeName)) {
                home = (EJBLocalHome)this.caches.get(jndiHomeName);
            } else {
                home = (EJBLocalHome)this.context.lookup(jndiHomeName);
                this.caches.put(jndiHomeName, home);
            }
        }
        catch (NamingException e) {
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
        return home;
    }

    public EJBHome getRemoteHome(String jndiHomeName, Class className) throws Exception {
        EJBHome home = null;
        try {
            if (this.caches.containsKey(jndiHomeName)) {
                home = (EJBHome)this.caches.get(jndiHomeName);
            } else {
                Object objref = this.context.lookup(jndiHomeName);
                Object obj = PortableRemoteObject.narrow((Object)objref, (Class)className);
                home = (EJBHome)obj;
                this.caches.put(jndiHomeName, home);
            }
        }
        catch (ClassCastException e) {
            throw new Exception("err.class.ServiceLocatorClassNotFoundError");
        }
        catch (NamingException e) {
            throw new Exception("err.jndi.ServiceLocatorNamingNotFoundError");
        }
        return home;
    }

    public QueueConnectionFactory getQueueConnectionFactory(String qConnFactoryName) throws Exception {
        QueueConnectionFactory factory = null;
        try {
            if (this.caches.containsKey(qConnFactoryName)) {
                factory = (QueueConnectionFactory)this.caches.get(qConnFactoryName);
            } else {
                factory = (QueueConnectionFactory)this.context.lookup(qConnFactoryName);
                this.caches.put(qConnFactoryName, factory);
            }
        }
        catch (NamingException e) {
            e.printStackTrace();
            throw new Exception("err.jndi.ServiceLocatorNamingNotFoundError");
        }
        return factory;
    }

    public Queue getQueue(String queueName) throws Exception {
        Queue queue = null;
        try {
            if (this.caches.containsKey(queueName)) {
                queue = (Queue)this.caches.get(queueName);
            } else {
                queue = (Queue)this.context.lookup(queueName);
                this.caches.put(queueName, queue);
            }
        }
        catch (NamingException e) {
            e.printStackTrace();
            throw new Exception("err.jndi.ServiceLocatorNamingNotFoundError");
        }
        return queue;
    }

    public TopicConnectionFactory getTopicConnectionFactory(String topicConnFactoryName) throws Exception {
        TopicConnectionFactory factory = null;
        try {
            if (this.caches.containsKey(topicConnFactoryName)) {
                factory = (TopicConnectionFactory)this.caches.get(topicConnFactoryName);
            } else {
                factory = (TopicConnectionFactory)this.context.lookup(topicConnFactoryName);
                this.caches.put(topicConnFactoryName, factory);
            }
        }
        catch (NamingException e) {
            e.printStackTrace();
            throw new Exception("err.jndi.ServiceLocatorNamingNotFoundError");
        }
        return factory;
    }

    public Topic getTopic(String topicName) throws Exception {
        Topic topic = null;
        try {
            if (this.caches.containsKey(topicName)) {
                topic = (Topic)this.caches.get(topicName);
            } else {
                topic = (Topic)this.context.lookup(topicName);
                this.caches.put(topicName, topic);
            }
        }
        catch (NamingException e) {
            e.printStackTrace();
            throw new Exception("err.jndi.ServiceLocatorNamingNotFoundError");
        }
        return topic;
    }

    public DataSource getDataSource(String dataSourceName) throws Exception {
        DataSource dataSource = null;
        try {
            if (this.caches.containsKey(dataSourceName)) {
                dataSource = (DataSource)this.caches.get(dataSourceName);
            } else {
                dataSource = (DataSource)this.context.lookup(dataSourceName);
                this.caches.put(dataSourceName, dataSource);
            }
        }
        catch (NamingException e) {
            e.printStackTrace();
            throw new Exception("err.jndi.ServiceLocatorNamingNotFoundError");
        }
        return dataSource;
    }

    public URL getUrl(String envName) throws Exception {
        URL url = null;
        try {
            url = (URL)this.context.lookup(envName);
        }
        catch (NamingException e) {
            e.printStackTrace();
            throw new Exception("err.jndi.ServiceLocatorNamingNotFoundError");
        }
        return url;
    }

    public boolean getBoolean(String envName) throws Exception {
        Boolean bool = null;
        try {
            bool = (Boolean)this.context.lookup(envName);
        }
        catch (NamingException e) {
            e.printStackTrace();
            throw new Exception("err.jndi.ServiceLocatorNamingNotFoundError");
        }
        return bool;
    }

    public String getString(String envName) throws Exception {
        String envEntry = null;
        try {
            envEntry = (String)this.context.lookup(envName);
        }
        catch (NamingException e) {
            e.printStackTrace();
            throw new Exception("err.jndi.ServiceLocatorNamingNotFoundError");
        }
        return envEntry;
    }
}

