/*
 * Decompiled with CFR 0.152.
 */
package com.letousky.lottery.util;

import com.letousky.exception.LotteryException;
import com.letousky.lottery.util.Math;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public final class StringUtil {
    public static long[] complementaryArray = new long[]{256L, 65536L, 0x1000000L, 0x100000000L, 0x10000000000L, 0x1000000000000L, 0x100000000000000L};
    public static long[] negativeArray = new long[]{127L, 32767L, 0x7FFFFFL, Integer.MAX_VALUE, 0x7FFFFFFFFFL, 0x7FFFFFFFFFFFL, 0x7FFFFFFFFFFFFFL};
    public static long[] limitArray = new long[]{255L, 65535L, 0xFFFFFFL, 0xFFFFFFFFL, 0xFFFFFFFFFFL, 0xFFFFFFFFFFFFL, 0xFFFFFFFFFFFFFFL};

    public static boolean isNull(String src) {
        boolean _rtn = true;
        if (src != null && !src.trim().equals("")) {
            _rtn = false;
        }
        return _rtn;
    }

    public static String getDisplayStyle(String src) {
        String _rtn = null;
        _rtn = src == null ? "" : src.trim();
        return _rtn;
    }

    public static String getDisplayStyle(int src) {
        String _rtn = null;
        _rtn = src == 0 ? "" : String.valueOf(src);
        return _rtn;
    }

    public static String formatNumber(double dValue, int iScale) {
        DecimalFormat df = null;
        StringBuffer sPattern = new StringBuffer("##0");
        if (iScale > 0) {
            sPattern.append(".");
            int i = 0;
            while (i < iScale) {
                sPattern.append("0");
                ++i;
            }
        }
        df = new DecimalFormat(sPattern.toString());
        return df.format(dValue);
    }

    public static float formatDec(float v, int scale) {
        if (scale < 0) {
            throw new IllegalArgumentException("The scale must be a positive integer or zero");
        }
        BigDecimal b = new BigDecimal(Double.toString(v));
        BigDecimal one = new BigDecimal("1");
        return b.divide(one, scale, 4).floatValue();
    }

    public static String getDisplayDate(Timestamp _timestamp, String _format) {
        if (_timestamp == null) {
            return "";
        }
        SimpleDateFormat df = new SimpleDateFormat(_format);
        String _rtn = df.format(_timestamp);
        return _rtn;
    }

    public static String getDisplayDateTime(Timestamp _timestamp) {
        return StringUtil.getDisplayDate(_timestamp, "yyyy-MM-dd hh:mm:ss");
    }

    public static String getDisplayDate(Timestamp _timestamp) {
        return StringUtil.getDisplayDate(_timestamp, "yyyy-MM-dd");
    }

    public static String getDisplayDate(Date date, String _format) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat df = new SimpleDateFormat(_format);
        String _rtn = df.format(date);
        return _rtn;
    }

    public static String getDisplayDateTime(Date date) {
        return StringUtil.getDisplayDate(date, "yyyy-MM-dd");
    }

    public static String getDisplayDate(Date date) {
        return StringUtil.getDisplayDate(date, "yyyy-MM-dd");
    }

    public static String getNullValue(String param) {
        if (param == null) {
            return null;
        }
        if (param.trim().length() == 0) {
            return null;
        }
        return param.trim();
    }

    public static final String replaceStr(String source, String oldStr, String newStr) {
        String workStr = source;
        try {
            int idx = workStr.indexOf(oldStr);
            while (idx != -1) {
                workStr = idx == workStr.length() - 1 ? String.valueOf(workStr.substring(0, idx)) + newStr : String.valueOf(workStr.substring(0, idx)) + newStr + workStr.substring(idx + oldStr.length());
                idx = workStr.indexOf(oldStr, idx + newStr.length());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return workStr;
    }

    public static final String nullToSpace(String str) {
        return str == null ? "" : str;
    }

    public static final String getDateNow(String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        String myDateStr = sdf.format(new Date());
        return myDateStr;
    }

    public static String getDate() {
        SimpleDateFormat tempDate = new SimpleDateFormat("yyyy-MM-dd");
        String datetime = tempDate.format(new Date());
        return datetime;
    }

    public static String getTime() {
        SimpleDateFormat temptime = new SimpleDateFormat("HH:mm:ss");
        String timeTime = temptime.format(new Date());
        return timeTime;
    }

    public static int indexOf(String input, String substring) {
        if (input == null) {
            input = "";
        }
        if (substring == null) {
            substring = "";
        }
        return input.indexOf(substring);
    }

    public static boolean contains(String input, String substring) {
        return StringUtil.indexOf(input, substring) != -1;
    }

    public static boolean containsIgnoreCase(String input, String substring) {
        String substringUC;
        String inputUC;
        if (input == null) {
            input = "";
        }
        if (substring == null) {
            substring = "";
        }
        return StringUtil.indexOf(inputUC = input.toUpperCase(), substringUC = substring.toUpperCase()) != -1;
    }

    public static String[] split(String input, String delimiters) {
        if (input == null) {
            input = "";
        }
        if (delimiters == null) {
            delimiters = "";
        }
        StringTokenizer tok = new StringTokenizer(input, delimiters);
        int count = tok.countTokens();
        String[] array = new String[count];
        int i = 0;
        while (tok.hasMoreTokens()) {
            array[i++] = tok.nextToken();
        }
        return array;
    }

    public static String getEmployeeNumber(String employeeNumber, int len) {
        String val = employeeNumber;
        char c = val.charAt(0);
        if (Character.isDigit(c)) {
            int l = employeeNumber.length();
            int i = 0;
            while (i < len - l) {
                val = "0" + val;
                ++i;
            }
        }
        return val;
    }

    public static String formatNumber(String s) {
        String val = "";
        try {
            val = Math.add(s, "0");
        }
        catch (Exception e) {
            val = "";
        }
        return val;
    }

    public static String trimUrl(String url) {
        return url.substring(0, url.indexOf("?"));
    }

    public static boolean isNumber(String val) {
        boolean v = false;
        try {
            new BigDecimal(val);
            v = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return v;
    }

    public static String doubleQuote(String s) {
        return "\"" + s + "\"";
    }

    public static char[] longAsCharArray(int base, long value) throws LotteryException {
        char[] bytes = new char[base];
        long unsigned = StringUtil.compressLongToSize(value, base);
        int i = 0;
        while (i < base) {
            bytes[i] = (char)StringUtil.remainder(unsigned, 256L);
            unsigned /= 256L;
            ++i;
        }
        if (base == 8 && value < 0L) {
            int n = base - 1;
            bytes[n] = (char)((long)bytes[n] + 128L);
        }
        return bytes;
    }

    public static long remainder(long number, long divider) {
        long quotient = number / divider;
        return number - divider * quotient;
    }

    public static long signedCharArrayToLong(char[] aCharArray) {
        int arraySize = aCharArray.length;
        long result = StringUtil.charArrayToLong(aCharArray);
        if (arraySize == 8) {
            return result;
        }
        if (result > negativeArray[arraySize - 1]) {
            return result - complementaryArray[arraySize - 1];
        }
        return result;
    }

    public static void sortStrings(String[] strings) {
        int i = 0;
        while (i < strings.length - 1) {
            int j = i + 1;
            while (j < strings.length) {
                if (strings[j].compareTo(strings[i]) < 0) {
                    String temp = strings[j];
                    strings[j] = strings[i];
                    strings[i] = temp;
                }
                ++j;
            }
            ++i;
        }
    }

    private static long compressLongToSize(long aValue, int size) throws LotteryException {
        long value = aValue;
        if (size == 8) {
            return value & (long)java.lang.Math.pow(256.0, size);
        }
        if (value < 0L) {
            value *= -1L;
            value = complementaryArray[size - 1] - value;
        }
        if (value > limitArray[size - 1]) {
            throw new LotteryException("InvalidClass. Value too long");
        }
        return value;
    }

    public static long charArrayToLong(char[] charArray) {
        long total = 0L;
        int i = 0;
        while (i < charArray.length) {
            total += (long)charArray[i] * (long)java.lang.Math.pow(256.0, i);
            ++i;
        }
        return total;
    }

    public static String hashTableToString(Hashtable ht, String separator) {
        if (ht == null) {
            throw new IllegalArgumentException("hashtable must not be null");
        }
        if (StringUtil.isNull(separator)) {
            separator = "#";
        }
        StringBuffer str = new StringBuffer();
        Enumeration enumeration = ht.keys();
        while (enumeration.hasMoreElements()) {
            Object key = enumeration.nextElement();
            Object value = ht.get(key);
            str.append(key.toString());
            str.append("=");
            str.append(value.toString());
            if (!enumeration.hasMoreElements()) continue;
            str.append(separator);
        }
        return str.toString();
    }

    public static String hashTableToString(Hashtable ht) {
        return StringUtil.hashTableToString(ht, "#");
    }

    public static boolean IsNum(String strin) {
        String s = strin.replaceAll("[0-9;]+", "");
        return s.equals("");
    }

    public static void main(String[] args) {
        Hashtable th = new Hashtable();
        int i = 0;
        while (i < 10) {
            System.out.println(StringUtil.hashTableToString(th));
            ++i;
        }
        System.out.println(StringUtil.getDate());
        System.out.println(StringUtil.getTime());
    }
}

