/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.config;

import com.opensymphony.xwork2.ObjectFactory;
import com.opensymphony.xwork2.util.location.Location;
import java.util.Iterator;
import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.config.DefaultSettings;

class Settings {
    static Settings settingsImpl;
    static Settings defaultImpl;
    static Locale locale;
    private static final Log LOG;

    Settings() {
    }

    public static void setInstance(Settings config) throws IllegalStateException {
        settingsImpl = config;
        locale = null;
    }

    public static Settings getInstance() {
        return settingsImpl == null ? Settings.getDefaultInstance() : settingsImpl;
    }

    public static Locale getLocale() {
        if (locale == null) {
            try {
                StringTokenizer localeTokens = new StringTokenizer(Settings.get("struts.locale"), "_");
                String lang = null;
                String country = null;
                if (localeTokens.hasMoreTokens()) {
                    lang = localeTokens.nextToken();
                }
                if (localeTokens.hasMoreTokens()) {
                    country = localeTokens.nextToken();
                }
                locale = new Locale(lang, country);
            }
            catch (Throwable t) {
                LOG.warn((Object)"Settings: Could not parse struts.locale setting, substituting default VM locale");
                locale = Locale.getDefault();
            }
        }
        return locale;
    }

    public static boolean isSet(String name) {
        return Settings.getInstance().isSetImpl(name);
    }

    public static String get(String name) throws IllegalArgumentException {
        return Settings.getInstance().getImpl(name);
    }

    public static Location getLocation(String name) throws IllegalArgumentException {
        return Settings.getInstance().getLocationImpl(name);
    }

    public static Iterator list() {
        return Settings.getInstance().listImpl();
    }

    public boolean isSetImpl(String name) {
        return false;
    }

    public static void set(String name, String value) throws IllegalArgumentException, UnsupportedOperationException {
        Settings.getInstance().setImpl(name, value);
    }

    public void setImpl(String name, String value) throws IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Settings: This implementation does not support setting a value.");
    }

    public String getImpl(String name) throws IllegalArgumentException {
        return null;
    }

    public Location getLocationImpl(String name) throws IllegalArgumentException {
        return null;
    }

    public Iterator listImpl() {
        throw new UnsupportedOperationException("Settings: This implementation does not support listing the registered settings");
    }

    private static Settings getDefaultInstance() {
        if (defaultImpl == null) {
            defaultImpl = new DefaultSettings();
            try {
                String className = Settings.get("struts.configuration");
                if (!className.equals(defaultImpl.getClass().getName())) {
                    try {
                        defaultImpl = (Settings)ObjectFactory.getObjectFactory().buildBean(Thread.currentThread().getContextClassLoader().loadClass(className), null);
                    }
                    catch (Exception e) {
                        LOG.error((Object)"Settings: Could not instantiate the struts.configuration object, substituting the default implementation.", (Throwable)e);
                    }
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return defaultImpl;
    }

    public static void reset() {
        defaultImpl = null;
        settingsImpl = null;
    }

    static {
        LOG = LogFactory.getLog(Settings.class);
    }
}

