/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.dispatcher.mapper;

import com.opensymphony.xwork2.config.ConfigurationManager;
import com.opensymphony.xwork2.inject.Container;
import com.opensymphony.xwork2.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.dispatcher.mapper.ActionMapper;
import org.apache.struts2.dispatcher.mapper.ActionMapping;

public class CompositeActionMapper
implements ActionMapper {
    private static final Log LOG = LogFactory.getLog(CompositeActionMapper.class);
    protected Container container;
    protected List<ActionMapper> actionMappers = new ArrayList<ActionMapper>();

    @Inject
    public void setContainer(Container container) {
        this.container = container;
    }

    @Inject(value="struts.mapper.composite")
    public void setActionMappers(String list) {
        if (list != null) {
            String[] arr;
            for (String name : arr = list.split(",")) {
                Object obj = this.container.getInstance(ActionMapper.class, name);
                if (obj == null) continue;
                this.actionMappers.add((ActionMapper)obj);
            }
        }
    }

    public ActionMapping getMapping(HttpServletRequest request, ConfigurationManager configManager) {
        for (ActionMapper actionMapper : this.actionMappers) {
            ActionMapping actionMapping = actionMapper.getMapping(request, configManager);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Using ActionMapper " + actionMapper));
            }
            if (actionMapping == null) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("ActionMapper " + actionMapper + " failed to return an ActionMapping (null)"));
                continue;
            }
            return actionMapping;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"exhausted from ActionMapper that could return an ActionMapping");
        }
        return null;
    }

    public String getUriFromActionMapping(ActionMapping mapping) {
        for (ActionMapper actionMapper : this.actionMappers) {
            String uri = actionMapper.getUriFromActionMapping(mapping);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Using ActionMapper " + actionMapper));
            }
            if (uri == null) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("ActionMapper " + actionMapper + " failed to return an ActionMapping (null)"));
                continue;
            }
            return uri;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"exhausted from ActionMapper that could return a uri");
        }
        return null;
    }
}

