/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.portlet.interceptor;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.interceptor.AbstractInterceptor;
import com.opensymphony.xwork2.util.CompoundRoot;
import com.opensymphony.xwork2.util.TextUtils;
import com.opensymphony.xwork2.util.ValueStack;
import java.util.Collection;
import java.util.Map;
import javax.portlet.ActionResponse;
import javax.portlet.RenderRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.portlet.PortletActionConstants;
import org.apache.struts2.portlet.dispatcher.DirectRenderFromEventAction;

public class PortletStateInterceptor
extends AbstractInterceptor
implements PortletActionConstants {
    private static final Log LOG = LogFactory.getLog(PortletStateInterceptor.class);
    private static final long serialVersionUID = 6138452063353911784L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String intercept(ActionInvocation invocation) throws Exception {
        Integer phase = (Integer)invocation.getInvocationContext().get((Object)"struts.portlet.phase");
        if (RENDER_PHASE.equals(phase)) {
            this.restoreStack(invocation);
            return invocation.invoke();
        }
        if (EVENT_PHASE.equals(phase)) {
            try {
                String string = invocation.invoke();
                return string;
            }
            finally {
                this.saveStack(invocation);
            }
        }
        return invocation.invoke();
    }

    private void saveStack(ActionInvocation invocation) {
        Map session = invocation.getInvocationContext().getSession();
        session.put("struts.portlet.valueStackFromEventPhase", invocation.getStack());
        ActionResponse actionResponse = (ActionResponse)invocation.getInvocationContext().get((Object)"struts.portlet.response");
        actionResponse.setRenderParameter("struts.portlet.eventAction", "true");
    }

    private void restoreStack(ActionInvocation invocation) {
        RenderRequest request = (RenderRequest)invocation.getInvocationContext().get((Object)"struts.portlet.request");
        if (TextUtils.stringSet((String)request.getParameter("struts.portlet.eventAction"))) {
            Map session = invocation.getInvocationContext().getSession();
            if (!this.isProperPrg(invocation)) {
                LOG.debug((Object)"Restoring value stack from event phase");
                ValueStack oldStack = (ValueStack)invocation.getInvocationContext().getSession().get("struts.portlet.valueStackFromEventPhase");
                if (oldStack != null) {
                    CompoundRoot oldRoot = oldStack.getRoot();
                    ValueStack currentStack = invocation.getStack();
                    CompoundRoot root = currentStack.getRoot();
                    root.addAll((Collection)oldRoot);
                    LOG.debug((Object)"Restored stack");
                }
            } else {
                LOG.debug((Object)"Won't restore stack from event phase since it's a proper PRG request");
            }
        }
    }

    private boolean isProperPrg(ActionInvocation invocation) {
        return !(invocation.getAction() instanceof DirectRenderFromEventAction);
    }
}

