package com.anylotto.client;

import java.util.ArrayList;

public class SafeURLMsgBean extends SafeMsgBean {
  private ArrayList props;  //存储原始数据

  public SafeURLMsgBean() {
     init();
    
  }

  public String get(String name)
   {
       for(int i = 0; i < props.size(); i++)
       {
           Property prop = (Property)props.get(i);
           if(prop.name.equals(name))
           {
               return prop.value;
           }
       }
       return "";
   }

   public String getSrcMsg()
          throws Exception
      {
          String srcMsg = "";
          if(props.isEmpty())
          {
              throw new Exception("数据为空！");
          }
          for(int i = 0; i < props.size(); i++)
          {
              Property prop = (Property)props.get(i);
              if(srcMsg.length() > 0)
              {
                  srcMsg = srcMsg + "\n";
              }
              srcMsg = srcMsg + prop.name + "=" + prop.value;
          }
          return srcMsg;
    }

    public void set(String name, String value)
            throws Exception
        {
            if(name == null)
            {
                throw new Exception("属性名为空！");
            }
            if(value != null)
            {
                props.add(new Property(name, value));
            } else
            {
                props.add(new Property(name, ""));
            }
    }

    protected void setSrcMsg(String srcMsg)
           throws Exception
       {
           if(srcMsg == null || srcMsg.length() == 0)
           {
               return;
           }
           int sPos = 0;
           int ePos = 0;
           props.clear();
           for(; sPos < srcMsg.length(); sPos = ePos + 1)
           {
               ePos = srcMsg.indexOf("\n", sPos);
               if(ePos == -1)
               {
                   ePos = srcMsg.length();
               }
               String line = srcMsg.substring(sPos, ePos);
               int pos = line.indexOf("=");
               String name;
               String value;
               if(pos > 0)
               {
                   name = line.substring(0, pos);
                   value = line.substring(pos + 1);
               } else
               {
                   name = line;
                   value = "";
               }
               set(name, value);
           }

    }
    public void init(){
       props = new ArrayList();
    }
    
    public void clear(){
    	props.clear();
    	//props=null;
    }
    
}
