package com.letousky.lottery.action;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import org.apache.log4j.Logger;
import org.apache.struts.actions.DispatchAction;

import com.letousky.exception.LotteryException;

public abstract class BaseAction extends DispatchAction {
	
	protected final static Logger __logger = Logger.getLogger(BaseAction.class);
	protected final String SUCCESS = "success";
	protected final String FAIL = "fail";
	protected final String NOFORWARD = "noforward";
 
	/**
	 * 用户session验证
	 * 
	 * @param request
	 * @return
	 * @throws LotteryException
	 */
	private String[] checkSession(HttpServletRequest request) throws LotteryException {
		HttpSession session = request.getSession();
		Object obj = session.getAttribute("userAry");
		if(obj != null){
			return (String[])obj;
		}
		else{
			throw new LotteryException("2001","非法登录或登录超时!");
		}
	}
	//重置session
	protected void restSession(HttpServletRequest request,String[] s) throws LotteryException {
		HttpSession session = request.getSession();
		session.setAttribute("userAry",s);
	}
	/**
	 * 获取用户帐户ID
	 * 
	 * @param request
	 * @return
	 * @throws Exception
	 */
	public String getUserId(HttpServletRequest request)throws LotteryException {
		String[] value = checkSession(request);
		return value[1];
	}
	
	/**
	 * 获取用户登录昵称
	 * 
	 * @param request
	 * @return
	 * @throws Exception
	 */
	public String getUserName(HttpServletRequest request)throws LotteryException {
		String[] value = checkSession(request);
		return value[2];
	}
	
	/**
	 * 获取登录密码
	 * 
	 * @param request
	 * @return
	 * @throws Exception
	 */
	public String getPassword(HttpServletRequest request)throws LotteryException {
		String[] value = checkSession(request);
	   
		return value[12];
	}
	
	/**
	 * 获取登录类型
	 * 
	 * @param request
	 * @return
	 * @throws Exception
	 */
	public String getType(HttpServletRequest request)throws LotteryException {
		String[] value = checkSession(request);
		return value[6];
	}
	
	/**
	 * 初始化参数,顺序就是按照params的顺序

	 * 
	 * @param params
	 * @param request
	 * @param n
	 * @return String[]
	 * @throws
	 */
	protected String[] initParamters(String[] params,HttpServletRequest request,String n){
		String[] s=new String[params.length];
		for (int i = 0; i < s.length; i++) {
			String o=request.getParameter(params[i]);
			s[i]=((o==null||o.equals(""))?n:((String)o).trim());
			//System.out.println("mytest----active register---------"+params[i]+"===="+s[i]);
		}
		return s;
	}
	
	
	/**
	 * 初始化参数,带 名称,密码+params的顺序

	 * 
	 * @param params
	 * @param request
	 * @param n
	 * @return String[] 登录名称  密码   金额   类型
	 * @throws 
	 */
	protected String[] initParamtersUP(String[] params,HttpServletRequest request,String n){
		String[] s=new String[params.length+2];
		s[0]=this.getUserName(request);//System.out.println("userName "+s[0]);
		s[1]=this.getPassword(request);//System.out.println("password "+s[1]);
		for (int i = 2; i < s.length; i++) {
			String o=request.getParameter(params[i-2]);
			s[i]=((o==null||o.equals(""))?n:((String)o).trim());
//			System.out.println(params[i-2]+" "+s[i]);
		}
		return s;
	}
	/**
	 * 弹出操作完成以后跳转到另一个页面

	 * 
	 * @param msg 要弹出的信息,如果为null,则不弹出直接跳转
	 * @param url 弹出信息以后要跳转到的页面url
	 * @param params 弹出信息以后跳转要带过去的参数

	 * @param request
	 */
	protected void setReqAttForward(String msg,String url,String[] params,HttpServletRequest request){
		request.setAttribute("msg",msg);
		request.setAttribute("url",url);
		request.setAttribute("getParams",params);
	}
}
