package com.letousky.lottery.action;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import com.anylotto.client.MD5Util;
import com.letousky.connector.MessageTool;
import com.letousky.exception.LotteryException;
import com.letousky.lottery.delegate.AbstractDelegate;
import com.letousky.lottery.util.HttpClientUtil;
import com.letousky.lottery.util.OperaterCode;

public class MemberCenter extends AbstractDelegate{
	
	/*
	 *会员中心 购彩记录List
	 * 
	 * 返回  list[0]-集合   list[1]-记录数
	 * 
	 * request buyLottery_records.jsp
	 * */
	public List buyLottery(String[] params)throws LotteryException {
		
		List list=new ArrayList();
		String results = helpMessage(params, OperaterCode.BUY_LOTTERY); //合买集合
		String record=	helpMessage(new String[]{params[0],params[1],params[2],params[3],params[4]}, OperaterCode.BUY_COUNT_LOTTERY); //总记录数
		list.add(new MessageTool().splits(results));
		list.add(new MessageTool().split(record));
		return list;
	}
	
	/*
	 *会员中心 战绩详情List
	 * 
	 * 返回  list[0]-集合   list[1]-记录数
	 * 
	 * request buyLottery_records.jsp
	 * */
	public List userZhanJi(String[] params)throws LotteryException {
		
		List list=new ArrayList();
		params[1] = null;
		String results = helpMessage(params, OperaterCode.RESULTS_USER_ZHANJI); //合买集合
		String record=	helpMessage(new String[]{params[0],params[1],params[2],params[3],params[4]}, OperaterCode.RESULTS_USER_ZJSTRIP); //总记录数
		list.add(new MessageTool().splits(results));
		list.add(new MessageTool().split(record));
		return list;
	}
	
	/*
	 * 会员中心 购彩记录详情List
	 * 
	 * request  buyLottery_details.jsp
	 * */
	public String[] buyLotteryDetails(String[] params)throws LotteryException {
		
		String results = helpMessage(params, OperaterCode.BUY_LOTTERY_DETAILS); 
		String record=	helpMessage(new String[]{params[0]}, OperaterCode.List_COUNT_Details); //认购人数总记录数
		String[] rt=new MessageTool().split(results);
		String[] items=new String[rt.length+1];
		for(int i=0;i<rt.length;i++){
			items[i] = rt[i];
		}
		String[] rc=new MessageTool().split(record);
		items[items.length-1] = rc[0];
		return items;
	}
	
	/*
	 * 会员中心  保存定制跟单
	 * 
	 * request  tary_save_single.jsp
	 * */
	public String[] tarySaveSingle(String[] params)throws LotteryException{
		String results = helpMessage(params, OperaterCode.TARY_SAVE_SINGLE); 
		return new MessageTool().split(results);
	}
	
	/*
	 * 会员中心  取消定制跟单
	 * 
	 * request  tary_del_single.jsp
	 * */
	public String[] taryCancelSingle(String[] params)throws LotteryException{
		String results = helpMessage(params, OperaterCode.TARY_CANCEL_SINGLE); 
		return new MessageTool().split(results);
	}
	
	/*
	 * 会员中心  我定制的所有订单
	 * 
	 * request  tary_select_single.jsp
	 * */
	public List tarySelectSingle(String[] params)throws LotteryException{
		List list=new ArrayList();
		String results = helpMessage(params, OperaterCode.TARY_SELECT_SINGLE); 
		String record=	helpMessage(new String[]{params[0],params[1],params[2]}, OperaterCode.TARY_SELECT_COUNT); //总记录数
		list.add(new MessageTool().splits(results));
		list.add(new MessageTool().split(record));
		return list;
	}
	
	/*
	 * 会员中心  我被邀请的定制跟单记录
	 * 
	 * request  tary_select_binvi.jsp
	 * */
	public List tarySelectBinvi(String[] params)throws LotteryException{
		List list=new ArrayList();
		String results = helpMessage(params, OperaterCode.TARY_SELECT_BINVI); 
		String record=	helpMessage(new String[]{params[0]}, OperaterCode.TARY_COUNT_BINVI); //总记录数
		list.add(new MessageTool().splits(results));
		list.add(new MessageTool().split(record));
		return list;
	}
	
	/*
	 * 会员中心 拒绝邀请跟单
	 * 
	 * request  tary_del_yq.jsp
	 * */
	public String[] taryDelYq(String[] params)throws LotteryException{
		String results = helpMessage(params, OperaterCode.TARY_DELJJ_YQ); 
		return new MessageTool().split(results);
	}
	
	/*
	 * 会员中心  我指定的跟单人
	 * 
	 * request  tary_select_single.jsp
	 * */
	public List taryAppointBinvi(String[] params)throws LotteryException{
		List list=new ArrayList();
		String results = helpMessage(params, OperaterCode.TARY_APPOINT_BINVI); //指定跟单人集合
		String record=	helpMessage(new String[]{params[0]}, OperaterCode.TARY_APPOINT_COUNT); //指定跟单人总记录数
		list.add(new MessageTool().splits(results));
		list.add(new MessageTool().split(record));
		return list;
	}
	
	/*
	 * 跟我单的用户
	 * 
	 * request tary_single_user.jsp
	 * */
	public List tarySingleUser(String[] params)throws LotteryException{
		String results = helpMessage(params, OperaterCode.TARY_SINGLE_USER); 
		return new MessageTool().splits(results);
	}
	
	/*
	 * 添加指定跟单用户
	 * 
	 * request tary_single_user.jsp
	 * */
	public String[] taryAddSingleUser(String[] params)throws LotteryException{
		String results = helpMessage(params, OperaterCode.TARY_ADDSINGLE_USER); 
		return new MessageTool().split(results);
	}
	
	
	/*
	 * 会员中心  账户明细
	 * 
	 * request  account_details_list.jsp
	 * */
	public List accountDetailsList(String[] params,HttpServletRequest request)throws LotteryException{
		List list=new ArrayList();
		params[0] = super.getUserName(request);
		params[1] = super.getPassword(request);
		String results = helpMessage(params, OperaterCode.ACCOUNT_DETAILS_LIST); //指定跟单人集合
		String record=	helpMessage(new String[]{params[0],params[1],params[2],params[3],params[6]}, OperaterCode.ACCOUNT_COUNT_STRIP); //指定跟单人总记录数
		list.add(new MessageTool().splits(results));
		list.add(new MessageTool().split(record));
		return list;
	}
	
	
	
	/*
	 * 提现申请
	 * 
	 * request alipay_cash.jsp
	 * */
	public String[] alipay_cash(String[] params,HttpServletRequest request)throws LotteryException{
		params[0] = super.getUserName(request);
		params[1] = super.getPassword(request);
		String results = helpMessage(params, OperaterCode.ALIPAY_CASH); 
		return new MessageTool().split(results);
	}
	
	/*
	 * 用户激活C0142
	 * 
	 * request user_activation.jsp
	 * */
	public String[] user_Activation(String[] params,HttpServletRequest request)throws LotteryException{
		String results = helpMessage(params, OperaterCode.USER_ACTION); 
		return new MessageTool().split(results);
	}
	
	/*
	 * 佣金转入  ZaoPai in JingCai
	 * 
	 *@param price [转入金额]
	 * 
	 * request  .....
	 * */
	public String Commission(String[] param,HttpServletRequest request)throws LotteryException{
		HttpClientUtil  send = new HttpClientUtil();
		String username = super.getUserName(request);
		String[] u  = (String[])request.getSession().getAttribute("userAry");
		String[] params = {u[1],param[0],"1001"};
		Map map = new HashMap();
		map.put("p1",username);
		map.put("p2",param[0]);
		map.put("p3","");
		map.put("sn",param[1]);
		map.put("oper", "20");
		String sendValue = send.execute("http://www.jingcaile.com/union/service.php",map);
		if("ok".equals(sendValue))
		{
			String results = helpMessage(params, OperaterCode.USER_ACTION);
			new MessageTool().split(results);
			//成功充值
		}
		return sendValue;
	}
	
	public static void main(String[] args) {
		String key = MD5Util.md5Hex("JINGCAILE"+"letoula"+"52"+""+"20"); 
		System.out.println(key);
	}
}
