package com.letousky.lottery.action;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


import com.letousky.connector.MessageTool;
import com.letousky.exception.LotteryException;
import com.letousky.lottery.delegate.AbstractDelegate;
import com.letousky.lottery.util.OperaterCode;


public class ShowUserAction extends AbstractDelegate{
	
	/**
	 * 用户信息显示(会员中心)
	 * @param mapping
	 * @param forward
	 * @param request
	 * @param response
	 * @return   
	 * @throws Exception
	 */
	public  String[] userInfoShowNew(HttpServletRequest request)throws Exception {
		try {
			String[] params = new String[2];
			params[0]=super.getUserName(request);
			params[1]=super.getPassword(request);
			String[] results = new MessageTool().split(helpMessage(params,OperaterCode.USER_INFOMATION));
			results[5] =this.getUserSex(results[5]);
			results[7]="身份证";
			for (int i = 0; i < results.length; i++) {
				if(" ".equals(results[i])){
					results[i]="无";
				}
			}
			
			return results;
			
		} catch (LotteryException e) {
			return new String[]{e.getMessage()};
		} catch(Exception s){
			return new String[]{s.getMessage()};
		}
	}
	/**
	 * 用户基本资料保存
	 * @param param
	 * @return
	 */
	public String userInfoSave(String[] param){
		try{
			new MessageTool().split(helpMessage(param,OperaterCode.USER_INFO_SAVE));
			return "0000";
		} catch (LotteryException e) {
			return e.getMessage();
		} catch(Exception s){
			return s.getMessage();
		}
	}
	/**
	 * 获得用户证件类型
	 * @param params
	 * @return
	 */
   public String getUserSex(String UserSex){
	   String value = "";
       switch(Integer.parseInt(UserSex)){
		      case 0:
		        value = "男";
		        break;
		      case 1:
			    value = "女";
			    break;  
        }
       return value;
   }
   public static void main(String[] str){
	  
   }
   
}

