package com.letousky.lottery.action;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.List;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.mira.lucene.analysis.e;

import com.letousky.connector.MessageTool;
import com.letousky.exception.LotteryException;
import com.letousky.lottery.delegate.AbstractDelegate;
import com.letousky.lottery.delegate.LoginManage;
import com.letousky.lottery.delegate.QueryLotDelegate;
import com.letousky.lottery.delegate.SelectMyAccountManage;
import com.letousky.lottery.domain.UserLogin;
import com.letousky.lottery.util.MessageSend;
import com.letousky.lottery.util.OperaterCode;
import com.letousky.lottery.util.PhoneCode;
import com.letousky.lottery.util.TimeUtil;

public class UserRegisteredAction extends AbstractDelegate {
	/**
	 * 检查用户名是否存在
	 * @param params
	 * @return
	 */
	public String checkUser(String[] params){
		try{
			new MessageTool().split(helpMessage(params,OperaterCode.CHECK_USERNAME));
			checkNickName(params);
			return "0";
		} catch (LotteryException e) {
			return "对不起，用户名已经存在，请重新输入！";
		} catch(Exception s){
			return "对不起，用户名已经存在，请重新输入！";
			
		}
	}
	/**
	 * 检查账户呢称是否存在
	 * @param params
	 * @return
	 */
	public String checkNickName(String[] params){
		try{
			new MessageTool().split(helpMessage(params,OperaterCode.CHECK_NICKNAME));
			return "0";
		} catch (LotteryException e) {
			return "对不起，账户昵称已经存在，请重新输入！";
		} catch(Exception s){
			return "对不起，账户昵称已经存在，请重新输入！";
			
		}
	}
	/**
	 * 发送验证码
	 * @param params
	 * @return
	 */
	public String[] sendCode(String[] params){
		try{
			new MessageTool().split(helpMessage(params,OperaterCode.SEND_CODE));
			String code=params[1].substring(20,26);
			return new String[]{"0000",code};
		} catch (LotteryException e) {
			return new String[]{e.getMessage()};
		} catch(Exception s){
			return new String[]{s.getMessage()};
			
		}
	}
	/**
	 * 邮箱验证
	 * @param params
	 * @return
	 */
	public String checkEmail(String[] params){
		try{
			new MessageTool().split(helpMessage(params,OperaterCode.EMAIL_CHECK));
			return "0000";
		} catch (LotteryException e) {
			return "1111";
		} catch(Exception s){
			return "1111";
		}
	}
	/**
	 * 手机验证
	 * @param params
	 * @return
	 */
	public String checkPhone(String[] params){
		try{
			new MessageTool().split(helpMessage(params,OperaterCode.PHONE_CHECK));
			return "0000";
		} catch (LotteryException e) {
			return "1111";
		} catch(Exception s){
			return "1111";
		}
	}
	
	
	/**
	 * 用户注册
	 * @param logins
	 * @return
	 */
	public String register(String[] logins,HttpServletRequest request){
		try{
			Cookie[] cookies = request.getCookies();
			String useridSX = "";
			for(int i=0;i<cookies.length;i++){
				if(cookies[i].getName().equals("onLineId")){
					useridSX = cookies[i].getValue();
				}
			}
			logins[20] = useridSX;
			new MessageTool().split(helpMessage(logins,OperaterCode.USER_REGISTER));
			return "0";//new String[]{"ddd","222",logins[0]};///login(logins[0],logins[1]);
		} catch (LotteryException e) {
			return e.getMessage();
		} catch(Exception s){
			//System.out.println(s.getMessage()+"1111111111111111");
			return s.getMessage();
		}
	}
	public void login(String uName,String pwd,HttpServletRequest request){
		
		String[] results=null;
		String[] params=new String[]{uName,pwd};
		String[] result=null;
		String[] userAry = new String[19];
		try {
			results = new LoginManage().login(params);
			 
		} catch (LotteryException e) {
			e.printStackTrace();
		} catch (Exception e) {
			//throw new Exception(e.getMessage());
			e.printStackTrace();
		}
		try {
			result = new SelectMyAccountManage().selectMyAccount(new String[]{params[0],params[1]},"C0012");
		} catch (LotteryException e) {
			userAry[8]="0.0";
			userAry[9]="0.0";
			userAry[10]="0.0";
			userAry[13]="0.0";
			userAry[14]="0.0";
		} catch (Exception e) {
			//throw new Exception(e.getMessage());
			e.printStackTrace();
		}
		if(result!=null){
			//result[0]鐢ㄦ埛ID
			userAry[8] = result[1];//鎶曟敞浣欓 鏀逛负 璐︽埛浣欓
			userAry[9] = result[2];//濂栭噾閲戦 
			userAry[10] = result[3];//鍐荤粨閲戦 
			userAry[13] = result[4];//鏀逛负 娲诲姩閲戦
			userAry[14] = result[5];//鏀逛负鍙彁鐜伴噾棰�
		}
		double a = Double.valueOf(userAry[8]).doubleValue()

		+Double.valueOf(userAry[9]).doubleValue()+Double.valueOf(userAry

		[13]).doubleValue()-Double.valueOf(userAry[10]).doubleValue();
		BigDecimal bd = new BigDecimal(a);//涓嬮潰鐢熸垚灏忔暟鐐瑰悗淇濈暀2浣嶇殑灏忔暟(2浣嶅悗鍏ㄨ垗)
		userAry[11] = ""+bd.setScale(2, 

				BigDecimal.ROUND_FLOOR).doubleValue();//鍙敤閲戦
	
		for (int i = 0; i <8; i++) {
			userAry[i]=results[i];
		}
		if(results!=null){
			userAry[15]=results[8];
			userAry[16]=results[9];
			userAry[17]=results[10];
		}
		userAry[5]=TimeUtil.string2timeH(userAry[5]);
		userAry[12]=params[1];
		userAry[18]=results[results.length-1];
		//return userAry;
		request.getSession().setAttribute("userAry", userAry);
	}
	
	/**
	 * 检查手机是否存在
	 * @param params
	 * @return
	 */
	public String checkMobile(String[] params){
		try{
			new MessageTool().split(helpMessage(params,OperaterCode.CHECK_MOBILE));
			return "0";
		} catch (LotteryException e) {
			return "对不起，手机号码已经存在，请重新输入！";
		} catch(Exception s){
			return "对不起，手机号码已经存在，请重新输入！";
			
		}
	}
	/**
	 * 检查推广联盟是否存在
	 * @return 
	 */
	public String checkSid(String sid){
		String OperaterCode="C0207";
		String refId="";
		String results = helpMessage(new String[]{sid}, OperaterCode);
		String[]strArray= new MessageTool().split(results);
		try {
			refId= java.net.URLDecoder.decode(strArray[0],"utf-8");
		} catch (UnsupportedEncodingException e) {
			e.printStackTrace();
		}
		return refId;
	}
	
	
	public String sendMsg(String[] phones)
	{
		String result=MessageSend.sengMsg(phones[0]);
		return result;
		
	}
	
	public static void main(String[] sdf){
		UserRegisteredAction us =new UserRegisteredAction();
		us.checkSid("1111");
		
		
//		String uName="乐透旺旺";
//		String pwd="yangpeng";
//		String[] dd=new UserRegisteredAction().login(uName,pwd);
//		for(int i=0;i<dd.length;i++){
//			System.out.println(dd[i]);
//		}
		
//		String[] params =  new String[]{"18665385047","123456"};
//		String dd=new UserRegisteredAction().sendCode(params);
//		System.out.println(dd);
		//PhoneCode.writeProp("src/PhoneCode.properties", "connector","4567893");
//		String sss="验证码:123456,";
//		sss=sss.substring(4,10);
//		System.out.println(sss);
//		String ss="欢迎您进入竞彩乐网站，您的短信验证码为：561247。本站正举行充值就送10%的大回馈活动，多充多送，上不封顶。";
//		ss=ss.substring(20,26);
//		System.out.println(ss);
	}
}
