package com.letousky.lottery.action;

import java.io.IOException;
import java.util.Iterator;

import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

import com.letousky.lottery.util.InsiderCenterFormat;

public class WoZhonglaObtainNotice extends HttpServlet{
	
	private static Logger __logger=InsiderCenterFormat.GET_LOGGER(WoZhonglaObtainNotice.class);
	private ServletContext sc;
	@Override
    public void init(ServletConfig config) {
        sc = config.getServletContext();
    }
	
	 @Override
	 public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
	     doPost(request, response);
	 }
	 
	 @Override
	 public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
		 String cmd = request.getParameter("cmd"); //命令代码 1001出票状态通知 1002兑奖通知
		 String msg = request.getParameter("msg"); //消息体
		 try {
			Document doc = DocumentHelper.parseText(msg);
			Element rootElt = doc.getRootElement(); // 获取根节点
			__logger.info("===========================>>>根节点="+rootElt.getName());
			if("1001".equals(cmd))
			{
				Iterator iter = rootElt.elementIterator("order"); // 获取根节点下的子节点order
				while(iter.hasNext())
				{
					__logger.info("-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=出票状态子节点start-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=");
					Element recordEle = (Element) iter.next();
					String Merchantid = recordEle.attribute("merchantid").getValue(); //商户ID
					String orderNo    = recordEle.attribute("orderno").getValue();    //订单号
					String issue      = recordEle.attribute("issue").getValue();      //期次号
					String lotoid     = recordEle.attribute("lotoid").getValue();     //彩种ID
					__logger.info("===========================>>>Merchantid="+Merchantid+"  orderNo="+orderNo+"  issue="+issue+"  lotoid="+lotoid);
					Iterator iterticket = recordEle.elementIterator("ticket"); // 获取order节点下的子节点ticket
					while(iterticket.hasNext())
					{
						Element ticketEle = (Element) iterticket.next();
						String seq = ticketEle.attribute("seq").getValue(); //订单内票序号
						String status = ticketEle.attribute("status").getValue(); //出票状态 Y成功 N失败
						String errmsg = ticketEle.attribute("errmsg").getValue(); //提示信息 赔率相关
						String ticketid = ticketEle.attribute("ticketid").getValue(); //真实票ID
						
					}
					__logger.info("-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=出票状态子节点stop-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=");
				}
			}else if("1002".equals(cmd))
			{
				 
			}
		} catch (DocumentException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	 }
}
