package com.letousky.lottery.alipayUtil;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.*;

public class Payment {

	public static String CreateUrl(String paygateway, String service,
			String sign_type, String out_trade_no, String input_charset,
			String partner, String key, String show_url, String body,
			String total_fee, String payment_type, String seller_email,
			String subject, String notify_url,String paymethod,String defaultbank) {

		Map params = new HashMap();
		params.put("service", service);
		params.put("partner", partner);
		params.put("subject", subject);
		params.put("body", body);
		params.put("out_trade_no", out_trade_no);
		params.put("total_fee", total_fee);
		params.put("show_url", show_url);
		params.put("payment_type", payment_type);
		params.put("seller_email", seller_email);
		params.put("notify_url", notify_url);
		params.put("defaultbank", defaultbank);
		
		params.put("_input_charset", input_charset);

		String prestr = "";

		prestr = prestr + key;
		// System.out.println("prestr=" + prestr);

		String sign = Md5Encrypt.md5(getContent(params, key));

		String parameter = "";
		parameter = parameter + paygateway;
		// System.out.println("prestr=" + parameter);
		List keys = new ArrayList(params.keySet());
		for (int i = 0; i < keys.size(); i++) {
			String value = (String) params.get(keys.get(i));
			if (value == null || value.trim().length() == 0) {
				continue;
			}
			try {
				parameter = parameter + keys.get(i) + "="
						+ URLEncoder.encode(value, input_charset) + "&";
			} catch (UnsupportedEncodingException e) {

				e.printStackTrace();
			}
		}
		
		//parameter 没有加密,没有sort的参数字符串用&符号链接的
		//sign 是用&链接的字符串,sort以后,再MD5以后的一个东西
		parameter = parameter + "sign=" + sign + "&sign_type=" + sign_type;

		return sign;

	}

	private static String getContent(Map params, String privateKey) {
		List keys = new ArrayList(params.keySet());
		Collections.sort(keys);

		String prestr = "";

		boolean first = true;
		for (int i = 0; i < keys.size(); i++) {
			String key = (String) keys.get(i);
			String value = (String) params.get(key);
			if (value == null || value.trim().length() == 0) {
				continue;
			}
			if (first) {
				prestr = prestr + key + "=" + value;
				first = false;
			} else {
				prestr = prestr + "&" + key + "=" + value;
			}
		}

		return prestr + privateKey;
	}

	public static void main(String args[]) {
		UtilDate date=new UtilDate();
		String paygateway = "https://www.alipay.com/cooperate/gateway.do?"; //'支付接口
		String service = "create_direct_pay_by_user";//快速付款交易服务
		String sign_type = "MD5";
		String out_trade_no = date.getOrderNum(); //商户网站订单
		String input_charset = "utf-8";
		String partner = "2088001538749043"; //支付宝合作伙伴id (账户内提取)
		String key = "t8fqpz4ljkg8wdg6zyc6hejj2ioakcqm"; //支付宝安全校验码(账户内提取)
		String body = "支付宝测试"; //商品描述，推荐格式：商品名称（订单编号：订单编号）
		String total_fee = "0.01"; //订单总价
		String payment_type = "1";//支付宝类型.1代表商品购买
		String seller_email = "gwl25@126.com"; //卖家支付宝帐户
		String subject = "AAA"+out_trade_no; //商品名称
		String show_url = "http://www.alipay.com";
		String notify_url = "http://kevinletou.gicp.net:8080/jsp_direct_utf/alipay_notify.jsp"; //通知接收URL(本地测试时，服务器返回无法测试)
		String return_url = "http://kevinletou.gicp.net:8080/jsp_direct_utf/alipay_return.jsp"; //支付完成后跳转返回的网址URL
		String paymethod = "bankPay";//赋值:bankPay(网银);cartoon(卡通); directPay(余额)
		String defaultbank = "ICBCB2C";
		
		String itemUrl = Payment.CreateUrl(paygateway, service,
				sign_type, out_trade_no, input_charset, partner, key,
				show_url, body, total_fee, payment_type, seller_email,
				subject, notify_url, paymethod,defaultbank);
	}
}
