package com.letousky.lottery.delegate;

import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import org.apache.log4j.Logger;
import org.apache.struts.actions.DispatchAction;

import com.letousky.connector.Message;
import com.letousky.connector.MessageHandler;
import com.letousky.connector.MessageTool;
import com.letousky.exception.LotteryException;
import com.letousky.util.Symbols;
import com.letousky.util.TimeUtil;

public abstract class AbstractDelegate{

	final static Logger __logger = Logger.getLogger(AbstractDelegate.class);
	public static String SerialNO = ""; 
	/**
	 * 
	 * @param params
	 * @param operaterCode
	 * @return
	 * @throws LotteryException
	 */
	public String helpMessage(String[] params,String operaterCode) throws LotteryException {
		Message message = new Message();
		// 设置message的值
		message.setOperaterCode(operaterCode);
		message.setVersion("1.10");
		message.setChannelNo("1001");
		message.setRequestNo("100");
		message.setDataType("1");
		message.setRequestType("0");
		String OperaterNo = doSerialNo();
		if(!"".equals(SerialNO))
		{
			
			OperaterNo = SerialNO;
		}
		message.setOperaterNo(OperaterNo);
		StringBuffer sb = new StringBuffer();
		if(params!=null){
			for (String string : params) {
				sb.append(string);
				sb.append(Symbols.CON_SPLITBODY);
			}
			String body = sb.toString();
			message.setBody(body);
		}
		else{
			message.setBody("");
		}
		System.out.println("message========"+message);
		//设置服务器连接属性
		return new MessageHandler().sendMessage(message);
	}
	/***
	 * 左国斌新加的方法,解决用户来源的问题
	 * @param params
	 * @param operaterCode
	 * @param sourceId
	 * @return
	 * @throws LotteryException
	 */
	public String helpMessage2(String[] params,String operaterCode,String sourceId) throws LotteryException {
		Message message = new Message();
		// 设置message的值
		message.setOperaterCode(operaterCode);
		message.setVersion("1.10");
		if(null!=sourceId && !"".equals(sourceId)){
			message.setChannelNo(sourceId);
		}else{
			message.setChannelNo("1001");
		}
		message.setRequestNo("100");
		message.setDataType("1");
		message.setRequestType("0");
		String OperaterNo = doSerialNo();
		if(!"".equals(SerialNO))
		{
			
			OperaterNo = SerialNO;
		}
		message.setOperaterNo(OperaterNo);
		StringBuffer sb = new StringBuffer();
		if(params!=null){
			for (String string : params) {
				sb.append(string);
				sb.append(Symbols.CON_SPLITBODY);
			}
			String body = sb.toString();
			message.setBody(body);
		}
		else{
			message.setBody("");
		}
		System.out.println("message========"+message);
		//设置服务器连接属性
		return new MessageHandler().sendMessage(message);
	}
	/***
	 * 官升伟新加的方法,解决用户来源的问题
	 * @param params
	 * @param operaterCode
	 * @param sourceId
	 * @return
	 * @throws LotteryException
	 */
	public String helpMessage3(String[] params,String operaterCode,String sourceId) throws LotteryException {
		Message message = new Message();
		// 设置message的值
		message.setOperaterCode(operaterCode);
		message.setVersion("1.10");
		if(null!=sourceId && !"".equals(sourceId)){
			message.setChannelNo(sourceId);
		}else{
			message.setChannelNo("1001");
		}
		message.setRequestNo("100");
		message.setDataType("1");
		message.setRequestType("0");
		String OperaterNo = doSerialNo();
		if(!"".equals(SerialNO))
		{
			
			OperaterNo = SerialNO;
		}
		message.setOperaterNo(OperaterNo);
		StringBuffer sb = new StringBuffer();
		if(params!=null){
			for (String string : params) {
				sb.append(string);
				sb.append(Symbols.CON_SPLITBODY);
			}
			String body = sb.toString();
			message.setBody(body);
		}
		else{
			message.setBody("");
		}
		System.out.println("message========"+message);
		//设置服务器连接属性
		return new MessageHandler().sendMessage(message);
	}
	/**
	 * 产生交易号码
	 * 
	 * @return
	 * @throws LotteryException
	 */
	public static String doSerialNo() throws LotteryException {
		String values = "yyMMddHHmmssSSSSSSSSSSSSS";
		return TimeUtil.getDate(values);
	}
	
	/**
	 * 
	 * @param params
	 * @param operaterCode
	 * @return List
	 */
	public List handleDelegateList(String[] params, String operaterCode){
		String s = this.helpMessage(params, operaterCode);
		return new MessageTool().splits(s);
	}
	
	/**
	 * 
	 * @param params
	 * @param operaterCode
	 * @return String[]
	 */
	public String[] handleDelegateAry(String[] params, String operaterCode){
		String s = this.helpMessage(params, operaterCode);
		//System.out.println("-------------------------"+s);
		return new MessageTool().split(s);
	}
	
	/**
	 * 用户session验证
	 * 
	 * @param request
	 * @return
	 * @throws LotteryException
	 */
	private String[] checkSession(HttpServletRequest request) throws LotteryException {
		HttpSession session = request.getSession();
		Object obj = session.getAttribute("userAry");
		if(obj != null){
			return (String[])obj;
		}
		else{
			throw new LotteryException("2001","非法登录或登录超时!");
		}
	}
	/**
	 * 获取用户登录昵称
	 * 
	 * @param request
	 * @return
	 * @throws Exception
	 */
	public String getUserName(HttpServletRequest request)throws LotteryException {
		String[] value = checkSession(request);
		return value[2];
	}
	
	/**
	 * 获取登录密码
	 * 
	 * @param request
	 * @return
	 * @throws Exception
	 */
	public String getPassword(HttpServletRequest request)throws LotteryException {
		String[] value = checkSession(request);
	   
		return value[12];
	}
}
