package com.letousky.lottery.delegate;

import com.letousky.connector.MessageTool;
import com.letousky.exception.LotteryException;
import com.letousky.lottery.util.OperaterCode;


public class LoginManage extends AbstractDelegate {
	/**
	 * 用户登录页面
	 * @param params
	 * @return
	 * @throws LotteryException
	 */
	public String[] login(String[] params)throws LotteryException {
		String operaterCode = "C0002";
		String results = helpMessage(params, operaterCode);
		return new MessageTool().split(results);
	}
	
	
	/**
	 * 用户注册
	 * @param params
	 * @return
	 * @throws LotteryException
	 */
	public String[] register(String[] params)throws LotteryException {
		String operaterCode = OperaterCode.USER_REGISTER;
		String results = helpMessage(params, operaterCode);
		return new MessageTool().split(results);
	}
	/**
	 * 用户注册2左国斌
	 * @param params
	 * @return
	 * @throws LotteryException
	 */
	public String[] register2(String[] params,String sourceId)throws LotteryException {
		String operaterCode = OperaterCode.USER_REGISTER;
		String results = helpMessage2(params, operaterCode,sourceId);
		return new MessageTool().split(results);
	}
	/**
	 * 用户注册3 官升伟
	 * @param params
	 * @return
	 * @throws LotteryException
	 */
	public String[] register3(String[] params,String sourceId)throws LotteryException {
		String operaterCode = OperaterCode.USER_REGISTER;
		String results = helpMessage3(params, operaterCode,sourceId);
		return new MessageTool().split(results);
	}
	/**
	 * 用户注册修改信息
	 * @param params
	 * @return
	 * @throws LotteryException
	 */
	public String[] rstinfo(String[] params)throws LotteryException {
		String operaterCode = OperaterCode.USER_CZ_INFO_SAVE;
		String results = helpMessage(params, operaterCode);
		return new MessageTool().split(results);
	}
	
	/**
	 * 修改密码
	 * @param params
	 * @return
	 * @throws LotteryException
	 */
	public String[] getPass(String[] params,String operaterCode) throws LotteryException {
		String results= helpMessage(params,operaterCode);
		return new MessageTool().split(results);
	}
	/***
	 * 查询注册的人数--左国斌
	 * @param params 参数数组
	 * @param operaterCode 操作码
	 * @return 返回一个参数数组
	 */
	public String[] findSellCountNum(String []params,String operaterCode){
		String results = helpMessage(params, operaterCode);
		return new MessageTool().split(results);
	}
	/***
	 * 增加注册的人数--左国斌
	 * @param params 参数数组
	 * @param operaterCode 操作码
	 * @return 返回一个参数数组
	 */
	public String[] addSellCountNum(String []params,String operaterCode){
		String results = helpMessage(params, operaterCode);
		return new MessageTool().split(results);
	}
}
