package com.letousky.lottery.util;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.letousky.connector.MessageTool;
import com.letousky.exception.LotteryException;
import com.letousky.lottery.rule.interfaces.ILotteryItem;
import com.letousky.lottery.rule.interfaces.LotteryItemSingleton;


/**
 * 检查14种中任意种玩法是否符合格式
 * @author Administrator
 *
 */

public class CheckCodes {
	
	/*
	 * 传统足彩上传号码格式定义
	 * 
	 * params[0] 投注号码长度
	 * 
	 * params[1] 投注号码包含的数字
	 * */
	public final static Map map = new HashMap();
	public final static String[] MAP_SFC = new String[]{"14","3|1|0"}; //14场 胜负彩
	public final static String[] MAP_BQC = new String[]{"12","3|1|0"};  //半全场
	public final static String[] MAP_RXJ = new String[]{"14","3|1|0|9"}; //任选9场
	public final static String[] MAP_JQC = new String[]{"8","0|1|2|3"}; //4场进球
	
	/**
	 * 检查传统足彩格式
	 * */
	public String CheckCodes (String lotName , String code){
		String msg = "";
		String[] game = null;
		switch(Integer.parseInt(lotName))
		{
			case 102:game=MAP_SFC;break;
			case 103:game=MAP_RXJ;break;
			case 106:game=MAP_JQC;break;
			case 107:game=MAP_BQC;break;
		}
		if(!code.matches("\\w")){
			int lg = Integer.parseInt(game[0]);
			if(code.trim().length() == lg){
				
				for(int i = 0; i < lg; i++){
					
					char num = code.charAt(i);
					
					if(game[1].indexOf(num) == -1){
						
						return "该行的第"+(i+1)+"个数字不正确";
					}
					if(String.valueOf(num).matches("\\D"))
					{
						return "除数字之外，不得含有其他文字信息";
					}
					
				}
				return "success";
			}else{
				
				return "该玩法的号码长度不正确";
			}
		}else{
			
			return "文件里的号码不是数字!请检查";
		}
		
	}
	
	/**
	 * 检查北单上传格式
	 * @throws UnsupportedEncodingException 
	 * */
	public String CheckCodesDc (String lotName , String code) {
		
		String[] str_t = code.split("\\s");
		String[] num = null;
		String fg = "";
		 if(str_t[0].indexOf(",")!=-1){
			 num = str_t[0].split(",");
			 fg="→";
		 }else if(str_t[0].indexOf(";")!=-1){
			 num = str_t[0].split(";");
			 fg="→";
		 }
			for(int l = 0 ; l < num.length ; l++)
			{
				
				String[] numAry = num[l].split(fg);
				try{
					if(numAry[0].matches("\\D"))
					{
						return num[l]+"场次编号不是数字!请检查";
						
					}else if(numAry[1].matches("\\D")){
						return num[l]+"，投注号码错误!请检查";
					}
					if(lotName.equals("301")){
						if("310".indexOf(numAry[1])==-1){
							return num[l]+"，投注号码错误!请检查";
						}
					}else if(lotName.equals("302"))
					{
						if("上单|上双|下单|下双".indexOf(numAry[1])==-1)
						{
							return num[l]+"，投注号码错误!请检查";
						}
					}else if(lotName.equals("303"))
					{
						if("0|1|2|3|4|5|6|7".indexOf(numAry[1])==-1)
						{
							return num[l]+"，投注号码错误!请检查";
						}
					}else if(lotName.equals("304"))
					{
						if("4:3|1:0|2:0|2:1|3:0|3:1|3:2|4:0|4:1|4:2|4:4|0:0|1:1|2:2|3:3|3:4|0:1|0:2|1:2|0:3|1:3|2:3|0:4|1:4|2:4".indexOf(numAry[1])==-10)
						{
							return num[l]+"，投注号码错误!请检查";
						}
					}else if(lotName.equals("305"))
					{
						if("3-3|3-1|3-0|1-3|1-1|1-0|0-3|0-1|0-0".indexOf(numAry[1])==-1)
						{
							return num[l]+"，投注号码错误!请检查";
						}
					}
				}catch(Exception e){
					
					return num[l]+"本场比赛的分隔符错误,场次与号码之间分隔符为"+fg+"";
				}
				
			}
		return "success";
	}
	
	/**
	 * 检查竞彩上传格式
	 * @throws UnsupportedEncodingException 
	 * */
	public String CheckCodesJC (String lotName , String code) {
		String[] str_t = code.split("\\s");
		String[] num = null;
		if(str_t[0].indexOf(",")!=-1){
			 num = str_t[0].split(",");
		 }else if(str_t[0].indexOf(";")!=-1){
			 num = str_t[0].split(";");
		 }
			for(int l = 0 ; l < num.length ; l++)
			{
				String[] numAry = null;
				if(num[l].indexOf("→")!=-1){
					numAry = num[l].split("\\→");
				}else if(num[l].indexOf("->")!=-1){
					numAry = num[l].split("\\->");
				}else{
					return num[l]+"本场比赛的分隔符错误,场次与号码之间分隔符为'→'";
				}
				
				try{
					if(numAry[1].matches("\\D")){
						
						return num[l]+"，投注号码错误!请检查";
						
					}/*else if(Integer.parseInt(numAry[0]) < 1 || Integer.parseInt(numAry[0]) > list.size()){
						
						return "文件上传错误,今日没有本场比赛！"+num[l];
						
					}*/
					if(lotName.equals("501") || lotName.equals("511")){
						if("310".indexOf(numAry[1])==-1){
							return num[l]+"，投注号码错误!请检查";
						}
					}else if(lotName.equals("503"))
					{
						if("0|1|2|3|4|5|6|7".indexOf(numAry[1])==-1)
						{
							return num[l]+"，投注号码错误!请检查";
						}
					}else if(lotName.equals("502"))
					{
						if("4:3|1:0|2:0|2:1|3:0|3:1|3:2|4:0|4:1|4:2|4:4|5:0|5:1|5:2|0:0|1:1|2:2|3:3|3:4|0:1|0:2|1:2|0:3|1:3|2:3|0:4|1:4|2:4|0:5|1:5|2:5".indexOf(numAry[1])==-10)
						{
							return num[l]+"，投注号码错误!请检查";
						}
					}else if(lotName.equals("504"))
					{
						if("3_3|3_1|3_0|1_3|1_1|1_0|0_3|0_1|0_0".indexOf(numAry[1])==-1)
						{
							return num[l]+"，投注号码错误!请检查";
						}
					}
				}catch(Exception e){
					return num[l]+"本场比赛的分隔符错误,场次与号码之间分隔符为'→'";
				}
				
			}
		return "success";
	}
	
	
	public static Map SortArray_CT(String[] arr,String separator){
		StringBuffer controlStr = null;
		List<String[]> controlList = new ArrayList<String[]>();
		List<String> list = new ArrayList<String>();
		Map formatMap = new HashMap();
		for(int i=0;i<arr.length;i++)
		{
			controlStr = new StringBuffer();
			String arrrepalce = arr[i].trim().replaceAll("", ",");
			arrrepalce = arrrepalce.substring(1,arrrepalce.length()-1);
			String[] formatArr = arrrepalce.split("\\,");
			for(int j =0; j < formatArr.length; j++)
			{
				controlStr.append(formatArr[j]).append(",");
			}
			controlStr.deleteCharAt(controlStr.lastIndexOf(","));
			controlList.add(controlStr.toString().trim().split("\\,"));
		}
		
		for(int m = 0; m < controlList.size(); m++)
		{
			list = new ArrayList<String>();
			String[] arrList = controlList.get(m);
			for(int u = 0;u<arrList.length;u++)
			{
				 if(!list.contains(arrList[u])) {//如果数组 list 不包含当前项，则增加该项到数组中	
					 list.add(arrList[u]);	
				 }   
			}
			formatMap.put(m,list.toString().substring(1, list.toString().length()-1));
		}
		
		
		return formatMap;
	}
	public static void main(String[] args)
	{
		String[] arr =new String[15];
		arr[0]="51→3;52→1;53→1;54→3;55→0";
		arr[1]="51→3;52→1;53→1;54→3;55→1";
		arr[2]="51→3;52→1;53→0;54→3;55→0";
		arr[3]="51→3;52→1;53→0;54→3;55→1";
		arr[4]="51→3;52→3;53→1;54→3;55→0";
		arr[5]="51→3;52→3;53→1;54→3;55→1";
		arr[6]="51→3;52→3;53→0;54→3;55→0";
		arr[7]="51→3;52→3;53→0;54→3;55→1";
		arr[8]="51→1;52→1;53→1;54→3;55→0";
		arr[9]="51→1;52→1;53→0;54→3;55→0";
		arr[10]="51→1;52→1;53→0;54→3;55→1";
		arr[11]="51→1;52→3;53→1;54→3;55→0";
		arr[12]="51→1;52→3;53→1;54→3;55→1";
		arr[13]="51→1;52→3;53→0;54→3;55→0";
		arr[14]="51→1;52→3;53→0;54→3;55→1";
		
		String newarr[] = null;
		String str = "";
		for(int i=0;i<arr.length;i++){
			str+=arr[i];
		}
		newarr = str.split("\\;");
		System.out.println(newarr.length+"==");
		//SortArray(newarr,"→");
	}
	/**
	 * 
	 * @Title: SortArray
	 * @Description: 根据周几001 冒泡排序 
	 * @param @param arr
	 * @param @param separator
	 * @param @return
	 * @return String[]
	 * @throws
	 * @param arr
	 * @param separator
	 * @return
	 */
	public static Map SortArray(String[] arr,String separator){
		/*for(int i=0;i<arr.length-1;i++){
			for(int k=0;k<arr.length-i-1;k++){
				int a,b;
				if(arr[k].indexOf("周") != -1){
					a = Integer.parseInt(FormatWeek(arr[k]).split(separator)[0]);
					b = Integer.parseInt(FormatWeek(arr[k+1]).split(separator)[0]);
				}else{
					a = Integer.parseInt(arr[k].split(separator)[0]);
					b = Integer.parseInt(arr[k+1].split(separator)[0]);
				}
				if(a>b){
					 String temp = arr[k];
					 arr[k] =  arr[k + 1];
					 arr[k + 1] = temp;
				}
			}
		}*/
		return DeleteSameKey(arr,separator);
	}
	
	/**
	 * 
	 * @Title: FormatWeek
	 * @Description: 将周一001 转成 1001
	 * @param @param str
	 * @param @return
	 * @return String
	 * @throws
	 * @param str
	 * @return
	 */
	public static String FormatWeek(String str){
		String ss = "";
		if(str.indexOf("周一")!=-1){
			ss = str.replace("周一", "1");
		}else if(str.indexOf("周二")!=-1){
			ss = str.replace("周二", "2");
		}else if(str.indexOf("周三")!=-1){
			ss = str.replace("周三", "3");
		}else if(str.indexOf("周四")!=-1){
			ss = str.replace("周四", "4");
		}else if(str.indexOf("周五")!=-1){
			ss = str.replace("周五", "5");
		}else if(str.indexOf("周六")!=-1){
			ss = str.replace("周六", "6");
		}else if(str.indexOf("周日")!=-1){
			ss = str.replace("周日", "7");
		}
		
		return ss;
	}
	
	/**
	 * 
	 * @Title: DeleteSameKey
	 * @Description: 删除数组相同项并返回map
	 * @param @param Arr
	 * @param @return
	 * @return Map
	 * @throws
	 * @param Arr
	 * @return
	 */
	public static Map DeleteSameKey(String[] Arr,String separator){
		 List<String> list = new ArrayList<String>();
		 for (int i=0; i<Arr.length; i++) {	
			 if(!list.contains(Arr[i])) {//如果数组 list 不包含当前项，则增加该项到数组中	
				 list.add(Arr[i]);
				}   
		 }
		 String[] newStr =  list.toArray(new String[1]); 
		 Map newMap = new HashMap();
		 for (String element:newStr ) {
			 String[] bss = element.split(separator);
			 if(newMap.containsKey(bss[0])){
				 newMap.put(bss[0],newMap.get(bss[0]).toString() +","+ bss[1]);
			 }else{
				 newMap.put(bss[0], bss[1]);
			 }
		}
		return newMap;
	}
}
