package com.letousky.lottery.util;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.Socket;
import java.nio.ByteBuffer;

/**
 * 打印数据
 * 
 * @author scott
 * 
 */
public class CopyOfJavaTicketDataFileTestClient {
	
	Socket socket;
	BufferedReader in;
	PrintWriter out;

	public CopyOfJavaTicketDataFileTestClient() {

		File file = null;
		FileOutputStream fileputstream = null;
		DataInputStream is = null;

		try {
			socket = new Socket("192.168.1.21", 6666);
			//socket = new Socket("113.118.55.217", 6666);
			OutputStream out = socket.getOutputStream();

			ByteBuffer a = ByteBuffer.allocate(1000);

			a.put("TicketData\r\n".getBytes());
			a.put("lotteryType:04\r\n".getBytes());
			a.put(("flushUI:false\r\n").getBytes());

			StringBuffer buf = new StringBuffer();
			StringBuffer resultBuf = new StringBuffer();

			buf.append("ticket:");
			buf.append("0010111000010|"); // 彩种
			buf.append("0000100000000|"); // 投注方式

			// 第一组
			buf.append("1111100000000|");
			buf.append("0000000000000|");

			// 第二组
			buf.append("0000000000000|");
			buf.append("0000000000000|");

			// 第三组
			buf.append("0000000000000|");
			buf.append("0000000000000|");

			// 第四组
			buf.append("0000000000000|");
			buf.append("0000000000000|");

			// 第五组
			buf.append("0000000000000|");
			buf.append("0000000000000|");

			// 倍数十位
			buf.append("0000000000000|");
			// 倍数个数
			buf.append("1000000000000|");
			// 多期十位
			buf.append("0000000000000|");
			// 多期个位
			buf.append("0000000000000|");
			buf.append("\r\n");
			a.put((buf.toString()).getBytes());
			a.put(("\r\n").getBytes());

			out.write(a.array());
			out.flush();

			BufferedReader br = new BufferedReader(new InputStreamReader(socket.getInputStream(),"GBK"));
		
			file = new File("d:\\coronis");
			fileputstream = new FileOutputStream(file);
			if (!file.exists()) {
				file.createNewFile();
			} else {
				file.delete();
				file.createNewFile();
			}

		
			StringBuffer srcBuf = new StringBuffer();
			String line = "";
			
			while (null != (line = br.readLine())) {
				if(line.trim().length() != 0) {
					srcBuf.append(line);
					if(-1 != srcBuf.toString().indexOf("PrinterCutPaper")) {
						   break;
					}
				}
			}
				
			//System.out.println("source=" + srcBuf.toString()); //按长度取越界
			StringBuffer contentBuf = new StringBuffer();
			String[] result = srcBuf.toString().split("PrintDatalen:");
			for(int i = 0; i < result.length; i++) {
				if(result[i].trim().length() > 0) {
					int begin = result[i].indexOf("Printer");
					System.out.println("协议=" + result[i]);
					if(-1 != begin) {
						int length = Integer.parseInt(result[i].substring(0, begin));
						System.out.println("长度=" + length);
						String content = result[i].substring(String.valueOf(length).length());
						//String content = result[i].substring(String.valueOf(length).length(), bytesToInt(toLH(length)));
						//String content = result[i].substring(String.valueOf(length).length(), length+2);
						System.out.println("内容=" + content);
						contentBuf.append(content);
					}
				}
			}
			
			//System.out.println("target=" + contentBuf.toString());
			fileputstream.write(contentBuf.toString().replaceAll("PrintData", "").getBytes());
			
			
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			if (null != fileputstream) {
				try {
					fileputstream.close();
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
			if(null != is) {
				try {
					is.close();
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
		}
	}

	public byte[] addCapacity(byte[]data, byte[] rece) {
		byte temp[] = new byte[data.length + rece.length];
		System.arraycopy(data, 0, temp, 0, data.length);
		System.arraycopy(rece, 0, temp, data.length, rece.length);
		return temp;
	}
	
	private static byte[] toLH(int n) {
		byte[] b = new byte[4];
		b[0] = (byte) (n & 0xff);
		b[1] = (byte) (n >> 8 & 0xff);
		b[2] = (byte) (n >> 16 & 0xff);
		b[3] = (byte) (n >> 24 & 0xff);
		
		return b;
	}//http://yunshangbuhe.iteye.com/blog/1154500
	
	
	public static int bytesToInt(byte[] bytes) { 
		int num = bytes[0] & 0xFF; 
	    num |= ((bytes[1] << 8) & 0xFF00); 
		return num; 
	}
	
	public static void main(String[] args) {
		new CopyOfJavaTicketDataFileTestClient();
	}

}
