package com.letousky.lottery.util;

import java.math.BigDecimal;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import com.letousky.exception.LotteryException;

import com.letousky.util.ConvertUtil;

public class HelpRandom {
	private static final Random r = new Random();

	private static String[] randomNew(int n, int round) {
		String s = "";
		int m = 0;
		do {
			String str = String.valueOf(r.nextInt(round));
			if (str.equals("0") || s.indexOf(str) != -1)
				continue;
			str = (Integer.valueOf(str) < 10) ? "0" + str : str;
			s += (str + ",");
			m++;
		} while (m < n);
		String[] sa = s.split(",");
		for (int i = 0; i < sa.length; i++) {
			for (int j = i + 1; j < sa.length; j++) {
				if (Integer.valueOf(sa[j]) < Integer.valueOf(sa[i])) {
					String temp = sa[i];
					sa[i] = sa[j];
					sa[j] = temp;
				}
			}
		}
		return sa;
	}

	// 七星彩
	private static String[] randomQxc(int n, int round) {
		String s = "";
		int m = 0;
		do {
			String str = String.valueOf(r.nextInt(round));
			str = (Integer.valueOf(str) < 10) ? str : str;
			if (s.indexOf(str) != -1)
				continue;
			s += (str + ",");
			m++;
		} while (m < n);
		String[] sa = s.split(",");
		for (int i = 0; i < sa.length; i++) {
			for (int j = i + 1; j < sa.length; j++) {
				if (Integer.valueOf(sa[j]) < Integer.valueOf(sa[i])) {
					String temp = sa[i];
					sa[i] = sa[j];
					sa[j] = temp;
				}
			}
		}
		return sa;
	}


	// 简易投注和绑定手机
	private static String[] randomApply(int n, int round) {
		String s = "";
		int m = 0;
		do {
			String str = String.valueOf(r.nextInt(round));
			str = (Integer.valueOf(str) < 10) ? str : str;
			s += (str + ",");
			m++;
		} while (m < n);
		String[] sa = s.split(",");
		for (int i = 0; i < sa.length; i++) {
			for (int j = i + 1; j < sa.length; j++) {
				if (Integer.valueOf(sa[j]) < Integer.valueOf(sa[i])) {
					String temp = sa[i];
					sa[i] = sa[j];
					sa[j] = temp;
				}
			}
		}
		return sa;
	}

	/**
	 * 格式化投注号码
	 * 
	 * 
	 * 
	 * 
	 * @param nums
	 *            投注号码
	 * @return
	 */
	public static String formatNums(String nums) {
		nums = "/" + nums.replace("/", "//") + "/";
		return nums.replaceAll("/(\\d){1}/", "0$1/").replace("//", "/")
				.replaceAll("/$", "");
	}

	public static Boolean regexMatch(String s, String regx) {
		Pattern pattern = Pattern.compile(regx);
		Matcher isNum = pattern.matcher(s);
		if (!isNum.matches()) {
			return false;
		}
		return true;
	}

	public static BigDecimal formatNumByBigDecimal(String s) {
		BigDecimal bd = new BigDecimal(s);
		return bd.setScale(2, BigDecimal.ROUND_DOWN);
	}

	/**
	 * @param args
	 */
	public static void main(String[] args) {
//		for (int i = 0; i < 1000; i++) {
//			System.out.println(HelpRandom.randomNumApply(5, 10, ""));
//		}
		// MatchResult mr = HelpRandom.getMatchResult("xui+angeffdse",
		// "[^a-zA-Z0-9#/*,/+]");
		// if (StringUtils.isNotEmpty(ConvertUtil.toString(mr))) {
		// System.out.println(mr);
		// }
		// System.out.println(mr == null);
		// System.out.println(HelpRandom.formatNumByBigDecimalDouble("0.23666")+HelpRandom.formatNumByBigDecimalDouble("0.231"));
		//System.out.println(HelpRandom.randomP3_Z3());
	}

	/**
	 * 格式化大乐透胆拖(传入格式：01+02030407,020304+0107)
	 * 
	 * @return
	 */
	public static String helpDanTuo(String str) {
		// str="01+02030407,020304+0107";
		str = str.replaceAll("(\\d{2})", "$1/").replace("+", "//").replace(
				"///", "//");
		str = str.replace("/,", ",").replaceFirst("/$", "");
		return str;
	}
}
