package com.letousky.lottery.util;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Map.Entry;

import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.params.HttpMethodParams;
import org.apache.log4j.Logger;

import com.anylotto.client.MD5Util;
import com.letousky.exception.LotteryException;


public class HttpClientUtil {
	
	protected final static Logger __logger = Logger.getLogger(HttpClientUtil.class);

	
	public static String execute(String url, Map<String, String> map) throws LotteryException {
		HttpClient httpClient = null;
		GetMethod postMethod = null;
		
		try {
			httpClient = new HttpClient();
			postMethod = new GetMethod(url);
			
			//postMethod.getParams().setParameter(HttpMethodParams.HTTP_CONTENT_CHARSET, "utf-8");
			
			StringBuffer  queryString = new StringBuffer();
			for(Entry<String, String> e: map.entrySet()) {
				queryString.append(e.getKey()).append("=").append(URLEncoder.encode(e.getValue(), "UTF-8")).append("&");
				
			}
			
			postMethod.setQueryString(queryString.toString().substring(0, queryString.toString().length() - 1));
			
			// 执行postMethod
			int statusCode = 0;

			statusCode = httpClient.executeMethod(postMethod);
			
			// HttpClient对于要求接受后继服务的请求，象POST和PUT等不能自动处理转发 301或者302
			String resultStr = "";
			if (statusCode == HttpStatus.SC_MOVED_PERMANENTLY || statusCode == HttpStatus.SC_MOVED_TEMPORARILY) {
			} else {
				resultStr = postMethod.getResponseBodyAsString();
			}
			
			return resultStr;

		} catch (HttpException httpException) {
			__logger.error("请检查网络 : post exception" + httpException.getMessage());
             throw new LotteryException("连接异常,请检查网络 post exception ");
		} catch (IOException ioeException) {
			__logger.error("请检查网络 : post exception" + ioeException.getMessage());
			throw new LotteryException("连接异常,请检查网络 post exception ");
		} catch (Exception e) {
			__logger.error("连接异常,请检查网络 : post exception" + e.getMessage());
			throw new LotteryException("连接异常,请检查网络 post exception ");
		}finally {
			try {
				postMethod.releaseConnection(); // 关闭连接
			} catch (Exception e2) {
				System.out.println(e2.getMessage());
			}
		}
	}
	
	
	public static void main(String[] args) {
		/*Map map = new HashMap();
		String username = "letoula";
		String price = "523";
		String pwd = MD5Util.md5Hex("123456");
		String key = MD5Util.md5Hex("JINGCAILE"+username+pwd+"1"+"1"); 
		map.put("p1", username);
		map.put("p2", pwd);
		map.put("p3", "1");
		map.put("sn", key);
		map.put("oper", "1");
		System.out.println(key);
		String sendValue = execute("http://www.jingcaile.com/union/service.php",map);
		//System.out.println(sendValue);
		
		System.out.println(MD5Util.md5Hex("xiaofeng"));
		
		System.out.println(MD5Util.md5Hex("JINGCAILE"+"好人好梦"+"xiaofeng"+"1"+"1"));*/
		
		
		//bbs登录
		/*Map map = new HashMap();
		map.put("mod", "logging");
		map.put("action", "login");
		map.put("loginsubmit", "yes");
		map.put("infloat", "yes");
		map.put("lssubmit", "yes");
		map.put("username", "letoula");
		map.put("password", "123456");
		map.put("cookietime", "2592000");
		String sendValue = execute("http://www.jingcaile.com/bbs/upload/member.php",map);
		System.out.println(sendValue);*/
		
		
		HttpClientUtil http = new HttpClientUtil();
		Map map = new HashMap();
		map.put("RC_NAME", "好人好梦");
		map.put("RC_PWD", "tanchong");
		String sendValue = http.execute("http://localhost:8888/jcwz/Recharge.do?action=cooper",map);
		System.out.println(sendValue);
		

	
	}
}
