package com.letousky.lottery.util;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.nutz.json.Json;

import com.letousky.exception.LotteryException;
import com.letousky.lottery.delegate.WinsFlat;

public class InsiderCenterFormat {

	/**
	 * 取得日志对象
	 * 
	 * @param
	 * 		Class 类对象
	 * @return
	 * 		Logger 日志对象
	 */
	public static Logger GET_LOGGER(Class<?> cls) {
		
		Logger logger = Logger.getLogger(cls);

		PropertyConfigurator.configure(InsiderCenterFormat.class.getResource("/com/letousky/lottery/util/log4j.properties"));
		
		return logger;
		
	}
	
	
	/**
	 * 取得yyyyMMddHHmmss格式的时间日期
	 * 
	 * @return 
	 * 		String yyyyMMddHHmmss
	 */
	public static String GET_SYSTEM_TIME_ON_yyyyMMddHHmmss() {
		
		SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss");
		
		return formatter.format(new Date());
		
	}
	
	/**
	 * 
	 * @Title: timeFormat
	 * @Description: 格式化时间  12-31 15:30
	 * @param @param time
	 * @param @return
	 * @return String
	 * @throws
	 * @param time
	 * @return
	 */
	public static String timeFormat(String time)
	{
		StringBuffer newFormatTime = new StringBuffer();
		newFormatTime.append(time.substring(4,6)).append("-").append(time.substring(6,8)).append(" ").append(time.substring(8,10)).append(":").append(time.substring(10,12));
		return newFormatTime.toString();
	}
	
	/**
	 * 
	 * @Title: timeFormat
	 * @Description: 格式化时间  2013-12-31 08:04:48
	 * @param @param time
	 * @param @return
	 * @return String
	 * @throws
	 * @param time
	 * @return
	 */
	public synchronized static String GETTIME_YEAR_MOTH_DAY_DATE(String time)
	{
		StringBuffer newFormatTime = new StringBuffer();
		newFormatTime.append(time.substring(0,4)).append("-").append(time.substring(4,6)).append("-").append(time.substring(6,8)).append(" ").append(time.substring(8,10)).append(":").append(time.substring(10, 12)).append(":").append(time.substring(12, 14));
		return newFormatTime.toString();
	}
	
	/**
	 * 
	 * @Title: timeFormat
	 * @Description: 格式化时间  2013年12月31日15:00
	 * @param @param time
	 * @param @return
	 * @return String
	 * @throws
	 * @param time
	 * @return
	 */
	public static String GETTIME_YEAR_MOTH_DAY(String time)
	{
		StringBuffer newFormatTime = new StringBuffer();
		newFormatTime.append(time.substring(0,4)).append("年").append(time.substring(4,6)).append("月").append(time.substring(6,8)).append("日").append(time.substring(8,10)).append(":").append(time.substring(10, 12));
		return newFormatTime.toString();
	}
	public static List getBetZuCaiNumber(String info,String betMarketId,String gameCode,String manner){
		InsiderCenterFormat insider = new InsiderCenterFormat();
		String[] marketItem =  info.split("\\$");
		List  list = new ArrayList(); 
		StringBuffer chipinnums = new StringBuffer();
		StringBuffer overNum = new StringBuffer();
		for(int i = 0; i < marketItem.length;i++)
		{
			String[] market = marketItem[i].split("\\,");
			String[] betNumberArr = market[4].split("\\/");
			if(gameCode.equals("106") || gameCode.equals("107")){
				for(int k=0;k<betNumberArr.length;k++)
				{
					chipinnums.append(betNumberArr[k].charAt(1)).append("/");
					overNum.append("<span>").append(insider.getBeDoNumber(Integer.parseInt(gameCode),betNumberArr[k])+"  ").append("</span>");  //获得该结果的SP
				}
				if(manner.equals("2")){
					chipinnums.deleteCharAt(chipinnums.lastIndexOf("/"));
					chipinnums.append("//");
				}
				if((i+1)%2==0){
					String cp = chipinnums.toString();
					String[] result = new String[]{market[0],market[1],market[2],market[3],overNum.toString(),cp};
					list.add(result);
					overNum = new StringBuffer();
					chipinnums = new StringBuffer();
				}
			}else{
				for(int k=0;k<betNumberArr.length;k++)
				{
					chipinnums.append(betNumberArr[k]).append("/");
					overNum.append("<span>").append(insider.getBeDoNumber(Integer.parseInt(gameCode),betNumberArr[k])+"  ").append("</span>");  //获得该结果的SP
				}
				if(manner.equals("2")){
					chipinnums.deleteCharAt(chipinnums.lastIndexOf("/"));
					chipinnums.append("//");
				}
				String cp1 = chipinnums.toString();
				String[] result = new String[]{market[0],market[1],market[2],market[3],overNum.toString(),cp1};
				list.add(result);
				overNum = new StringBuffer();
				chipinnums = new StringBuffer();
			}
		}
		return list;
	}
	
	
	/**
	 * 
	 * @Title: getBetDanChangNumber
	 * @Description: 单场获得投注号码+SP   3[1.20]
	 * @param @param info
	 * @param @param betMarketId
	 * @param @param gameCode
	 * @param @param spObj
	 * @param @return
	 * @return List
	 * @throws
	 * @param info
	 * @param betMarketId
	 * @param gameCode
	 * @param spObj
	 * @return
	 */
	public static List getBetDanChangNumber(String info,String betMarketId,String gameCode,String spObj){
		InsiderCenterFormat insider = new InsiderCenterFormat();
		String[] marketItem =  info.split("\\$");
		String[] soitem = spObj.split("//");
		List  list = new ArrayList(); 
		for(int i = 0; i < marketItem.length;i++)
		{
			String[] market = marketItem[i].split("\\,");
			String[] betNumberArr = market[4].split("\\/");
			String[] sitAr = soitem[i].split("\\,")[1].split("\\/");
			StringBuffer overNum = new StringBuffer();
			for(int k=0;k<betNumberArr.length;k++)
			{
				if(gameCode.equals("304")){betNumberArr[k] = betNumberArr[k].replaceAll("#", ":");}
				else if(gameCode.equals("305")){betNumberArr[k] = betNumberArr[k].replaceAll("_", "-");}
				else if(gameCode.equals("302")){
					if(betNumberArr[k].equals("sd")) betNumberArr[k] = "上单";
					else if(betNumberArr[k].equals("ss")) betNumberArr[k] = "上双";
					else if(betNumberArr[k].equals("xd")) betNumberArr[k] = "下单";
					else if(betNumberArr[k].equals("xs")) betNumberArr[k] = "下双";
				}
				overNum.append("<span>").append(insider.getBeDoNumber(Integer.parseInt(gameCode),betNumberArr[k])+"  ").append("[").append(sitAr[k]).append("]").append("</span>");  //获得该结果的SP
				
			}
			String[] result = new String[]{market[0],market[1],market[2],market[3],overNum.toString(),spObj};
			list.add(result);
		}
		return list;
	}
	/**
	 * 
	 * @Title: getBetLanQiuNumber
	 * @Description: 篮彩获得投注号码+SP   3[1.20]
	 * @param @param info
	 * @param @param betMarketId
	 * @param @param gameCode
	 * @param @return
	 * @return List
	 * @throws
	 * @param info
	 * @param betMarketId
	 * @param gameCode
	 * @return
	 */
	public static List getBetLanQiuNumber(String info,String betMarketId,String gameCode,String spObj){
		InsiderCenterFormat insider = new InsiderCenterFormat();
		String[] marketItem =  info.split("\\$");
		String[] soitem = spObj.split("//");
		List  list = new ArrayList(); 
		for(int i = 0; i < marketItem.length;i++)
		{
			String[] market = marketItem[i].split("\\,");
			String[] betNumberArr = market[4].split("\\/");
			String[] sitAr = soitem[i].split("\\,")[1].split("\\/");
			StringBuffer overNum = new StringBuffer();
			for(int k=0;k<betNumberArr.length;k++)
			{
				if(gameCode.equals("510"))
				{
					String lotCode = null ;
					if(betNumberArr[k].indexOf("D")!=-1){lotCode="506";}
					else if(betNumberArr[k].indexOf("B")!=-1){lotCode="508";}
					else if(betNumberArr[k].length()==2){lotCode="507";}
					else{lotCode="505";}
					overNum.append("<span>").append(insider.getBeDoNumber(Integer.parseInt(lotCode),betNumberArr[k])+"  ").append("[").append(sitAr[k]).append("]").append("</span>");  //获得该结果的SP
				}else{
					overNum.append("<span>").append(insider.getBeDoNumber(Integer.parseInt(gameCode),betNumberArr[k])+"  ").append("[").append(sitAr[k]).append("]").append("</span>");  //获得该结果的SP
				}
			}
			String[] result = new String[]{market[0],market[1],market[2],market[3],overNum.toString(),spObj};
			list.add(result);
		}
		return list;
	}
	/**
	 * 
	 * @Title: getBetNumber
	 * @Description: 竞彩获得投注号码+SP   3[1.20]
	 * @param @param info
	 * @param @return
	 * @return String
	 * @throws
	 * @param info
	 * @return
	 */
	public static List getBetNumber(String info,String betMarketId,String gameCode,String spObj){
		
		InsiderCenterFormat insider = new InsiderCenterFormat();
		String[] marketItem =  info.split("\\$");
		HashMap marketSpMap = new WinsFlat().betting_sel(new String[]{betMarketId});
		String showViewNum = "";
		String[] soitem = spObj.split("//");
		List  list = new ArrayList(); 
		for(int i = 0; i < marketItem.length;i++)
		{
			StringBuffer spvalue = new StringBuffer();
			String[] sitAr = soitem[i].split("\\,");
			String[] market = marketItem[i].split("\\,");
			String marketid = market[6];  //场次ID
			String marketspjson = marketSpMap.get(marketid).toString();  //获得该场次全部结果SP
			HashMap spMap = Json.fromJson(HashMap.class,marketspjson);  //sp转为MAP
			String[] betNumberArr = market[4].split("\\/");
			StringBuffer overNum = new StringBuffer();
			String gaveBall = "";
			if(gameCode.equals("511")) gaveBall = "<font color='red'>("+market[3]+")</font>";
			StringBuffer sp = new StringBuffer();
			for(int k = 0; k < betNumberArr.length; k++)
			{
				String spz = "";
				if(gameCode.equals("509")){
					String lotCode = null ; gaveBall = "";
					if(betNumberArr[k].indexOf("R")!=-1) {lotCode = "511";gaveBall = "<font color='red'>("+market[3]+")</font>";}
					else if(betNumberArr[k].indexOf("B")!=-1) {lotCode = "503";}
					else if(betNumberArr[k].indexOf("_")!=-1) {lotCode = "504";}
					else if(betNumberArr[k].indexOf(":")!=-1) {lotCode = "502";}
					else{lotCode = "501";}
					spz = spMap.get(lotCode + betNumberArr[k].replaceAll(":", "-").replaceAll("B", "")).toString();
					overNum.append("<span>").append(gaveBall+insider.getBeDoNumber(Integer.parseInt(lotCode),betNumberArr[k])+"  ").append("[").append(spz).append("]").append("</span>");  //获得该结果的SP
				}else{
					spz = spMap.get(gameCode + betNumberArr[k].replaceAll(":", "-").replaceAll("B", "")).toString();
					overNum.append("<span>").append(gaveBall+insider.getBeDoNumber(Integer.parseInt(gameCode),betNumberArr[k])+"  ").append("[").append(spMap.get(gameCode + betNumberArr[k].replaceAll(":", "-").replaceAll("B", "")).toString()).append("]").append("</span>");  //获得该结果的SP
				}
				sp.append(spz).append("/");
			}
			sp.deleteCharAt(sp.lastIndexOf("/"));
			spvalue.append(marketid).append(",").append(sp).append(",").append(sitAr[2]);
			String[] result = new String[]{market[0],market[1],market[2],market[3],overNum.toString(),spvalue.toString()};
			list.add(result);
		}
		return list;
	}
	
	public static String getLotteryForwrd(String lotteryType)
	{
		String forward = "";
		switch(Integer.parseInt(lotteryType)){
			case 501:
			case 502:
			case 503:
			case 504:
			case 511:
			case 509:
				forward = "jcbetsuccess";
			break;
			case 505:
			case 506:
			case 507:
			case 508:
			case 510:
				forward = "lqbetsuccess";
			break;
			case 301:
			case 302:
			case 303:
			case 304:
			case 305:
				forward = "dcbetsuccess";
			break;
			case 102:
			case 103:
			case 106:
			case 107:
				forward = "zcbetsuccess";
			break;
		}
		return forward;
	}
	/**
	 * 获得彩票类型
	 * 
	 * @param params
	 * @return
	 * @throws LotteryException
	 */
	public static String getLotteryType(String lotteryType) {
		String value = "";
		if(lotteryType==null || lotteryType.equals(""))
		{
			lotteryType = "10000";
		}
		switch (Integer.parseInt(lotteryType)) {
		case 101:
			value = "传统足球进球彩";
			break;
		case 102:
			value = "传统足球胜负彩";
			break;
		case 103:
			value = "传统足球任选9场";
			break;
		case 104:
			value = "36选7";
			break;
		case 105:
			value = "排列三";
			break;
		case 106:
			value = "传统足球四场进球彩";
			break;
		case 107:
			value = "传统足球六场半全场";
			break;
		case 108:
			value = "七星彩";
			break;
		case 109:
			value = "排列五";
			break;
		case 110:
			value = "大乐透";
			break;
		case 201:
			value = "双色球";
			break;
		case 202:
			value = "福彩3D";
			break;
		case 111:
			value = "22选5";
			break;
		case 204:
			value = "深圳风采";
			break;
		case 301:
			value = "单场胜平负";
			break;
		case 302:
			value = "单场上下单双";
			break;
		case 303:
			value = "单场总进球数";
			break;
		case 304:
			value = "单场比分";
			break;
		case 305:
			value = "单场半全场";
			break;
		case 401:
			value="11选5";
			break;
		case 501:
			value="竞彩足球胜平负";
			break;
		case 502:
			value="竞彩足球比分";
			break;
		case 503:
			value="竞彩足球总进球";
			break;
		case 504:
			value="竞彩足球半全场";
			break;
		case 509:
			value="竞彩足球混合过关";
			break;
		case 511:
			value="竞彩足球让球胜平负";
			break;
		case 505:
			value="竞彩篮球胜负";
			break;
		case 506:
			value="竞彩篮球让分胜负";
			break;
		case 507:
			value="竞彩篮球胜负差";
			break;
		case 508:
			value="竞彩篮球大小分";
			break;
		case 510:
			value="竞彩篮球混合过关";
			break;
			
		case 10000:
			value="选择彩种";
		default:
			break;
		}
		return value;
	}
	
	/**
	 * 获得彩票类型
	 * 
	 * @param params
	 * @return
	 * @throws LotteryException
	 */
	public static String getLotteryTypeName(String lotteryType,String dg) {
		String value = "" , dgstr = "";
		if(dg==null){
			dgstr = "";
		}
		else
		{
			String[] dgArr = dg.split("\\_");
			if(dgArr[0].equals("1") && dgArr[1].equals("1"))
			{
				dgstr = "1";
			}
		}
		if(lotteryType==null || lotteryType.equals(""))
		{
			lotteryType = "10000";
		}
		lotteryType= lotteryType + dgstr;
		switch (Integer.parseInt(lotteryType)) {
		case 101:
			value = "进球彩";
			break;
		case 102:
			value = "传统-胜负彩";
			break;
		case 103:
			value = "传统-任选9场";
			break;
		case 104:
			value = "36选7";
			break;
		case 105:
			value = "排列三";
			break;
		case 106:
			value = "传统-4场进球彩";
			break;
		case 107:
			value = "传统-6场半全场";
			break;
		case 108:
			value = "七星彩";
			break;
		case 109:
			value = "排列五";
			break;
		case 110:
			value = "大乐透";
			break;
		case 201:
			value = "双色球";
			break;
		case 202:
			value = "福彩3D";
			break;
		case 111:
			value = "22选5";
			break;
		case 204:
			value = "深圳风采";
			break;
		case 301:
			value = "北京单场-胜平负";
			break;
		case 302:
			value = "北京单场-上下单双";
			break;
		case 303:
			value = "北京单场-总进球数";
			break;
		case 304:
			value = "北京单场-比分";
			break;
		case 305:
			value = "北京单场-半全场";
			break;
		case 401:
			value="11选5";
			break;
		case 501:
			value="竞彩足球-胜平负";
			break;
		case 502:
			value="竞彩足球-比分";
			break;
		case 503:
			value="竞彩足球-总进球";
			break;
		case 504:
			value="竞彩足球-半全场";
			break;
		case 5011:
			value="竞彩足球-单关胜平负";
			break;
		case 5021:
			value="竞彩足球-单关比分";
			break;
		case 5031:
			value="竞彩足球-单关总进球";
			break;
		case 5041:
			value="竞彩足球-单关半全场";
			break;
		case 5111:
			value="竞彩-单关让球胜平负";
			break;
		case 509:
		case 513:
		case 514:
			value="竞彩足球-混合过关";
			break;
		case 511:
			value="竞彩足球-让球胜平负";
			break;
		case 505:
			value="竞彩篮球-胜负";
			break;
		case 506:
			value="竞彩篮球-让分胜负";
			break;
		case 507:
			value="竞彩篮球-胜负差";
			break;
		case 508:
			value="竞彩篮球-大小分";
			break;
		case 5051:
			value="竞彩篮球-单关胜负";
			break;
		case 5061:
			value="竞彩篮球-单关让分胜负";
			break;
		case 5071:
			value="竞彩篮球-单关胜负差";
			break;
		case 5081:
			value="竞彩篮球-单关大小分";
			break;
		case 510:
			value="竞彩篮球-混合过关";
			break;
		case 10000:
		case 100001:
			value="选择彩种";
			break;
		default:
			break;
		}
		return value;
	}
	
	/**
	 * 
	 * @Title: getOverCai
	 * @Description: 玩法和彩果 取投注号码
	 * @param @param gameid
	 * @param @param c
	 * @param @return
	 * @return String
	 * @throws
	 * @param gameid
	 * @param c
	 * @return
	 */
	public static String getOverCai(int gameid , String c){
		Map<String,String> map = Json.fromJson(HashMap.class,OperaterCode.GET_GAMEJSON_CAIGUO_TO_TZ);
		String overcai = map.get(String.valueOf(gameid)+c).toString(); 
		return overcai;
	}
	/**
	 * 
	 * @Title: getBeDoNumber
	 * @Description: 玩法和投注号码 取彩果
	 * @param @param gameid
	 * @param @param c
	 * @param @return
	 * @return String
	 * @throws
	 * @param gameid
	 * @param c
	 * @return
	 */
	public static String getBeDoNumber(int gameid , String c){
		if(304!=gameid){//左国斌2014-6-18解决单关比分问题
			
			Map<String,String> map = Json.fromJson(HashMap.class,OperaterCode.GET_GAMEJSON_TZ_TO_CAIGUO);
			if(gameid!=701)
			{
			String overcai = map.get(String.valueOf(gameid)+c)==null?c: map.get(String.valueOf(gameid)+c).toString(); 
			return overcai;
			}
			else
			{
				return "猜冠军";
			}
		}else{
			return c;
		}
		
	}

	/**
	 * 
	 * @Title: getMzcs
	 * @Description: 命中场数
	 * @param @param gameid
	 * @param @param obj
	 * @param @return
	 * @return int
	 * @throws
	 * @param gameid
	 * @param obj
	 * @return
	 */
	public static int getMzcs(int gameid , Object[] obj){
		int mzcs = 0;
			switch(gameid){
				case 102: mzcs = 14; break;
				case 103: mzcs = 9; break;
				case 106: mzcs = 4; break;
				case 107: mzcs = 6; break;
				default:  mzcs = obj.length; break;
			}
		return mzcs;
	}
	

	/**
	 * 获得投注状态
	 * 
	 * @param params
	 * @return
	 * @throws LotteryException
	 */
	public static String getTzType(String tzType) {
		String value = "";
		switch (Integer.parseInt(tzType)) {
		case -1:
			value = "已撤单";
			break;
		case 0:
			value = "发起成功";
			break;
		case 1:
			value = "投注成功";
			break;
		case 2:
			value = "打印成功";
			break;
		case 3:
			value = "出票成功";
			break;
		case 4:
			value = "已搅奖";
			break;
		case 5:
			value = " 已派奖";
			break;
		default:
			break;
		}
		return value;
	}
	
	
	/**
	 * 获得交易类型
	 * 
	 * @param params
	 * @return
	 * @throws LotteryException
	 */
	public static String getDealType(String dealType) {
		String value = "";
		switch (Integer.parseInt(dealType)) {
		case 1001:
			value = "充值";
			break;
		case 1002:
			value = "提现申请";
			break;
		case 1004:
			value = "管理员辅助充值";
			break;
		case 1005:
			value = "管理员加奖";
			break;
		case 1006:
			value = "中奖派奖";
			break;
		case 1008:
			value = "代购撤单返款";
			break;
		case 1009:
			value = "合买撤单返款";
			break;
		case 2001:
			value = "进球彩代购投注";
			break;
		case 2002:
			value = "进球彩代购追期";
			break;
		case 2003:
			value = "胜负彩代购投注";
			break;
		case 2004:
			value = "胜负彩代购追期";
			break;
		case 2005:
			value = "任选9代购投注";
			break;
		case 2006:
			value = "任选9代购追期";
			break;
		case 2007:
			value = "36选7代购投注";
			break;
		case 2008:
			value = "36选7代购追期";
			break;
		case 2009:
			value = "4场进球彩代购投注";
			break;
		case 2010:
			value = "4场进球彩代购追期";
			break;
		case 2011:
			value = "6场半全场代购投注";
			break;
		case 2012:
			value = "6场半全场代购追期";
			break;
		case 2013:
			value = "七星彩代购投注";
			break;
		case 2014:
			value = "七星彩代购追期";
			break;
		case 2015:
			value = "排列5代购投注";
			break;
		case 2016:
			value = "排列5代购追期";
			break;
		case 2017:
			value = "大乐透代购投注";
			break;
		case 2018:
			value = "大乐透代购追期";
			break;
		case 2019:
			value = "双色球代购投注";
			break;
		case 2020:
			value = "双色球代购追期";
			break;
		case 2021:
			value = "福彩3D代购投注";
			break;
		case 2022:
			value = "福彩3D代购追期";
			break;
		case 2023:
			value = "22选5代购投注";
			break;
		case 2024:
			value = "22选5代购追期";
			break;
		case 2025:
			value = "深圳风采代购投注";
			break;
		case 2026:
			value = "深圳风采代购追期";
			break;
		case 2027:
			value = "七乐彩代购投注";
			break;
		case 2028:
			value = "七乐彩代购追期";
			break;
		case 2029:
			value = "排列三代购投注";
			break;
		case 2030:
			value = "排列三代购追期";
			break;
		case 3001:
			value = "胜负彩合买参与";
			break;
		case 3002:
			value = "任选9合买参与";
			break;
		case 3003:
			value = "36选7合买参与";
			break;
		case 3004:
			value = "排列三合买参与";
			break;
		case 3005:
			value = "4场进球彩合买参与";
			break;
		case 3006:
			value = "6场半全场合买参与";
			break;
		case 3007:
			value = "七星彩合买参与";
			break;
		case 3008:
			value = "排列5合买参与";
			break;
		case 3009:
			value = "大乐透合买参与";
			break;
		case 3010:
			value = "双色球合买参与";
			break;
		case 3011:
			value = "福彩3D合买参与";
			break;
		case 3012:
			value = "22选5合买参与";
			break;
		case 3013:
			value = "深圳风采合买参与";
			break;
		case 3014:
			value = "七乐彩合买参与";
			break;
		case 3015:
			value = "胜负彩合买保底";
			break;
		case 3016:
			value = "任选9合买保底";
			break;
		case 3017:
			value = "36选7合买保底";
			break;
		case 3018:
			value = "排列三合买保底";
			break;
		case 3019:
			value = "4场进球彩合买保底";
			break;
		case 3020:
			value = "6场半全场合买保底";
			break;
		case 3021:
			value = "七星彩合买保底";
			break;
		case 3022:
			value = "排列5合买保底";
			break;
		case 3023:
			value = "大乐透合买保底";
			break;
		case 3024:
			value = "双色球合买保底";
			break;
		case 3025:
			value = "福彩3D合买保底";
			break;
		case 3026:
			value = "22选5合买保底";
			break;
		case 3027:
			value = "深圳风采合买保底";
			break;
		case 3028:
			value = "七乐彩合买保底";
			break;
		case 3029:
			value = "胜负彩合买个人撤单";
			break;
		case 3030:
			value = "任选9合买个人撤单";
			break;
		case 3031:
			value = "36选7合买个人撤单";
			break;
		case 3032:
			value = "排列三合买个人撤单";
			break;
		case 3033:
			value = "4场进球彩合买个人撤单";
			break;
		case 3034:
			value = "6场半全场合买个人撤单";
			break;
		case 3035:
			value = "七星彩合买个人撤单";
			break;
		case 3036:
			value = "排列5合买个人撤单";
			break;
		case 3037:
			value = "大乐透合买个人撤单";
			break;
		case 3038:
			value = "双色球合买个人撤单";
			break;
		case 3039:
			value = "福彩3D合买个人撤单";
			break;
		case 3040:
			value = "22选5合买个人撤单";
			break;
		case 3041:
			value = "深圳风采合买个人撤单";
			break;
		case 3042:
			value = "七乐彩合买个人撤单";
			break;
		case 3043:
			value = "胜负彩合买系统撤单";
			break;
		case 3044:
			value = "任选9合买系统撤单";
			break;
		case 3045:
			value = "36选7合买系统撤单";
			break;
		case 3046:
			value = "排列三合买系统撤单";
			break;
		case 3047:
			value = "4场进球彩合买系统撤单";
			break;
		case 3048:
			value = "6场半全场合买系统撤单";
			break;
		case 3049:
			value = "七星彩合买系统撤单";
			break;
		case 3050:
			value = "排列5合买系统撤单";
			break;
		case 3051:
			value = "大乐透合买系统撤单";
			break;
		case 3052:
			value = "双色球合买系统撤单";
			break;
		case 3053:
			value = "福彩3D合买系统撤单";
			break;
		case 3054:
			value = "22选5合买系统撤单";
			break;
		case 3055:
			value = "深圳风采合买系统撤单";
			break;
		case 3056:
			value = "七乐彩合买系统撤单";
			break;
		case 3058:
			value = "胜平负合买保底";
			break;
		case 3059:
			value = "上下单双合买保底";
			break;
		case 3060:
			value = "比分合买保底";
			break;
		case 3061:
			value = "半全场合买保底";
			break;
		case 3062:
			value = "总进球数合买保底";
			break;
		case 3063:
			value = "胜平负合买系统撤单";
			break;
		case 3064:
			value = "上下单双合买系统撤单";
			break;
		case 3065:
			value = "比分合买系统撤单";
			break;
		case 3066:
			value = "半全场合买系统撤单";
			break;
		case 3067:
			value = "总进球数系统撤单";
			break;
		case 3068:
			value = "胜平负合买个人撤单";
			break;
		case 3069:
			value = "上下单双合买个人撤单";
			break;
		case 3070:
			value = "比分合买个人撤单";
			break;
		case 3071:
			value = "总进球数合买参与";
			break;
		case 3072:
			value = "总进球数合买个人撤单";
			break;
		case 3078:
			value = "胜平负合买参与";
			break;
		case 3079:
			value = "上下单双合买参与";
			break;
		case 3080:
			value = "比分合买参与";
			break;
		case 3081:
			value = "半全场合买参与";
			break;
		case 3082:
			value = "总进球数合买参与";
			break;
		case 3083:
			value = "停赛退款";
			break;
		case 5001:
			value = "胜平负保底";
			break;
		case 5002:
			value = "胜平负参与";
			break;
		case 5003:
			value = "胜平负个人撤单";
			break;
		case 5004:
			value = "胜平负系统撤单";
			break;
		case 1012:
			value = "注册充值";
			break;
		case 1013:
			value = "网银充值";
			break;
		case 6001:
			value = "充值赠送10%";
			break;
		case 6002:
			value = "方案提成奖金";
			break;
		case 6003:
			value = "保底奖金";
			break;
		case 5006:
			value = "比分参与";
			break;
		case 5005:
			value = "比分保底";
			break;
		case 5007:
			value = "比分个人撤单";
			break;
		case 5008:
			value = "比分系统撤单";
			break;
		case 5009:
			value = "总进球保底";
			break;
		case 5010:
			value = "总进球参与";
			break;
		case 5011:
			value = "总进球个人撤单";
			break;
		case 5012:
			value = "总进球系统撤单";
			break;
		case 5013:
			value = "半全场保底";
			break;
		case 5014:
			value = "半全场参与";
			break;
		case 5015:
			value = "半全场个人撤单";
			break;
		case 5016:
			value = "半全场系统撤单";
			break;
		case 3084:
			value = "CPS佣金转入";
			break;
		case 5017:
			value = "胜负保底";
			break;
		case 5018:
			value = "胜负参与";
			break;
		case 5019:
			value = "胜负个人撤单";
			break;
		case 5020:
			value = "胜负系统撤单";
			break;
		case 5021:
			value = "让分胜负保底";
			break;
		case 5022:
			value = "让分胜负参与";
			break;
		case 5023:
			value = "让分胜负个人撤单";
			break;
		case 5024:
			value = "让分胜负系统撤单";
			break;
		case 5025:
			value = "胜分差保底";
			break;
		case 5026:
			value = "胜分差参与";
			break;
		case 5027:
			value = "胜分差个人撤单";
			break;
		case 5028:
			value = "胜分差系统撤单";
			break;
		case 5029:
			value = "大小分保底";
			break;
		case 5030:
			value = "大小分参与";
			break;
		case 5031:
			value = "大小分个人撤单";
			break;
		case 5032:
			value = "大小分系统撤单";
			break;
		case 7001:
			value = "投注返点";
			break;
		case 7002:
			value = "上线返点";
			break;
		case 7003:
			value = "转款";
			break;
		case 7004:
			value = "收款";
			break;
		case 8001:
			value = "加奖";
			break;
		case 5033:
			value = "让球胜平负保底";
			break;
		case 5034:
			value = "让球胜平负参与";
			break;
		case 5035:
			value = "让球胜平负个人撤单";
			break;
		case 5036:
			value = "让球胜平负系统撤单";
			break;
		case 5038:
			value = "竞彩足球混投参与";
			break;
		default:
			break;
		}
		return value;
	}

	/**
	 * 获得冻结类型
	 * 
	 * @param params
	 * @return
	 * @throws LotteryException
	 */
	public static String getDjType(String djType) {
		String value = "";
		switch (Integer.parseInt(djType)) {
		case 2001:
			value = "进球彩代购投注";
			break;
		case 2002:
			value = "进球彩代购追期";
			break;
		case 2003:
			value = "胜负彩代购投注";
			break;
		case 2004:
			value = "胜负彩代购追期";
			break;
		case 2005:
			value = "任选9代购投注";
			break;
		case 2006:
			value = "任选9代购追期";
			break;
		case 2007:
			value = "36选7代购投注";
			break;
		case 2008:
			value = "36选7代购追期";
			break;
		case 2009:
			value = "4场进球彩代购投注";
			break;
		case 2010:
			value = "4场进球彩代购追期";
			break;
		case 2011:
			value = "6场半全场代购投注";
			break;
		case 2012:
			value = "6场半全场代购追期";
			break;
		case 2013:
			value = "七星彩代购投注";
			break;
		case 2014:
			value = "七星彩代购追期";
			break;

		case 2015:
			value = "排列5代购投注";
			break;
		case 2016:
			value = "排列5代购追期";
			break;
		case 2017:
			value = "大乐透代购投注";
			break;
		case 2018:
			value = "大乐透代购追期";
			break;
		case 2019:
			value = "双色球代购投注";
			break;
		case 2020:
			value = "双色球代购追期";
			break;
		case 2021:
			value = "福彩3D代购投注";
			break;
		case 2022:
			value = "福彩3D代购追期";
			break;
		case 2023:
			value = "22选5代购投注";
			break;
		case 2024:
			value = "22选5代购追期";
			break;
		case 2025:
			value = "深圳风采代购投注";
			break;

		case 2026:
			value = "深圳风采代购追期";
			break;
		case 2027:
			value = "七乐彩代购投注";
			break;
		case 2028:
			value = "七乐彩代购追期";
			break;
		case 2029:
			value = "排列三代购投注";
			break;
		case 2030:
			value = "排列三代购追期";
			break;
		case 2036:
			value="11选5代购投注";
			break;
		case 2037:
			value="11选5代购追加";
			break;
		}
		return value;
	}

	/**
	 * 获得冻结状态
	 * 
	 * @param params
	 * @return
	 * @throws LotteryException
	 */
	public static String getDjStatus(String status) {
		String value = "";
		switch (Integer.parseInt(status)) {
		case 0:
			value = "冻结中";
			break;
		case 11:
			value = "已解冻";
			break;
		}
		return value;
	}

	/**
	 * 获得来源
	 * 
	 * @param params
	 * @return
	 * @throws LotteryException
	 */
	public static String getSource(String source) {
		String value = "";
		switch (Integer.parseInt(source)) {
		case 1001:
		case 0:
			value = "web";
			break;
		case 1002:
			value = "mobile";
			break;
		case 2001:
			value = "mobile";
			break;
			
		default:
			break;
		}
		return value;
	}

	/**
	 * 获得玩法的投注方式
	 * 
	 * @param params
	 * @return
	 * @throws LotteryException
	 */
	public static String getTzManner(String manner) {
		String value = "";
		switch (Integer.parseInt(manner)) {
		case 1:
			value = "单式";
			break;
		case 2:
			value = "复式";
			break;
		case 3:
			value = "胆拖";
			break;
		case 11:
			value = "直选单式";
			break;
		case 13:
			value = "组3单式";
			break;
		case 16:
			value = "组6单式";
			break;
		case 21:
			value = "直选复式";
			break;
		case 23:
			value = "组3复式";
			break;
		case 26:
			value = "组6复式";
			break;
		case 31:
			value = "直选和值";
			break;
		case 32:
			value = "组选和值";
			break;
		default:
			break;
		}
		return value;
	}

	//格式化单场
	public static String getTzMannerdc(String manner) {
		String value = "";
		String[] mannerValue = manner.split(",");
		for (int i = 0; i < mannerValue.length; i++) {
			value += StandFormat.danchang_mannerMap.get(mannerValue[i]) + ",";
		}

		return value;

	}

	/**
	 * 获得中奖的状态
	 * 
	 * @param params
	 * @return
	 * @throws LotteryException
	 */
	public static String getZjStatus(String status) {
		String value = "";
		switch (Integer.parseInt(status)) {
		case 0:
			value = "中奖";
			break;
		case 1:
			value = "派奖";
			break;
		case 4:
			value = "已中奖";
			break;
		case 5:
			value = "已派奖";
			break;
		default:
			break;
		}
		return value;
	}

	/**
	 * 获得中奖的状态
	 * 
	 * @param params
	 * @return
	 * @throws LotteryException
	 */
	public static String getHmType(String type) {
		String value = "";
		switch (Integer.parseInt(type)) {
		case -3:
			value = "系统撤单";
			break;
		case -2:
			value = "个人撤单";
			break;
		case -1:
			value = "废票";
			break;
		case 0:
			value = "发起成功";
			break;
		case 1:
			value = "处理成功";
			break;
		case 2:
			value = "打印成功";
			break;
		case 3:
			value = "出票成功";
			break;
		case 4:
			value = "出票成功";
			break;
		case 5:
			value = "出票成功";
			break;
		default:
			break;
		}
		return value;
	}

	/**上传号码的时候
	 * 单场 302  格式化号码
	 * 
	 * @param params
	 * @return
	 * @throws LotteryException
	 */
	public static String get302(String type) {
		String value = "";
		switch (Integer.parseInt(type)) {
		case 3:
			value = "上单";
			break;
		case 2:
			value = "上双";
			break;
		case 1:
			value = "下单";
			break;
		case 0:
			value = "下双";
			break;
		default:
			break;
		}
		return value;
	}

	/**上传号码的时候
	 * 单场 305  格式化号码
	 * 
	 * @param params
	 * @return
	 * @throws LotteryException
	 */
	public static String get305(String type) {
		String value = "";
		switch (Integer.parseInt(type)) {
		case 33:
			value = "3-3";
			break;
		case 31:
			value = "3-1";
			break;
		case 30:
			value = "3-0";
			break;
		case 13:
			value = "1-3";
			break;
		case 11:
			value = "1-1";
			break;
		case 10:
			value = "1-0";
			break;
		case 03:
			value = "0-3";
			break;
		case 01:
			value = "0-1";
			break;
		case 00:
			value = "0-0";
			break;
		default:
			break;
		}
		return value;
	}

	public static String get304(String type) {
		String value = "";
		switch (Integer.parseInt(type)) {
		case 10:
			value = "1:0";
			break;
		case 20:
			value = "2:0";
			break;
		case 30:
			value = "3:0";
			break;
		case 40:
			value = "4:0";
			break;
		case 21:
			value = "2:1";
			break;
		case 31:
			value = "3:1";
			break;
		case 41:
			value = "4:1";
			break;
		case 32:
			value = "3:2";
			break;
		case 42:
			value = "4:2";
		case 43:
			value = "4:3";
			break;
		case 00:
			value = "0:0";
			break;
		case 11:
			value = "1:1";
			break;
		case 22:
			value = "2:2";
			break;
		case 33:
			value = "3:3";
			break;
		case 44:
			value = "4:4";
			break;
		case 01:
			value = "0:1";
			break;
		case 02:
			value = "0:2";
			break;
		case 03:
			value = "2:2";
			break;
		case 04:
			value = "3:3";
			break;
		case 12:
			value = "4:4";
			break;
		case 13:
			value = "0:0";
			break;
		case 14:
			value = "1:1";
			break;
		case 23:
			value = "2:2";
			break;
		case 24:
			value = "3:3";
			break;
		case 34:
			value = "3:4";
			break;
		default:
			break;
		}
		return value;
	}
}
