package com.letousky.lottery.util;

import java.util.HashMap;
import java.util.Map;

public class StandFormat {
	// 交易类型对照
	public static Map<String, String> tradeType_gameCode = new HashMap<String, String>();
	public static Map<String, String> applyType = new HashMap<String, String>();
	public static Map<String, String> lotNameMap = new HashMap<String, String>();
	public static Map<String, String> order_status = new HashMap<String, String>();
	public static Map<String, String> mannerMap = new HashMap<String, String>();
	public static Map<String, String> danchang_mannerMap = new HashMap<String, String>();
	public static Map<String, String> freezedType = new HashMap<String, String>();
	public static Map<String, String> prePaidType = new HashMap<String, String>();
	public static Map<String, String> chipinStatus = new HashMap<String, String>();
	public static Map<String, String> cardType = new HashMap<String, String>();

	static {
		// initTradeType_gameCode();
		initApplyType();
		initLotName();
		initOrderStatus();
		initMannerMap();
		initFreezedType();
		initPrePaidType();
		initChipinStatus();
		initCardType();
		danchang_initMannerMap();

	}

	public static void initCardType() {
		cardType.put("0", "身份证");
	}

	public static String getPlayCodes(String lotName, String code) {
		code = "/" + code.trim().replace("/", "//") + "/";
		String s = ",201,104,204,110,111,205,";
		return ((s.indexOf(("," + lotName + ",")) != -1) ? code.replaceAll(
				"/(\\d{1})/", "/0$1/") : code).replaceAll("^/", "").replaceAll(
				"/$", "").replace("//", "/");
	}

	private static void initChipinStatus() {
		chipinStatus.put("-1", "废票");
		chipinStatus.put("1", "投注成功");
		chipinStatus.put("2", "打印成功");
		chipinStatus.put("3", "出票成功");
		chipinStatus.put("4", "已搅奖");
		chipinStatus.put("5", "已派奖");
	}

	private static void initFreezedType() {
		freezedType.put("1001", "充值");
		freezedType.put("1012", "活动奖金");
		freezedType.put("1002", "提现");
		freezedType.put("1003", "充值100元以上加款");
		freezedType.put("1004", "管理员辅助充值");
		freezedType.put("1005", "管理员加奖");
		freezedType.put("1006", "中奖派奖");
		freezedType.put("1008", "代购撤单返款");
		freezedType.put("1009", "合买撤单返款");
		freezedType.put("2001", "进球彩代购投注");
		freezedType.put("2003", "胜负彩代购投注");
		freezedType.put("2005", "任选9代购投注");
		freezedType.put("2007", "36选7代购投注");
		freezedType.put("2009", "4场进球彩代购投注");
		freezedType.put("2011", "6场半全场胜负彩代购投注");
		freezedType.put("2013", "七星彩代购投注");
		freezedType.put("2015", "排列5代购投注");
		freezedType.put("2017", "大乐透代购投注");
		freezedType.put("2019", "双色球代购投注");
		freezedType.put("2021", "3D代购投注");
		freezedType.put("2023", "22选5代购投注");
		freezedType.put("2025", "深圳风采代购投注");
		freezedType.put("2027", "七乐彩代购投注");
		freezedType.put("2029", "排列三代购投注");
		freezedType.put("2026", "深圳风采代购追期");
		freezedType.put("2028", "七乐彩代购追期");
		freezedType.put("2030", "排列三代购追期");
		freezedType.put("3015", "胜负彩合买保底");
		freezedType.put("3016", "任选9合买保底");
		freezedType.put("3017", "36选7合买保底");
		freezedType.put("3018", "排列三合买保底");
		freezedType.put("3019", "4场进球彩合买保底");
		freezedType.put("3020", "6场半全场胜负彩合买保底");
		freezedType.put("3021", "七星彩合买保底");
		freezedType.put("3022", "排列5合买保底");
		freezedType.put("3023", "大乐透合买保底");
		freezedType.put("3024", "双色球合买保底");
		freezedType.put("3025", "3D合买保底");
		freezedType.put("3026", "22选5合买保底");
		freezedType.put("3027", "深圳风采合买保底");
		freezedType.put("3028", "七乐彩合买保底");
		freezedType.put("2002", "进球彩代购追期");
		freezedType.put("2004", "胜负彩代购追期");
		freezedType.put("2006", "任选9代购追期");
		freezedType.put("2008", "36选7代购追期");
		freezedType.put("2010", "4场进球彩代购追期");
		freezedType.put("2014", "七星彩代购追期");
		freezedType.put("2016", "排列5代购追期");
		freezedType.put("2018", "大乐透代购追期");
		freezedType.put("2020", "双色球代购追期");
		freezedType.put("2022", "3D代购追期");
		freezedType.put("2024", "22选5代购追期");
		freezedType.put("2026", "深圳风采代购追期");
		freezedType.put("2028", "七乐彩代购追期");
		freezedType.put("2030", "排列三代购追期");
		freezedType.put("1011", "激活活动加钱");
		freezedType.put("3057", "排列三系统撤单");
	}

	private static void initPrePaidType() {
		prePaidType.put("0", "nps");
		prePaidType.put("1", "支付宝");
		prePaidType.put("2", "快钱");
	}

	private static void initApplyType() {
		applyType.put("-1", "处理失败");
		applyType.put("0", "等待处理");
		applyType.put("1", "处理成功");
	}

	private static void initOrderStatus() {
		order_status.put("-1", "已撤销");
		order_status.put("0", "成功");
	}

	private static void initLotName() {
		lotNameMap.put("102", "胜负彩");
		lotNameMap.put("103", "任选9");
		lotNameMap.put("104", "36选7");
		lotNameMap.put("105", "排列3");
		lotNameMap.put("106", "4场进球");
		lotNameMap.put("107", "6场胜负");
		lotNameMap.put("108", "七星彩");
		lotNameMap.put("109", "排列5");
		lotNameMap.put("110", "大乐透");
		lotNameMap.put("201", "双色球	");
		lotNameMap.put("202", "3D福彩");
		lotNameMap.put("111", "22选5");
		lotNameMap.put("204", "深圳风采");
		lotNameMap.put("205", "七乐彩");
		lotNameMap.put("401", "11选5");
		lotNameMap.put("301", "胜平负");
		lotNameMap.put("302", "上下盘");
		lotNameMap.put("303", "总进球");
		lotNameMap.put("304", "比分");
		lotNameMap.put("305", "半全场");
		lotNameMap.put("501", "胜平负");
		lotNameMap.put("502", "总进球数");
		lotNameMap.put("503", "比分");
		lotNameMap.put("504", "半全场");
	}

	private static void initMannerMap() {
		mannerMap.put("1", "单式");
		mannerMap.put("2", "复式");
		mannerMap.put("3", "胆托");
		mannerMap.put("5", "单式追期");
		mannerMap.put("6", "复式追期");
		mannerMap.put("7", "胆拖追期");
		mannerMap.put("8", "12选2单式");
		mannerMap.put("9", "12选2复式");
		mannerMap.put("11", "直选单式");
		mannerMap.put("13", "组三单式");
		mannerMap.put("16", "组六单式");
		mannerMap.put("21", "直选复式");
		mannerMap.put("23", "组三复式");
		mannerMap.put("26", "组六复式");
		mannerMap.put("31", "直选和值");
		mannerMap.put("33", "组三和值");
		mannerMap.put("36", "组六和值");

	}

	private static void danchang_initMannerMap() {
		danchang_mannerMap.put("0", "待定");
		danchang_mannerMap.put("1", "单关");
		danchang_mannerMap.put("2", "2串1");
		danchang_mannerMap.put("3", "2串3");
		danchang_mannerMap.put("4", "3串1");
		danchang_mannerMap.put("5", "3串4");
		danchang_mannerMap.put("6", "3串7");
		danchang_mannerMap.put("7", "4串1");
		danchang_mannerMap.put("8", "4串5");
		danchang_mannerMap.put("9", "4串11");
		danchang_mannerMap.put("10", "4串15");
		danchang_mannerMap.put("11", "5串1");
		danchang_mannerMap.put("12", "5串6");
		danchang_mannerMap.put("13", "5串16");
		danchang_mannerMap.put("14", "5串26");
		danchang_mannerMap.put("15", "5串31");
		danchang_mannerMap.put("16", "6串1");
		danchang_mannerMap.put("17", "6串7");
		danchang_mannerMap.put("18", "6串22");
		danchang_mannerMap.put("19", "6串42");
		danchang_mannerMap.put("20", "6串57");
		danchang_mannerMap.put("21", "6串63");

		danchang_mannerMap.put("22", "7串1");
		danchang_mannerMap.put("23", "8串1");
		danchang_mannerMap.put("24", "9串1");
		danchang_mannerMap.put("25", "10串1");
		danchang_mannerMap.put("26", "11串1");

		danchang_mannerMap.put("27", "12串1");
		danchang_mannerMap.put("28", "13串1");
		danchang_mannerMap.put("29", "14串1");
		danchang_mannerMap.put("30", "15串1");

	}
}
