package com.letousky.lottery.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

import com.letousky.exception.LotteryException;



/**
 * 
 * @author Administrator
 *
 */
public class TimeUtil {

	/**
	 * 
	 * @param s 需要分隔的string
	 * @param b true日期分隔,false时间分隔
	 * @return 新的格式string
	 */
	public static String string2timeStr(String s, boolean b) {
		return b ? (s.substring(0, 4) + "-" + s.substring(4, 6) + "-" + s
				.substring(6)) : (s.substring(0, 2) + ":" + s.substring(2, 4));
	}

	//2008-01-22 14:30
	public static String string2timeH(String s) {
		return s.substring(0, 4) + "-" + s.substring(4, 6) + "-"
				+ s.substring(6, 8) + " " + s.substring(8, 10) + ":"
				+ s.substring(10, 12);
	}

	//2008-01-22 14:30:00
	public static String string2timeHS(String s) {
		return s.substring(0, 4) + "-" + s.substring(4, 6) + "-"
				+ s.substring(6, 8) + " " + s.substring(8, 10) + ":"
				+ s.substring(10, 12) + ":" + s.substring(12, 14);
	}

	//2008年01月22 14:30
	public static String string2time(String s) {
		return s.substring(0, 4) + "年" + s.substring(4, 6) + "月"
				+ s.substring(6, 8) + "日 " + s.substring(8, 10) + ":"
				+ s.substring(10, 12);
	}

	// 14:30
	public static String stringOnlytime(String s) {
		return s.substring(8, 10) + ":" + s.substring(10, 12);
	}

	/**
	 * 
	 * @param timeType
	 * @return
	 * @throws LotteryException
	 */
	public static String getDate(String timeType) throws LotteryException {
		String strTime = null;
		try {
			SimpleDateFormat simpledateformat = new SimpleDateFormat(timeType);
			strTime = simpledateformat.format(new Date());
		} catch (Exception ex) {
			throw new LotteryException(ex.getMessage());
		}
		return strTime;
	}

	public static long getCurrentDateTime() {
		try {

		} catch (Exception ex) {
			throw new LotteryException(ex.getMessage());
		}
		return 1;
	}

	public static String getDatetoString(String timeType, Date date)
			throws LotteryException {
		String strTime = null;
		try {
			SimpleDateFormat simpledateformat = new SimpleDateFormat(timeType);
			strTime = simpledateformat.format(date);
		} catch (Exception ex) {
			throw new LotteryException(ex.getMessage());
		}
		return strTime;
	}

	/**
	 * 
	 * @param timeType
	 * @return
	 * @throws LotteryException
	 */
	public static String getDateTime(String timeType) throws LotteryException {
		String strTime = null;
		try {
			SimpleDateFormat simpledateformat = new SimpleDateFormat(timeType);
			strTime = simpledateformat.format(new Date());
		} catch (Exception ex) {
			throw new LotteryException(ex.getMessage());
		}
		return strTime;
	}

	/**
	 * 
	 * @param timeType
	 * @param timePos
	 * @param day
	 * @return
	 * @throws LotteryException
	 */
	public static String getBeforeTime(String timeType, String timePos, int day)
			throws LotteryException {
		long dateLong = 0;
		SimpleDateFormat simpleDateFormat = new SimpleDateFormat(timeType);
		if ((timePos == null) || ("".equals(timePos))) {
			dateLong = new Date().getTime();
		} else {
			try {
				dateLong = simpleDateFormat.parse(timePos).getTime();
			} catch (ParseException ex) {
				throw new LotteryException(ex.getMessage());
			}
		}
		dateLong = dateLong - day * 24 * 60 * 60 * 1000;
		return simpleDateFormat.format(new Date(dateLong)).toString();
	}

	/**
	 * 把字符串变yyyyMMddHHmmss
	 */
	public static long getStringToDate(String str) {
		DateFormat f = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		Date ad;
		try {
			ad = f.parse(str);
			SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");
			Date d = new Date();
			String s = format.format(ad);
			return Long.valueOf(s);
		} catch (ParseException e) {
			throw new LotteryException(e.getMessage());
		}
	}

	/**
	 * 把字符串变 yyyy-MM-dd hh:mm:ss
	 * @param str
	 * @return
	 */
	public static String formatStr(String str) {
		if (str == null || str == "") {
			return "";
		}
		DateFormat f = new SimpleDateFormat("yyyyMMddHHmmss");
		Date ad;
		try {
			ad = f.parse(str);
			SimpleDateFormat format = new SimpleDateFormat(
					"yyyy-MM-dd HH:mm:ss");
			Date d = new Date();
			String s = format.format(ad);
			return s;
		} catch (ParseException e) {
			throw new LotteryException(e.getMessage());
		}

	}

	/**
	 * 比较时间
	 */
	public static String compareTime() {
		Calendar c = Calendar.getInstance();
		SimpleDateFormat simpleDateTimeFormat = new SimpleDateFormat(
				"HH:mm:ss ");
		c = Calendar.getInstance(Locale.CHINESE);
		String s1 = simpleDateTimeFormat.format(c.getTime()); //系统当前时间
		System.out.println(s1);

		String s2 = "20:00:00";
		java.text.DateFormat df = new java.text.SimpleDateFormat("HH:mm:ss");
		java.util.Calendar c1 = java.util.Calendar.getInstance();
		java.util.Calendar c2 = java.util.Calendar.getInstance();
		try {
			c1.setTime(df.parse(s1));
			c2.setTime(df.parse(s2));
		} catch (java.text.ParseException e) {
			System.err.println("格式不正确");
		}
		int result = c1.compareTo(c2);
		if (result == 0)
			return "true";
		else if (result < 0)
			return "false";
		else
			return "true";
	}

	/**
	 * 把字符串变  
	 * @param time  传进来的时间   和系统时间的 比较
	 * @return
	 */
	public static boolean compareTimeSize(String time) {

		
		 
		Date date = new Date();
		SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		String s1 = df.format(date);

		java.util.Calendar c1 = java.util.Calendar.getInstance();
		java.util.Calendar c2 = java.util.Calendar.getInstance();
	 	
		try {
			
		
			c1.setTime(df.parse(s1));
			c1.add(c1.MINUTE,30);
			c2.setTime(df.parse(time));
			//时间加10分钟
		} catch (java.text.ParseException e) {
			System.err.println("格式不正确");
		}
		int result = c1.compareTo(c2);
		if (result == 0) {
			return true;
		} else if (result < 0) {
			//System.out.println("c1小于c2");
			return true;
		} else {
			//System.out.println("c1大于c2");
			return false;
		}

	}

	public static void main(String[] args) {
		
		TimeUtil time=new TimeUtil();
		
		SimpleDateFormat s = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		Calendar myTime=Calendar.getInstance();


	//	System.out.println(s.format(myTime.getTime()));

	//	myTime.add(myTime.MINUTE,4);

	

		System.out.println(s.format(myTime.getTime()));

		System.out.println(time.compareTimeSize(s.format(myTime.getTime())));

	}
}
