package com.jingCaiBack.action;

import java.io.PrintWriter;
import java.util.Date;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import com.jingCaiBack.dao.ChipinTempDAO;
import com.jingCaiBack.model.ChipinTemp;

public class ChipinTempAction extends AbstractAction {

	private ChipinTempDAO chipinTempDAO=new ChipinTempDAO();
	public ActionForward chipinTempList(ActionMapping mapping,
			ActionForm form, HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		request.setCharacterEncoding("UTF-8");
		String tempId=request.getParameter("tempId");//获取商业号
		String serialNo=request.getParameter("serialNo");//获取序列号
		String userNickName=request.getParameter("userNickName");//获取昵称
		String startDate=request.getParameter("startDate");//获取开始时间
		String endDate = request.getParameter("endDate");//获取结束时间
		String startTime = startDate.replaceAll("\\D+", "") + "000000";//格式化开始时间
		String endTime = endDate.replaceAll("\\D+", "") + "235959";//格式化结束时间
		if (StringUtils.isEmpty(startDate))
			startDate = sdf3.format(new Date());//如果为空就赋值当前时间给开始时间
		if (StringUtils.isEmpty(endDate))
			endDate = sdf3.format(new Date());//如果为空就赋值当前时间给结束时间
		//以下用于分页
		int page = getIntParameter(request, "page");//获取页数
		if (page < 0)
			page = 1;
		int start = (page - 1) * 10;//起始记录数
		int end = page * 10;//结束记录数
		List chipinTempList=chipinTempDAO.getList(tempId, serialNo, userNickName,start,end, startTime, endTime);//查询出LIst
		int count=chipinTempDAO.getCount(tempId, serialNo, userNickName, startTime, endTime);//查询出一共多少条记录
		int pageCount = (count % 10 == 0) ? count / 10 : count / 10 + 1;//每页显示的记录数
		

		StringBuilder sb = new StringBuilder();//定义一个可增加的String缓冲对象
		sb.append("{");
		sb.append("items:[");
		ChipinTemp chipinTemp=null;
		for (int i = 0; i < chipinTempList.size(); i++) {
			chipinTemp=(ChipinTemp)chipinTempList.get(i);
			sb.append("{");
			sb.append("tempId:'" + chipinTemp.getTempId() + "',");//商业编号
			sb.append("serialNo:'" + chipinTemp.getSerialNo() + "',");//序列号(交易号)
			sb.append("userNickName:'" + chipinTemp.getUserNickName() + "',");//用户昵称
			sb.append("gameCode:'" + chipinTemp.getGameCode() + "',");//彩种编号
			sb.append("manner:'" + chipinTemp.getManner() + "',");//投注方式
			sb.append("record:'" + chipinTemp.getRecord() + "',");//注数
			sb.append("multiple:'" + chipinTemp.getMultiple() + "',");//倍数
			sb.append("bets:'" + chipinTemp.getBets() + "',");//投注金额
			sb.append("chipinNums:'" + chipinTemp.getChipinNums() + "',");//投注号码
			sb.append("spValue:'" + chipinTemp.getSpValue() + "',");//赔率
			sb.append("tempAwardBets:'" + chipinTemp.getTempAwardBets() + "',");//中奖金额
			sb.append("voteProccessTime:'" + chipinTemp.getVoteProccessTime() + "'");//最后打印时间
			sb.append("}");
			if (i == chipinTempList.size() - 1)
				continue;
			sb.append(",");
			
		}
		sb.append("]");
		sb.append(",count:'" + count + "'");//存入记录数
		sb.append(",pageCount:'" + pageCount + "'");//每页显示的条数
		sb.append("}");
		
		nocache(response);
		response.setContentType("text/html;charset=UTF-8");
		PrintWriter out = response.getWriter();
		out.print(sb.toString());
		return null;//AJAX没有返回
		
	}
}
