 package com.jingCaiBack.action;
 
 import com.jingCaiBack.dao.ChipinTempDAO;
 import com.jingCaiBack.dao.HmfaDAO;
 import com.jingCaiBack.model.ChipinTemp;
 import com.jingCaiBack.model.Hmfa;
 import com.jingCaiBack.util.CommonUtil;
 import com.jingCaiBack.util.Contants;
 import java.io.PrintWriter;
 import java.util.List;
 import java.util.Map;
 import javax.servlet.http.HttpServletRequest;
 import javax.servlet.http.HttpServletResponse;
 import org.apache.commons.lang.StringUtils;
 import org.apache.struts.action.ActionForm;
 import org.apache.struts.action.ActionForward;
 import org.apache.struts.action.ActionMapping;
 
 public class HmfaAction extends AbstractAction
 {
   private HmfaDAO hmfaDao = new HmfaDAO();
   private ChipinTempDAO chipinTempDao = new ChipinTempDAO();
 
   public ActionForward hmfaList(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response)
     throws Exception
   {
     request.setCharacterEncoding("UTF-8");
 
     int checkStatus = getIntParameter(request, "checkStatus");
     if (checkStatus == -1) checkStatus = 1;
     String startDate = request.getParameter("startDate");
     String endDate = request.getParameter("endDate");
     String startTime = startDate.replaceAll("\\D+", "") + "000000";
     String endTime = endDate.replaceAll("\\D+", "") + "235959";
     int page = getIntParameter(request, "page");
     if (page < 0) page = 1;
     int start = (page - 1) * 10;
     int end = page * 10;
     List hmfaList = this.hmfaDao.getList(start, end, checkStatus, startTime, endTime);
     int count = this.hmfaDao.getCount(checkStatus, startTime, endTime);
     int pageCount = (count % 10 == 0) ? count / 10 : count / 10 + 1;
     int notPrintBets = 0;
     int printBets = 0;
     StringBuilder sb = new StringBuilder();
     sb.append("{");
     sb.append("hmfaList:[");
     if ((hmfaList != null) && (hmfaList.size() > 0))
     {
       for (int i = 0; i < hmfaList.size(); ++i)
       {
         Hmfa hmfa = (Hmfa)hmfaList.get(i);
         sb.append("{");
         sb.append("hmfaId:'" + hmfa.getHmfaId() + "',");
         sb.append("serialNo:'" + hmfa.getSerialNo() + "',");
         sb.append("userNickName:'" + hmfa.getUserNickName() + "',");
         sb.append("lotName:'" + ((String)Contants.GAMECODEMAP.get(Integer.valueOf(hmfa.getLotName()))) + "',");
         sb.append("manner:'" + CommonUtil.replaceManner(hmfa.getLotName(), hmfa.getManner()) + "',");
         sb.append("money:'" + hmfa.getMoney() + "',");
         sb.append("multiple:'" + hmfa.getMultiple() + "',");
         if (checkStatus == 1)
         {
           List tempList = this.chipinTempDao.getBySerialNoList(hmfa.getSerialNo());
           if ((tempList != null) && (tempList.size() > 0))
           {
             sb.append("tempList:[");
             for (int j = 0; j < tempList.size(); ++j)
             {
               ChipinTemp temp = (ChipinTemp)tempList.get(j);
               sb.append("{");
               sb.append("spValue:'" + temp.getSpValue() + "',");
               //sb.append("printStatus:'" + temp.getPrintStatus() + "',");
               sb.append("num:'" + CommonUtil.replaceSpValue(hmfa.getLotName(), temp.getSpValue()) + "',");
               sb.append("bets:'" + temp.getBets() + "'");
               sb.append("}");
               if (j == tempList.size() - 1)
                 continue;
               sb.append(",");
             }
 
             sb.append("],");
           }
           notPrintBets = this.chipinTempDao.getByHmfaSerialNoBets(0, startTime, endTime);
           printBets = this.chipinTempDao.getByHmfaSerialNoBets(1, startTime, endTime);
         }
         sb.append("fqTime:'" + CommonUtil.replaceDate(new StringBuilder(String.valueOf(hmfa.getFqTime())).toString()) + "',");
         sb.append("checkStatus:'" + hmfa.getCheckStatus() + "'");
         sb.append("}");
         if (i == hmfaList.size() - 1)
           continue;
         sb.append(",");
       }
     }
 
     sb.append("]");
     sb.append(",count:'" + count + "'");
     sb.append(",pageCount:'" + pageCount + "'");
     sb.append(",notPrintBets:'" + notPrintBets + "'");
     sb.append(",printBets:'" + printBets + "'");
     sb.append("}");
 
     nocache(response);
 
     response.setContentType("text/html;charset=UTF-8");
     PrintWriter out = response.getWriter();
     out.print(sb.toString());
     return null;
   }
 
   public ActionForward checkHmfa(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response)
     throws Exception
   {
     request.setCharacterEncoding("UTF-8");
 
     int hmfaId = getIntParameter(request, "hmfaId");
     String printSpValues = request.getParameter("printSpValues");
     StringBuilder sb = new StringBuilder();
     sb.append("{\"json\":[{");
     if (hmfaId > 0)
     {
       Hmfa hmfa = this.hmfaDao.getById(hmfaId);
       if ((hmfa != null) && (hmfa.getCheckStatus() == 1) && (!(StringUtils.isEmpty(printSpValues))))
       {
         this.chipinTempDao.setTempPrint(hmfa, printSpValues);
         sb.append("\"type\":\"0\"");
       }
       else
       {
         sb.append("\"type\":\"2\"");
       }
     }
     else
     {
       sb.append("\"type\":\"1\"");
     }
     sb.append("}]}");
     response.setCharacterEncoding("utf-8");
     PrintWriter out = response.getWriter();
     out.append(sb.toString());
     return null;
   }
 }

