 package com.jingCaiBack.action;
 
 import com.jingCaiBack.dao.MarketAccountDAO;
 import com.jingCaiBack.model.MarketAccount;
 import com.jingCaiBack.model.MarketTotal;
 import com.jingCaiBack.util.Contants;
 import com.jingCaiBack.util.MessageAuxiliary;
 import com.letousky.connector.Message;
 import com.letousky.connector.MessageTool;
 import com.letousky.exception.LotteryException;
 import java.io.IOException;
 import java.io.PrintStream;
 import java.io.PrintWriter;
 import java.net.URLDecoder;
 import java.text.DecimalFormat;
 import java.util.ArrayList;
 import java.util.List;
 import javax.servlet.http.HttpServletRequest;
 import javax.servlet.http.HttpServletResponse;
 import org.apache.struts.action.ActionForm;
 import org.apache.struts.action.ActionForward;
 import org.apache.struts.action.ActionMapping;
 
 public class StatisAction extends AbstractAction
 {
   private MarketAccountDAO marketAccountDAO = new MarketAccountDAO();
 
   //财务
   public ActionForward statis(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response)
     throws IOException
   {
     response.setContentType("text/html;charset=UTF-8");
     request.setCharacterEncoding("UTF-8");
     PrintWriter out = response.getWriter();
     List list = new ArrayList();
     Message message = new Message();
     message.setOperaterCode("M0278");
     message.setOperaterNo("11111111111");
     StringBuffer buffer = new StringBuffer();
     String userName = URLDecoder.decode(request.getParameter("userName"));
     buffer.append(userName).append("%23;");
     buffer.append(request.getParameter("beginTime")).append("%23;");
     buffer.append(request.getParameter("endTime")).append("%23;");
     message.setBody(buffer.toString());
     String result = MessageAuxiliary.messageToMessage(message);
     try {
       list = new MessageTool().splits(result);
     } catch (LotteryException lotteryException) {
       throw lotteryException;
     }
     Object[] obj = list.toArray();
     out.print("{items:[");
     for (int i = 0; i < obj.length; ++i) {
       String[] str = (String[])obj[i];
 
       out.print("{userId:'" + str[0] + "',userName:'" + str[1] + 
         "',wycz:'" + str[2] + "',fzcz:'" + str[3] + "'," + 
         "txMoney:'" + str[4] + "',yjsMoney:'" + str[5] + 
         "',wjsMoney:'" + str[6] + "'," + "zjMoney:'" + str[7] + 
         "',balance:'" + str[8] + "'},");
     }
     out.print("]}");
     return null;
   }
   //交易记录
   public ActionForward marketAccountList(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response)
     throws Exception
   {
     request.setCharacterEncoding("UTF-8");
     String startDate = request.getParameter("startDate");
     String startTime = startDate.replaceAll("\\D+", "");
     String endDate = request.getParameter("endDate");
     String endTime = endDate.replaceAll("\\D+", "");
     int page = getIntParameter(request, "page");
     if (page < 0) page = 1;
     int start = (page - 1) * 10;
     int end = page * 10;
     List marketAccountList = this.marketAccountDAO.getList(start, end, startTime, endTime);
     MarketTotal marketTotal = this.marketAccountDAO.getMarketTotal(startTime, endTime);
     int count = marketTotal.getCount();
     int pageCount = (count % 10 == 0) ? count / 10 : count / 10 + 1;
     StringBuilder sb = new StringBuilder();
     sb.append("{");
     sb.append("items:[");
     if ((marketAccountList != null) && (marketAccountList.size() > 0))
     {
       for (int i = 0; i < marketAccountList.size(); ++i)
       {
         MarketAccount marketAccount = (MarketAccount)marketAccountList.get(i);
         sb.append("{");
         sb.append("createTime:'" + marketAccount.getCreateTime() + "',");
         sb.append("bet:'" + Contants.DF.format(marketAccount.getBet()) + "',");
         sb.append("award:'" + Contants.DF.format(marketAccount.getAward()) + "',");
         sb.append("bankCharge:'" + Contants.DF.format(marketAccount.getBankCharge()) + "',");
         sb.append("handCharge:'" + Contants.DF.format(marketAccount.getHandCharge()) + "',");
         sb.append("betRebate:'" + Contants.DF.format(marketAccount.getBetRebate()) + "',");
         sb.append("onLineRebate:'" + Contants.DF.format(marketAccount.getOnLineRebate()) + "',");
         sb.append("carry:'" + Contants.DF.format(marketAccount.getCarry()) + "',");
         sb.append("activity:'" + Contants.DF.format(marketAccount.getActivity()) + "',");
         sb.append("schemeRebate:'" + Contants.DF.format(marketAccount.getSchemeRebate()) + "',");
         sb.append("userMoney:'" + Contants.DF.format(marketAccount.getUserMoney()) + "'");
         sb.append("}");
         if (i == marketAccountList.size() - 1)
           continue;
         sb.append(",");
       }
     }
 
     sb.append("]");
     sb.append(",count:'" + count + "'");
     sb.append(",pageCount:'" + pageCount + "'");
     sb.append(",betSum:'" + Contants.DF.format(marketTotal.getBetSum()) + "'");
     sb.append(",awardSum:'" + Contants.DF.format(marketTotal.getAwardSum()) + "'");
     sb.append(",bankChargeSum:'" + Contants.DF.format(marketTotal.getBankChargeSum()) + "'");
     sb.append(",handChargeSum:'" + Contants.DF.format(marketTotal.getHandChargeSum()) + "'");
     sb.append(",betRebateSum:'" + Contants.DF.format(marketTotal.getBetRebateSum()) + "'");
     sb.append(",onLineRebateSum:'" + Contants.DF.format(marketTotal.getOnLineRebateSum()) + "'");
     sb.append(",carrySum:'" + Contants.DF.format(marketTotal.getCarrySum()) + "'");
     sb.append(",userMoneySum:'" + Contants.DF.format(marketTotal.getUserMoneySum()) + "'");
     sb.append(",activitySum:'" + Contants.DF.format(marketTotal.getActivitySum()) + "'");
     sb.append(",schemeRebateSum:'" + Contants.DF.format(marketTotal.getSchemeRebateSum()) + "'");
     sb.append("}");
 
     nocache(response);
     response.setContentType("text/html;charset=UTF-8");
     PrintWriter out = response.getWriter();
     out.print(sb.toString());
     return null;
   }
 
   public static void main(String[] sfd) {
     List list = new ArrayList();
     Message message = new Message();
     message.setOperaterCode("M0278");
     message.setOperaterNo("11111111111");
     StringBuffer buffer = new StringBuffer();
     buffer.append("").append("%23;");
     buffer.append("20120722000000").append("%23;");
     buffer.append("20120723000000").append("%23;");
     message.setBody(buffer.toString());
     String result = MessageAuxiliary.messageToMessage(message);
     try {
       list = new MessageTool().splits(result);
     } catch (LotteryException lotteryException) {
       throw lotteryException;
     }
     Object[] obj = list.toArray();
     for (int i = 0; i < obj.length; ++i) {
       String[] str = (String[])obj[i];
       for (int s = 0; s < str.length; ++s)
         System.out.println(str[s]);
     }
   }
 }

