 package com.jingCaiBack.action;
 
 import com.jingCaiBack.dao.TurnMoneyDAO;
 import com.jingCaiBack.dao.UserAccountDAO;
import com.jingCaiBack.dao.UserInfoDAO;
 import com.jingCaiBack.dao.UserLoginDAO;
 import com.jingCaiBack.dao.UserRateDAO;
 import com.jingCaiBack.dao.UserRelationDAO;
 import com.jingCaiBack.model.UserAccount;
import com.jingCaiBack.model.UserInfo;
 import com.jingCaiBack.model.UserLogin;
 import com.jingCaiBack.model.UserRate;
 import com.jingCaiBack.model.UserRelation;
 import com.jingCaiBack.util.Contants;
import com.jingCaiBack.util.NumberUtil;

 import java.io.PrintWriter;
 import java.text.DecimalFormat;
import java.util.Date;
 import java.util.HashMap;
 import java.util.List;
 import java.util.Map;
import java.util.regex.Pattern;

 import javax.servlet.http.HttpServletRequest;
 import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
 import org.apache.struts.action.ActionForm;
 import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
 
 public class UserManageAction extends AbstractAction
 {
   private UserInfoDAO userInfodao = new UserInfoDAO();
   private UserLoginDAO userLogindao = new UserLoginDAO();
   private UserAccountDAO userAccountdao = new UserAccountDAO();
   private UserRateDAO userRatedao = new UserRateDAO();
   private UserRelationDAO userRelationdao = new UserRelationDAO();
   private TurnMoneyDAO turnMoneydao = new TurnMoneyDAO();
 
   public ActionForward userLoginList(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response)
     throws Exception
   {
     request.setCharacterEncoding("UTF-8");
     String nameKey = request.getParameter("nameKey");
    /* boolean b = Pattern.matches("[\\u4E00-\\u9FA5]+", nameKey);
     if(!b){
    	 nameKey=new String(nameKey.getBytes("ISO-8859-1"), "utf-8");
     }*/
     String activityId = request.getParameter("activityId");
     String type = request.getParameter("type");
     
     //添加时间查询
 	String startDate = request.getParameter("startDate");
	if (StringUtils.isEmpty(startDate))
		startDate = sdf3.format(new Date());
	String startTime = startDate.replaceAll("\\D+", "") + "000000";
	String endDate = request.getParameter("endDate");
	if (StringUtils.isEmpty(endDate))
		endDate = sdf3.format(new Date());
	String endTime = endDate.replaceAll("\\D+", "") + "235959";
	
     if (type == null) type = "0,1";
     int page = getIntParameter(request, "page");
     if (page < 0) page = 1;
     int start = (page - 1) * 10;
     int end = page * 10;
     List userLoginList = this.userLogindao.getList(nameKey, type, start, end, activityId, startTime, endTime);
     int count = this.userLogindao.getCount(nameKey, type, activityId, startTime, endTime);
     int pageCount = (count % 10 == 0) ? count / 10 : count / 10 + 1;
     StringBuilder sb = new StringBuilder();
     sb.append("{");
     sb.append("items:[");
     if ((userLoginList != null) && (userLoginList.size() > 0))
     {
       for (int i = 0; i < userLoginList.size(); ++i)
       {
         UserLogin user = (UserLogin)userLoginList.get(i);
         UserAccount userAccount = this.userAccountdao.getById(user.getUserId());
         sb.append("{");
         sb.append("registerTime:'" + user.getRegisterTime() + "',");
         sb.append("loginId:'" + user.getLoginId() + "',");
         sb.append("userId:'" + user.getUserId() + "',");
         sb.append("loginName:'" + user.getLoginName() + "',");
         sb.append("nickName:'" + user.getUserNickName() + "',");
         sb.append("type:'" + user.getType() + "',");
         sb.append("sourceId:'" + user.getSourceId() + "',");
         String onLineName = "-";
         System.out.println("nickName-----"+user.getUserNickName());
          //得到用户信息表中的身份证、银行名称、银行卡号、手机号 信息
         UserInfo userInfo=userInfodao.getUserInfo(String.valueOf(user.getUserId()));
         if(userInfo==null){
        	 String userId=request.getParameter("userId");
        	 userInfo=userInfodao.getUserInfo(userId);
         }
         
         UserRelation userRelation = this.userRelationdao.getByNextLineId(user.getUserId());
         if (userRelation != null)
         {
           UserLogin onLineUser = this.userLogindao.getByUserId(userRelation.getUserId());
           if (onLineUser != null)
           {
             onLineName = onLineUser.getLoginName();
           }
         }
         sb.append("onLineName:'" + onLineName + "',");
         if (userAccount != null)
         {
        	 
           sb.append("zhye:'" + NumberUtil.add(userAccount.getBalance(), userAccount.getAwardBets()) + "',"); 
           sb.append("balance:'" + userAccount.getBalance() + "',");
           sb.append("awardBets:'" + userAccount.getAwardBets() + "',");
           sb.append("freezedMoney:'" + userAccount.getFreezedMoney() + "',");
           sb.append("bets:'" + userAccount.getBets() + "',");
         }
         if(userInfo==null){
        	 userInfo=new UserInfo();
         }
         String idCardNumber=userInfo.getIdCardNumber()==null?"未填写":userInfo.getIdCardNumber();
         String cardAccount=userInfo.getCardAccount()==null?"未填写":userInfo.getCardAccount();
         String bank=userInfo.getBank()==null?"未填写":userInfo.getBank();
         String userTel=userInfo.getUserTel()==null?"未填写":userInfo.getUserTel();
         sb.append("idCardNumber:'" + idCardNumber + "',");
         sb.append("cardAccount:'" + cardAccount + "',");
         sb.append("bank:'" + bank + "',");
         sb.append("userTel:'" + userTel + "',");
         
         sb.append("activityIds:'" + user.getActivityIds() + "'");
         sb.append("}");
         if (i == userLoginList.size() - 1)
           continue;
         sb.append(",");
       }
     }
 
     sb.append("]");
     sb.append(",count:'" + count + "'");
     sb.append(",pageCount:'" + pageCount + "'");
     sb.append("}");
 
     nocache(response);
 
     response.setContentType("text/html;charset=UTF-8");
     PrintWriter out = response.getWriter();
     out.print(sb.toString());
     return null;
   }
 
   public ActionForward updateUserLogin(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response)
     throws Exception
   {
     int isSuccess = -1;
     int loginId = getIntParameter(request, "loginId");
     if (loginId > 0)
     {
       UserLogin user = this.userLogindao.getById(loginId);
       if (user != null)
       {
         int type = getIntParameter(request, "type");
         String activityIds = request.getParameter("activityIds");
         if ((type > -1) && (activityIds != null))
         {
           user.setType(type);
           user.setActivityIds(activityIds);
           isSuccess = this.userLogindao.update(user);
         }
       }
     }
 
     nocache(response);
 
     response.setContentType("text/html;charset=UTF-8");
     PrintWriter out = response.getWriter();
     out.print(isSuccess);
     return null;
   }
 
   public ActionForward editRateList(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response)
     throws Exception
   {
     int userId = getIntParameter(request, "userId");
     if (userId > 0)
     {
       int type = getIntParameter(request, "type");
       if (type < 0) type = 0;
       StringBuilder sb = new StringBuilder();
       sb.append("{");
       sb.append("items:[");
 
       int[] gameCodes = Contants.GAMECODES;
       if ((gameCodes != null) && (gameCodes.length > 0))
       {
         for (int i = 0; i < gameCodes.length; ++i)
         {
           int gameCode = gameCodes[i];
           sb.append("{");
           sb.append("gameCode:'" + gameCode + "'");
           sb.append(",");
           UserRate userRate = this.userRatedao.getUserRate(userId, gameCode, 0, type);
           String rate = "";
           if (userRate != null)
           {
             float tmp = userRate.getRate() * 100.0F;
             DecimalFormat dfm = new DecimalFormat("##.##");
             rate = dfm.format(tmp);
           }
           sb.append("rate:'" + rate + "'");
           sb.append("}");
           if (i == gameCodes.length - 1)
             continue;
           sb.append(",");
         }
       }
 
       sb.append("]}");
 
       nocache(response);
 
       response.setContentType("text/html;charset=UTF-8");
       PrintWriter out = response.getWriter();
       out.print(sb.toString());
     }
     return null;
   }
 
   public ActionForward editJiaJiangRateList(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response)
     throws Exception
   {
     int userId = getIntParameter(request, "userId");
     if (userId > 0)
     {
       int gameCode = getIntParameter(request, "gameCode");
       if (gameCode < 0) gameCode = 501;
       int count = 1;
       int pageCount = 1;
       StringBuilder sb = new StringBuilder();
       sb.append("{");
       sb.append("items:[");
       Map data = new HashMap();
       if ((gameCode >= 501) && (gameCode <= 508))
       {
         data = Contants.JCMAP;
       }
       else if ((gameCode >= 301) && (gameCode <= 305))
       {
         data = Contants.STMAP;
       }
       else
       {
         data = Contants.CTMAP;
       }
       count = data.size();
       pageCount = (count % 10 == 0) ? count / 10 : count / 10 + 1;
       int page = getIntParameter(request, "page");
       if (page < 0) page = 1;
       int start = (page - 1) * 10;
       int end = page * 10;
       if (start > count)
       {
         start = count;
       }
       if (end > count)
       {
         end = count;
       }
 
       for (int i = start + 1; i <= end; ++i)
       {
         sb.append("{");
         sb.append("manner:'" + i + "'");
         sb.append(",");
         sb.append("mannerStr:'" + ((String)data.get(Integer.valueOf(i))) + "'");
         sb.append(",");
         UserRate userRate = this.userRatedao.getUserRate(userId, gameCode, i, 1);
         String rate = "";
         if (userRate != null)
         {
           float tmp = userRate.getRate() * 100.0F;
           DecimalFormat dfm = new DecimalFormat("##.##");
           rate = dfm.format(tmp);
         }
         sb.append("rate:'" + rate + "'");
         sb.append("}");
         if (i == end)
           continue;
         sb.append(",");
       }
 
       sb.append("]");
       sb.append(",count:'" + count + "'");
       sb.append(",pageCount:'" + pageCount + "'");
       sb.append("}");
 
       nocache(response);
 
       response.setContentType("text/html;charset=UTF-8");
       PrintWriter out = response.getWriter();
       out.print(sb.toString());
     }
     return null;
   }
 
   public ActionForward updateRate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response)
     throws Exception
   {
     int isSuccess = -1;
     float rate = getFloatParameter(request, "rate");
     int manner = getIntParameter(request, "manner");
     int gameCode = getIntParameter(request, "gameCode");
     int type = getIntParameter(request, "type");
     int userId = getIntParameter(request, "userId");
     if ((rate > 0.0F) && (manner > -1) && (gameCode > -1) && (type > -1) && (userId > 0))
     {
       rate /= 100.0F;
       DecimalFormat dfm = new DecimalFormat("#.####");
       rate = Float.parseFloat(dfm.format(rate));
       if (gameCode == 0)
       {
         int[] gameCodes = Contants.GAMECODES;
         for (int i = 0; i < gameCodes.length; ++i)
         {
           int lotName = gameCodes[i];
           UserRate userRate = this.userRatedao.getUserRate(userId, lotName, manner, type);
           if (userRate != null)
           {
             userRate.setRate(rate);
             this.userRatedao.updateRate(userRate);
           }
           else
           {
             userRate = new UserRate();
             userRate.setUserId(userId);
             userRate.setManner(manner);
             userRate.setType(type);
             userRate.setGameCode(lotName);
             userRate.setRate(rate);
             this.userRatedao.insert(userRate);
           }
         }
         isSuccess = 1;
       }
       else
       {
         UserRate userRate = this.userRatedao.getUserRate(userId, gameCode, manner, type);
         if (userRate != null)
         {
           userRate.setRate(rate);
           this.userRatedao.updateRate(userRate);
         }
         else
         {
           userRate = new UserRate();
           userRate.setUserId(userId);
           userRate.setManner(manner);
           userRate.setType(type);
           userRate.setGameCode(gameCode);
           userRate.setRate(rate);
           this.userRatedao.insert(userRate);
         }
         isSuccess = 1;
       }
       response.setContentType("text/html;charset=UTF-8");
       PrintWriter out = response.getWriter();
       out.print(isSuccess);
     }
     return null;
   }
 
   public ActionForward userTurnMoney(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response)
     throws Exception
   {
     request.setCharacterEncoding("UTF-8");
     
     String userName = request.getParameter("userName");
   /*  boolean b = Pattern.matches("[\\u4E00-\\u9FA5]+", userName);
     if(!b){
    	 userName=new String(userName.getBytes("ISO-8859-1"), "utf-8");
     }*/
     double turnMoney = getFloatParameter(request, "turnMoney");
     String incomeUserName = request.getParameter("incomeUserName");
    /* boolean b1 = Pattern.matches("[\\u4E00-\\u9FA5]+", incomeUserName);
     if(!b1){
    	 incomeUserName=new String(incomeUserName.getBytes("ISO-8859-1"), "utf-8");
     }*/
     UserLogin outUser = this.userLogindao.getByName(userName);
     UserLogin inUser = this.userLogindao.getByName(incomeUserName);
     String success = "1111";
     if ((outUser != null) && (inUser != null) && (turnMoney > 0.0D))
     {
       this.turnMoneydao.turnMoney(outUser.getUserId(), inUser.getUserId(), turnMoney);
       success = "0000";
     }
     else
     {
       success = "2222";
     }
     response.setContentType("text/html;charset=UTF-8");
     PrintWriter out = response.getWriter();
     out.print(success);
     return null;
   }
   public ActionForward deleteUserLogin(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception{
	   int i=-1;
	   request.setCharacterEncoding("UTF-8");
	   String loginId=request.getParameter("loginId");
	   i=userLogindao.delete(loginId);
	     nocache(response);
	     response.setContentType("text/html;charset=UTF-8");
	     PrintWriter out = response.getWriter();
	     out.print(i);
	     return null;
   }
 }

