 package com.jingCaiBack.dao;
 
 import com.ibatis.sqlmap.client.SqlMapClient;
 import com.jingCaiBack.model.AccountTrade;
 import com.jingCaiBack.util.Contants;
 import java.sql.SQLException;
 import java.text.SimpleDateFormat;
 import java.util.Date;
 import java.util.HashMap;
 import java.util.List;
import java.util.Map;
 
 public class AccountTradeDAO extends BaseDAO
 {
   public int insert(int userId, String tradeType, double inCome, double payOut, double balance)
     throws SQLException
   {
     AccountTrade trade = new AccountTrade();
     trade.setSerialNo(Contants.YYYYMMDDHHMMSS.format(new Date()));
     trade.setFromSerialNo(Contants.YYYYMMDDHHMMSS.format(new Date()));
     trade.setUserId(userId);
     trade.setTradeType(tradeType);
     trade.setTradeTime(Contants.YYYYMMDDHHMMSS.format(new Date()));
     trade.setInCome(inCome);
     trade.setPayOut(payOut);
     trade.setBalance(balance);
     trade.setCharge(0);
     trade.setSourceId(1001);
     return ((Integer)this.sqlMap.insert("AccountTradeDAO.insert", trade)).intValue();
   }
 
   public AccountTrade getById(int tradeId) throws SQLException
   {
     return ((AccountTrade)this.sqlMap.queryForObject("AccountTradeDAO.getById", Integer.valueOf(tradeId)));
   }
 
   public List<AccountTrade> getList(String serialNo, int userId, String tradeType, int start, int end, String startTime, String endTime,String unionId)
     throws SQLException
   {
     Map params = new HashMap();
     params.put("serialNo", serialNo);
     params.put("userId", Integer.valueOf(userId));
     params.put("tradeType", tradeType);
     params.put("start", Integer.valueOf(start));
     params.put("end", Integer.valueOf(end));
     params.put("startTime", startTime);
     params.put("endTime", endTime);
     params.put("unionId", unionId);
     return this.sqlMap.queryForList("AccountTradeDAO.getList", params);
   }
 
   public int getCount(String serialNo, int userId, String tradeType, String startTime, String endTime,String unionId) throws SQLException
   {
     Map params = new HashMap();
     params.put("serialNo", serialNo);
     params.put("userId", Integer.valueOf(userId));
     params.put("tradeType", tradeType);
     params.put("startTime", startTime);
     params.put("endTime", endTime);
     params.put("unionId", unionId);
     return ((Integer)this.sqlMap.queryForObject("AccountTradeDAO.getCount", params)).intValue();
   }
 
   public double getInComeSum(String serialNo, int userId, String tradeType, String startTime, String endTime,String unionId) throws SQLException
   {
     Map params = new HashMap();
     params.put("serialNo", serialNo);
     params.put("userId", Integer.valueOf(userId));
     params.put("tradeType", tradeType);
     params.put("startTime", startTime);
     params.put("endTime", endTime);
     params.put("unionId", unionId);
     return ((Double)this.sqlMap.queryForObject("AccountTradeDAO.getInComeSum", params)).doubleValue();
   }
 
   public double getPayOutSum(String serialNo, int userId, String tradeType, String startTime, String endTime,String unionId) throws SQLException
   {
     Map params = new HashMap();
     params.put("serialNo", serialNo);
     params.put("userId", Integer.valueOf(userId));
     params.put("tradeType", tradeType);
     params.put("startTime", startTime);
     params.put("endTime", endTime);
     params.put("unionId", unionId);
     return ((Double)this.sqlMap.queryForObject("AccountTradeDAO.getPayOutSum", params)).doubleValue();
   }
   public List<AccountTrade> getAllList(String serialNo, int userId, String tradeType, String startTime, String endTime,String unionId) throws Exception{
	   Map params = new HashMap();
	   params.put("serialNo", serialNo);
	   params.put("userId", Integer.valueOf(userId));
	   params.put("tradeType", tradeType);
	   params.put("startTime", startTime);
	   params.put("endTime", endTime);
	   params.put("unionId", unionId);
	   return this.sqlMap.queryForList("AccountTradeDAO.getAllList", params);
   }
   /**
    * 获取消费的金额,包含撤单金额
    * @param serialNo
    * @param userId
    * @param tradeType
    * @param startTime
    * @param endTime
    * @return
    * @throws SQLException
    */
   public double getSellSum(String serialNo, int userId, String tradeType, String startTime, String endTime,String unionId) throws SQLException{
	   Map params = new HashMap();
	     params.put("serialNo", serialNo);
	     params.put("userId", Integer.valueOf(userId));
	     params.put("tradeType", tradeType);
	     params.put("startTime", startTime);
	     params.put("endTime", endTime);
	     params.put("unionId", unionId);
	     return ((Double)this.sqlMap.queryForObject("AccountTradeDAO.getSellSum", params)).doubleValue();
   }
   /**
    * 获取撤单的金额
    * @param serialNo
    * @param userId
    * @param tradeType
    * @param startTime
    * @param endTime
    * @return
    * @throws SQLException
    */
   public double getCancelSum(String serialNo, int userId, String tradeType, String startTime, String endTime,String unionId) throws SQLException{
	   Map params = new HashMap();
	     params.put("serialNo", serialNo);
	     params.put("userId", Integer.valueOf(userId));
	     params.put("tradeType", tradeType);
	     params.put("startTime", startTime);
	     params.put("endTime", endTime);
	     params.put("unionId", unionId);
	     return ((Double)this.sqlMap.queryForObject("AccountTradeDAO.getCancelSum", params)).doubleValue();
   }
   /**
    * 获取中奖派奖
    * @param serialNo
    * @param userId
    * @param tradeType
    * @param startTime
    * @param endTime
    * @return
    * @throws SQLException
    */
   public double getAwardBetsSum(String serialNo, int userId, String tradeType, String startTime, String endTime,String unionId) throws SQLException{
	   Map params = new HashMap();
	     params.put("serialNo", serialNo);
	     params.put("userId", Integer.valueOf(userId));
	     params.put("tradeType", tradeType);
	     params.put("startTime", startTime);
	     params.put("endTime", endTime);
	     params.put("unionId", unionId);
	     return ((Double)this.sqlMap.queryForObject("AccountTradeDAO.getAwardBetsSum", params)).doubleValue();
   }
   /**
    * 获取提成奖金
    * @param serialNo
    * @param userId
    * @param tradeType
    * @param startTime
    * @param endTime
    * @return
    * @throws SQLException
    */
   public double getTcAwardBetsSum(String serialNo, int userId, String tradeType, String startTime, String endTime,String unionId) throws SQLException{
	   Map params = new HashMap();
	     params.put("serialNo", serialNo);
	     params.put("userId", Integer.valueOf(userId));
	     params.put("tradeType", tradeType);
	     params.put("startTime", startTime);
	     params.put("endTime", endTime);
	     params.put("unionId", unionId);
	     return ((Double)this.sqlMap.queryForObject("AccountTradeDAO.getTcAwardBetsSum", params)).doubleValue();
   }
   /**
    * 获取用户余额基本信息
    * @return
    * @throws SQLException
    */
   public Map getUserAccountSum() throws SQLException{
	      Map map = new HashMap();
	      String sqlStr="select sum(balance)balance,sum(awardbets)awardbets,sum(freezedmoney)freezedmoney ,sum(bets)bets_ from USER_ACCOUNT";
	      map.put("sql", sqlStr);
	      CoreDAO coreDao=new CoreDAO();
	      Map resultMap=coreDao.getMap("Core.generalSelect", map);
	     return resultMap;
   }
   /**
    * 注册送5元
    * @param startTime
    * @param endTime
    * @return
    * @throws SQLException
    */
   public double getBets1012Sum(Date startTime, Date endTime,String unionId) throws SQLException{
	   Map params = new HashMap();
	     params.put("startTime", startTime);
	     params.put("endTime", endTime);
	     params.put("unionId", unionId);
	     return ((Double)this.sqlMap.queryForObject("AccountTradeDAO.getBets1012Sum", params)).doubleValue();
  }
   /**
    * 充值50送60
    * @param startTime
    * @param endTime
    * @return
    * @throws SQLException
    */
   public double getBets6001Sum(Date startTime, Date endTime,String unionId) throws SQLException{
	   Map params = new HashMap();
	     params.put("startTime", startTime);
	     params.put("endTime", endTime);
	     params.put("unionId", unionId);
	     return ((Double)this.sqlMap.queryForObject("AccountTradeDAO.getBets6001Sum", params)).doubleValue();
  }
   /**
    * 管理员辅助充值
    * @param serialNo
    * @param userId
    * @param tradeType
    * @param startTime
    * @param endTime
    * @return
    * @throws SQLException
    */
   public double getManmagerChongzhiSum(String serialNo, int userId, String tradeType, String startTime, String endTime,String unionId) throws SQLException{
	      Map params = new HashMap();
	     params.put("serialNo", serialNo);
	     params.put("userId", Integer.valueOf(userId));
	     params.put("tradeType", tradeType);
	     params.put("startTime", startTime);
	     params.put("endTime", endTime);
	     params.put("unionId", unionId);
	     return ((Double)this.sqlMap.queryForObject("AccountTradeDAO.getManmagerChongzhiSum", params));
  }
   /**
    * 网银充值
    * @param serialNo
    * @param userId
    * @param tradeType
    * @param startTime
    * @param endTime
    * @return
    * @throws SQLException
    */
   public double getBankChongzhiSum(String serialNo, int userId, String tradeType, String startTime, String endTime,String unionId) throws SQLException{
	      Map params = new HashMap();
	     params.put("serialNo", serialNo);
	     params.put("userId", Integer.valueOf(userId));
	     params.put("tradeType", tradeType);
	     params.put("startTime", startTime);
	     params.put("endTime", endTime);
	     params.put("unionId", unionId);
	     return ((Double)this.sqlMap.queryForObject("AccountTradeDAO.getBankChongzhiSum", params));
}
   /**
    * 投注已经结算
    * @param serialNo
    * @param userId
    * @param tradeType
    * @param startTime
    * @param endTime
    * @return
    * @throws SQLException
    */
   public double getJsSellSum(String serialNo, int userId, String startTime, String endTime,String unionId) throws SQLException{
	      Map params = new HashMap();
	     params.put("serialNo", serialNo);
	     params.put("userId", Integer.valueOf(userId));
	     params.put("startTime", startTime);
	     params.put("endTime", endTime);
	     params.put("unionId", unionId);
	     return ((Double)this.sqlMap.queryForObject("AccountTradeDAO.getJsSellSum", params));
}
   /**
    * 投注未结算
    * @param serialNo
    * @param userId
    * @param tradeType
    * @param startTime
    * @param endTime
    * @return
    * @throws SQLException
    */
   public double getWjsSellSum(String serialNo, int userId,  String startTime, String endTime,String unionId) throws SQLException{
	      Map params = new HashMap();
	     params.put("serialNo", serialNo);
	     params.put("userId", Integer.valueOf(userId));
	     params.put("startTime", startTime);
	     params.put("endTime", endTime);
	     params.put("unionId", unionId);
	     return ((Double)this.sqlMap.queryForObject("AccountTradeDAO.getWjsSellSum", params));
}
   
 }
