 package com.jingCaiBack.dao;
 
 import com.ibatis.sqlmap.client.SqlMapClient;
 import com.jingCaiBack.model.Activity;
 import java.sql.SQLException;
 import java.util.HashMap;
 import java.util.List;
 import java.util.Map;
 
 public class ActivityDAO extends BaseDAO
 {
   public Activity getById(int activityId)
     throws SQLException
   {
     return ((Activity)this.sqlMap.queryForObject("ActivityDAO.getById", Integer.valueOf(activityId)));
   }
 
   public void insert(Activity activity) throws SQLException
   {
     this.sqlMap.insert("ActivityDAO.insert", activity);
   }
 
   public int update(Activity activity) throws SQLException
   {
     return Integer.valueOf(this.sqlMap.update("ActivityDAO.update", activity)).intValue();
   }
 
   public int delete(Activity activity) throws SQLException
   {
     return Integer.valueOf(this.sqlMap.delete("ActivityDAO.delete", activity)).intValue();
   }
 
   public List<Activity> getList(int start, int end)
     throws SQLException
   {
     Map params = new HashMap();
     params.put("start", Integer.valueOf(start));
     params.put("end", Integer.valueOf(end));
     return this.sqlMap.queryForList("ActivityDAO.getList", params);
   }
 
   public int getCount() throws SQLException
   {
     return ((Integer)this.sqlMap.queryForObject("ActivityDAO.getCount", null)).intValue();
   }
 }
