 package com.jingCaiBack.dao;
 
 import com.ibatis.sqlmap.client.SqlMapClient;
 import com.jingCaiBack.model.ChipinTemp;
 import com.jingCaiBack.model.Hmfa;
 import java.sql.SQLException;
 import java.util.HashMap;
 import java.util.List;
 import java.util.Map;
import org.apache.commons.lang.StringUtils;
 
 public class ChipinTempDAO extends BaseDAO
 {
	 /***
	  * 
	  * @param tempId 商业号码
	  * @param serialNo 流水号
	  * @param userNickName 用户昵称
	  * @param startTime
	  * @param endTime
	  * @return List集合
	  */
   public List getList(String tempId, String serialNo, String userNickName, int start, int end, String startTime, String endTime){
	   Map params = new HashMap();
	   params.put("tempId", tempId);
	   params.put("serialNo", serialNo);
	   params.put("userNickName", userNickName);
	   params.put("start", Integer.valueOf(start));
	   params.put("end", Integer.valueOf(end));
	   params.put("startTime", startTime);
	   params.put("endTime", endTime);
	   List list=null;
	   try {
		list= this.sqlMap.queryForList("ChipinTempDAO.getList", params);
	} catch (SQLException e) {
		e.printStackTrace();
	}
	return list;
   }
   
   /****
    * 
    * @param tempId 商业号码
	* @param serialNo 流水号
	* @param userNickName 用户昵称
	* @param startTime
	* @param endTime
    * @return 条数
    */
   public int getCount(String tempId, String serialNo, String userNickName,String startTime, String endTime){
	   Map params = new HashMap();
	   params.put("tempId", tempId);
	   params.put("serialNo", serialNo);
	   params.put("userNickName", userNickName);
	
	   params.put("startTime", startTime);
	   params.put("endTime", endTime);
	   int i=0;
	   try {
		i= ((Integer)this.sqlMap.queryForObject("ChipinTempDAO.getCount", params)).intValue();
	} catch (SQLException e) {
		e.printStackTrace();
	}
	return i;
   }
   public ChipinTemp getById(int tempId)
     throws SQLException
   {
     return ((ChipinTemp)this.sqlMap.queryForObject("ChipinTempDAO.getById", Integer.valueOf(tempId)));
   }
 
   public List<ChipinTemp> getBySerialNoList(String serialNo)
     throws SQLException
   {
     return this.sqlMap.queryForList("ChipinTempDAO.getBySerialNoList", serialNo);
   }
 
   public int getByHmfaSerialNoBets(int printStatus, String startTime, String endTime)
     throws SQLException
   {
     Map params = new HashMap();
     params.put("sign", (printStatus == 1) ? "=" : "<>");
     params.put("startTime", startTime);
     params.put("endTime", endTime);
     return ((Integer)this.sqlMap.queryForObject("ChipinTempDAO.getByHmfaSerialNoBets", params)).intValue();
   }
 
   public void setTempPrint(Hmfa hmfa, String printSpValues)
   {
     try
     {
       this.sqlMap.startTransaction();
       if (!(StringUtils.isEmpty(printSpValues)))
       {
         String[] tmpSpValues = printSpValues.split("\\|");
         for (int i = 0; i < tmpSpValues.length; ++i)
         {
           Map params = new HashMap();
           params.put("spValue", tmpSpValues[i]);
           params.put("serialNo", hmfa.getSerialNo());
           this.sqlMap.update("ChipinTempDAO.updatePrintStatus", params);
         }
       }
       this.sqlMap.commitTransaction();
     }
     catch (SQLException e)
     {
       e.printStackTrace();
     }
     finally
     {
       try {
         this.sqlMap.endTransaction();
       } catch (SQLException e) {
         e.printStackTrace();
       }
     }
   }
   
   /***
	  * 
	  * @param tempId 商业号码
	  * @param serialNo 流水号
	  * @param userNickName 用户昵称
	  * @param startTime
	  * @param endTime
	  * @return List集合
	  */
 public List getBetsList(String startTime,String endTime){
	   Map params = new HashMap();
	   params.put("startTime", startTime);
	   params.put("endTime", endTime);
	   List list=null;
	   try {
		list= this.sqlMap.queryForList("ChipinTempDAO.getBets", params);
	} catch (SQLException e) {
		e.printStackTrace();
	}
	return list;
 }
 }
