package com.jingCaiBack.dao;
 
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
/***
 * 描叙：增删改查的通用类
 * @author 左国斌
 *
 */
 public class CoreDAO extends BaseDAO
 { 
  
	 /****
		 * 描叙:得到List集合
		 * @param arg0 根据操作类型,执行不同的sql语句,详情看CoreDAO.xml的key
		 * @param arg1 一个存放了sql语句的map
		 * @return 返回一个List集合
		 */
	 public List getList(String arg0, Object arg1) throws SQLException{
		 return this.sqlMap.queryForList(arg0, arg1);
	 }
	 /****
		 * 描叙:插入出错返回0,插入正确返回1
		 * @param arg0 根据操作类型,执行不同的sql语句,详情看CoreDAO.xml的key
		 * @param arg1 一个存放了sql语句的map
		 * @return 返回有一个Map集合
		 */
	 public Map getMap(String arg0, Object arg1) throws SQLException{
		 Map map=new HashMap();
		 List list= this.sqlMap.queryForList(arg0, arg1);
		 if(null !=list && list.size()>0){
			 map=(Map) list.get(0);
		 }
		 return map;
	 }
	 /****
		 * 描叙:插入出错返回0,插入正确返回1
		 * @param arg0 根据操作类型,执行不同的sql语句,详情看CoreDAO.xml的key
		 * @param arg1 一个存放了sql语句的map
		 * @return 跟新的记录数
		 */
	 public int update(String arg0, Object arg1) throws SQLException{
		 return this.sqlMap.update(arg0, arg1);
	 }
	 /****
		 * 描叙:插入出错返回0,插入正确返回1
	     * @param arg0 根据操作类型,执行不同的sql语句,详情看CoreDAO.xml的key
		 * @param arg1 一个存放了sql语句的map
		 * @return 删除的记录数
		 */
	 public int delete(String arg0, Object arg1) throws SQLException{
		 return this.sqlMap.delete(arg0, arg1);
	 }
	/****
	 * 描叙:插入出错返回0,插入正确返回1
	  * @param arg0 根据操作类型,执行不同的sql语句,详情看CoreDAO.xml的key
	  * @param arg1 一个存放了sql语句的map
	 * @return 插入出错返回0,插入正确返回1
	 */
	 public int insert(String arg0, Object arg1){
		 int i=0;
		 try {
			 this.sqlMap.insert(arg0, arg1);
			 return (i+1);
		} catch (SQLException e) {
		   e.printStackTrace();
		   System.out.println("插入数据时出错!");
		}
		return i;
	 }
	 
	 public   void getProcedure(Map map) throws SQLException{
		 this.sqlMap.update("Core.getProcedure", map);
		
	}
	 public static void main(String[] args) throws SQLException {
		 CoreDAO coreDAO=new CoreDAO();
		 Map map=new HashMap();
		 map.put("v_tempid", 5000063432L);
		  map.put("v_money", new BigDecimal(6.3));
		 coreDAO.getProcedure(map);
	 }

 }

