 package com.jingCaiBack.dao;
 
 import com.ibatis.sqlmap.client.SqlMapClient;
 import com.jingCaiBack.model.MarketAccount;
 import com.jingCaiBack.model.MarketTotal;
 import java.sql.SQLException;
 import java.util.HashMap;
 import java.util.List;
 import java.util.Map;
 
 public class MarketAccountDAO extends BaseDAO
 {
   public MarketAccount getById(int marketId)
     throws SQLException
   {
     return ((MarketAccount)this.sqlMap.queryForObject("MarketAccountDAO.getById", Integer.valueOf(marketId)));
   }
 
   public MarketAccount getByCreateTime(long createTime) throws SQLException
   {
     return ((MarketAccount)this.sqlMap.queryForObject("MarketAccountDAO.getByCreateTime", Long.valueOf(createTime)));
   }
 
   public int insert(MarketAccount marketAccount) throws SQLException
   {
     return ((Integer)this.sqlMap.insert("MarketAccountDAO.insert", marketAccount)).intValue();
   }
 
   public int update(MarketAccount marketAccount) throws SQLException
   {
     return Integer.valueOf(this.sqlMap.update("MarketAccountDAO.update", marketAccount)).intValue();
   }
 
   public List<MarketAccount> getList(int start, int end, String startTime, String endTime)
     throws SQLException
   {
     Map params = new HashMap();
     params.put("start", Integer.valueOf(start));
     params.put("end", Integer.valueOf(end));
     params.put("startTime", startTime);
     params.put("endTime", endTime);
     return this.sqlMap.queryForList("MarketAccountDAO.getList", params);
   }
 
   public MarketTotal getMarketTotal(String startTime, String endTime) throws SQLException
   {
     Map params = new HashMap();
     params.put("startTime", startTime);
     params.put("endTime", endTime);
     return ((MarketTotal)this.sqlMap.queryForObject("MarketAccountDAO.getMarketTotal", params));
   }
 }
