 package com.jingCaiBack.dao;
 
 import com.ibatis.sqlmap.client.SqlMapClient;
 import com.jingCaiBack.model.UserAccount;
 import java.sql.SQLException;
 import java.text.DecimalFormat;
 
 public class TurnMoneyDAO extends BaseDAO
 {
   private AccountTradeDAO accountTradeDao = new AccountTradeDAO();
   private UserAccountDAO userAccountDao = new UserAccountDAO();
 
   public void turnMoney(int outUserId, int inUserId, double turnMoney)
     throws Exception
   {
     UserAccount outUserAccount = this.userAccountDao.getById(outUserId);
     UserAccount inUserAccount = this.userAccountDao.getById(inUserId);
     if ((outUserAccount != null) && (inUserAccount != null))
     {
       DecimalFormat dfm = new DecimalFormat("#.##");
       turnMoney = Double.parseDouble(dfm.format(turnMoney));
       double outBalance = outUserAccount.getBalance();
       double outAwardBets = outUserAccount.getAwardBets();
       double freezedMoney = outUserAccount.getFreezedMoney();
       if (outBalance + outAwardBets - freezedMoney >= turnMoney)
       {
         try
         {
           this.sqlMap.startTransaction();
           if (outBalance >= turnMoney)
           {
             outUserAccount.setBalance(outBalance - turnMoney);
             this.userAccountDao.update(outUserId, -turnMoney, 0.0D, 0.0D);
           }
           else
           {
             outUserAccount.setBalance(0.0D);
             outUserAccount.setAwardBets(outAwardBets - (turnMoney - outBalance));
             this.userAccountDao.update(outUserId, -outBalance, -(turnMoney - outBalance), 0.0D);
           }
           double inBalance = inUserAccount.getBalance();
           inUserAccount.setBalance(inBalance + turnMoney);
           this.userAccountDao.update(inUserId, turnMoney, 0.0D, 0.0D);
           this.accountTradeDao.insert(outUserId, "7003", 0.0D, turnMoney, outUserAccount.getBalance() + outUserAccount.getAwardBets());
           this.accountTradeDao.insert(inUserId, "7004", turnMoney, 0.0D, inUserAccount.getBalance() + inUserAccount.getAwardBets());
           this.sqlMap.commitTransaction();
         }
         catch (SQLException e)
         {
           e.printStackTrace();
         }
         finally
         {
           try {
             this.sqlMap.endTransaction();
           } catch (SQLException e) {
             e.printStackTrace();
           }
         }
         return;
       }
 
       throw new Exception();
     }
 
     throw new Exception();
   }
 }
