 package com.jingCaiBack.dao;
 
 import com.ibatis.sqlmap.client.SqlMapClient;
 import com.jingCaiBack.model.UserLogin;
 import java.sql.SQLException;
 import java.util.HashMap;
 import java.util.List;
import java.util.Map;
 
 public class UserLoginDAO extends BaseDAO
 {
   public UserLogin getById(int loginId)
     throws SQLException
   {
     return ((UserLogin)this.sqlMap.queryForObject("UserLoginDAO.getById", Integer.valueOf(loginId)));
   }
 
   public UserLogin getByUserId(int userId) throws SQLException
   {
     return ((UserLogin)this.sqlMap.queryForObject("UserLoginDAO.getByUserId", Integer.valueOf(userId)));
   }
 
   public UserLogin getByName(String loginName) throws SQLException
   {
     return ((UserLogin)this.sqlMap.queryForObject("UserLoginDAO.getByName", loginName));
   }
 
   public List<UserLogin> getList(String loginName, String type, int start, int end, String activityId , String startTime, String endTime)
     throws SQLException
   {
     Map params = new HashMap();
     params.put("loginName", loginName);
     params.put("type", type);
     params.put("start", Integer.valueOf(start));
     params.put("end", Integer.valueOf(end));
     params.put("startTime", startTime);
     params.put("endTime", endTime);
     params.put("activityId", activityId);
     return this.sqlMap.queryForList("UserLoginDAO.getList", params);
   }
 
   public int getCount(String loginName, String type, String activityId,String startTime, String endTime) throws SQLException
   {
     Map params = new HashMap();
     params.put("loginName", loginName);
     params.put("type", type);
     params.put("startTime", startTime);
     params.put("endTime", endTime);
     params.put("activityId", activityId);
     return ((Integer)this.sqlMap.queryForObject("UserLoginDAO.getCount", params)).intValue();
   }
 
   public int update(UserLogin userLogin) throws SQLException
   {
     return Integer.valueOf(this.sqlMap.update("UserLoginDAO.update", userLogin)).intValue();
   }
   
   public int delete(String loginId) throws SQLException{
	   return Integer.valueOf(this.sqlMap.delete("UserLoginDAO.delete", loginId)).intValue();
   }
 }

