 package com.jingCaiBack.job;
 
 import com.jingCaiBack.dao.AccountTradeDAO;
 import com.jingCaiBack.dao.MarketAccountDAO;
 import com.jingCaiBack.dao.UserAccountDAO;
 import com.jingCaiBack.model.MarketAccount;
 import com.jingCaiBack.util.CommonUtil;
 import com.jingCaiBack.util.Contants;
 import java.sql.SQLException;
 import java.text.DecimalFormat;
 import java.text.SimpleDateFormat;
 import java.util.Date;
 import org.apache.log4j.Logger;
 import org.quartz.Job;
 import org.quartz.JobExecutionContext;
 import org.quartz.JobExecutionException;
 
 public class StatisJob
   implements Job
 {
   private Logger logger = Logger.getLogger(super.getClass());
 
   private AccountTradeDAO accountTradeDAO = new AccountTradeDAO();
   private UserAccountDAO userAccountDAO = new UserAccountDAO();
   private MarketAccountDAO marketAccountDAO = new MarketAccountDAO();
 
   public void execute(JobExecutionContext arg0) throws JobExecutionException
   {
     String createTime = Contants.YYYYMMDD.format(CommonUtil.getNewDate(new Date(), -1));
     String startTime = createTime + "000000";
     String endTime = createTime + "235959";
     try {
       double userMoney = this.userAccountDAO.getTotalMoney();
       double totalInCome = this.accountTradeDAO.getInComeSum("", 0, "", startTime, endTime,"");
       double totalPayOut = this.accountTradeDAO.getPayOutSum("", 0, "", startTime, endTime,"");
       double award = this.accountTradeDAO.getInComeSum("", 0, "1006", startTime, endTime,"");
       double bankCharge = this.accountTradeDAO.getInComeSum("", 0, "1013", startTime, endTime,"");
       double handCharge = this.accountTradeDAO.getInComeSum("", 0, "1004", startTime, endTime,"");
       double betRebate = this.accountTradeDAO.getInComeSum("", 0, "7001", startTime, endTime,"");
       double onLineRebate = this.accountTradeDAO.getInComeSum("", 0, "7002", startTime, endTime,"");
       double carry = this.accountTradeDAO.getPayOutSum("", 0, "1002", startTime, endTime,"");
       double schemeRebate = this.accountTradeDAO.getInComeSum("", 0, "6002", startTime, endTime,"");
       double activity = this.accountTradeDAO.getInComeSum("", 0, "1012", startTime, endTime,"");
       double bet = Double.parseDouble(Contants.DF.format(totalPayOut - totalInCome + award + bankCharge + handCharge + betRebate + onLineRebate - carry + schemeRebate + activity));
       MarketAccount market = new MarketAccount();
       market.setCreateTime(Long.parseLong(createTime));
       market.setBet(bet);
       market.setAward(award);
       market.setBankCharge(bankCharge);
       market.setHandCharge(handCharge);
       market.setBetRebate(betRebate);
       market.setOnLineRebate(onLineRebate);
       market.setCarry(carry);
       market.setSchemeRebate(schemeRebate);
       market.setActivity(activity);
       market.setUserMoney(userMoney);
       this.marketAccountDAO.insert(market);
     } catch (SQLException e) {
       this.logger.error("统计销售异常" + e.fillInStackTrace());
     }
   }
 }
