 package com.jingCaiBack.listener;
 
 import com.jingCaiBack.job.StatisJob;
 import java.text.ParseException;
 import javax.servlet.ServletContext;
 import javax.servlet.ServletContextEvent;
 import javax.servlet.ServletContextListener;
 import javax.servlet.http.HttpServlet;
 import org.quartz.CronTrigger;
 import org.quartz.JobDetail;
 import org.quartz.Scheduler;
 import org.quartz.SchedulerException;
 import org.quartz.impl.StdSchedulerFactory;
 
 public class ContextListener extends HttpServlet
   implements ServletContextListener
 {
   private Scheduler sch;
 
   public void contextInitialized(ServletContextEvent event)
   {
     try
     {
       this.sch = StdSchedulerFactory.getDefaultScheduler();
       this.sch.start();
       event.getServletContext().log("定时器已启动");
       JobDetail statisDetail = new JobDetail("statisDetail", "DEFAULT", StatisJob.class);
       CronTrigger statisTrigger = new CronTrigger("statisTrigger", null, "0 0 0 * * ?");
       this.sch.scheduleJob(statisDetail, statisTrigger);
     } catch (SchedulerException e) {
       e.printStackTrace();
     } catch (ParseException e) {
       e.printStackTrace();
     }
   }
 
   public void contextDestroyed(ServletContextEvent event) {
     try {
       this.sch.standby();
       event.getServletContext().log("定时器销毁");
     } catch (SchedulerException e) {
       e.printStackTrace();
     }
   }
 }
