package com.jingCaiBack.util;

import java.io.PrintStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class CommonUtil
{
  public static synchronized String DOSERIALNO()
  {
    SimpleDateFormat formatter = new SimpleDateFormat("yyMMddHHmmssSSSSSSSSSSSSS");
     return formatter.format(new Date());
  }

  public static Date getNewDate(Date date, int i)
  {
     Calendar cal = Calendar.getInstance();
     cal.setTime(date);
     cal.add(5, i);
     return cal.getTime();
  }

  public static String replaceManner(int gameCode, String manner)
  {
     StringBuilder sb = new StringBuilder();
     if ((!(StringUtils.isEmpty(manner))) && 
       (gameCode >= 501) && (gameCode <= 511))
    {
       String[] manners = manner.split(",");
       for (int i = 0; i < manners.length; ++i)
      {
         sb.append((String)Contants.JCMAP.get(Integer.valueOf(Integer.parseInt(manners[i]))));
         if (i == manners.length - 1) continue; sb.append(",");
      }
    }

     return sb.toString();
  }

  public static String replaceSpValue(int gameCode, String spValue)
  {
     StringBuilder sb = new StringBuilder();
     if ((!(StringUtils.isEmpty(spValue))) && 
       (gameCode >= 501) && (gameCode <= 511))
    {
       String[] tmpSpValues = spValue.split("//");
       for (int i = 0; i < tmpSpValues.length; ++i)
      {
         String[] tmpNums = tmpSpValues[i].split(",");
         String tmpId = tmpNums[0];
         String[] tmps = tmpNums[1].split("\\/");
         String againstNum = "";
         if (((gameCode >= 501) && (gameCode <= 504)) || (gameCode == 509) || (gameCode == 511))
        {
           againstNum = AgainstUtil.getFNum(tmpId);
        }
        else
        {
           againstNum = AgainstUtil.getBNum(tmpId);
        }
         sb.append(againstNum).append(":");
         for (int j = 0; j < tmps.length; ++j)
        {
           String tmp = tmps[j];
           sb.append(tmp.substring(0, tmp.lastIndexOf(":"))).append("(");
           sb.append(tmp.substring(tmp.lastIndexOf(":") + 1, tmp.length())).append(")");
           if (j == tmps.length - 1) continue; sb.append("/");
        }
         if (i == tmpSpValues.length - 1) continue; sb.append(" x ");
      }
    }

     return sb.toString();
  }

  public static String replaceDate(String date)
  {
    try
    {
       Date d = Contants.YYYYMMDDHHMMSS.parse(date);
       return Contants.YYYY_MM_DD_HH_MM_SS.format(d);
    }
    catch (ParseException e)
    {
       e.printStackTrace();
    }
     return "";
  }

  public static void main(String[] args) {
     System.out.println(Contants.YYYY_MM_DD.format(getNewDate(new Date(), -1)));
     System.out.println(replaceManner(501, "1,3,4,5,6"));
     System.out.println(replaceSpValue(501, "52221,3:4.40/1:3.400//52223,3:1.800"));
  }
}
