/**
 * <p>项目名称：公共模块</p>
 * <p>版权所有 (c) 2006 </p>
 * <p>作者：</p>
 * <p>版本：1.0</p>
 * <p>日期：2006-7-14</p>
 * <p>更新：</p>
 */
package com.jingCaiBack.util;

import java.math.BigDecimal;
import java.util.*;
import java.text.*;

public class MathUtil {

	// 默认除法运算精度
	private static final int DEF_DIV_SCALE = 10;

	/**
	 * 提供精确的加法运算。
	 * 
	 * @param v1
	 *            被加数
	 * @param v2
	 *            加数
	 * @return 两个参数的和
	 */

	public static double add(double v1, double v2) {
		BigDecimal b1 = new BigDecimal(Double.toString(v1));
		BigDecimal b2 = new BigDecimal(Double.toString(v2));
		return b1.add(b2).doubleValue();
	}

	/**
	 * 提供精确的减法运算。
	 * 
	 * @param v1
	 *            被减数
	 * @param v2
	 *            减数
	 * @return 两个参数的差
	 */
	public static double sub(double v1, double v2) {
		BigDecimal b1 = new BigDecimal(Double.toString(v1));
		BigDecimal b2 = new BigDecimal(Double.toString(v2));
		return b1.subtract(b2).doubleValue();
	}

	/**
	 * 提供精确的乘法运算。
	 * 
	 * @param v1
	 *            被乘数
	 * @param v2
	 *            乘数
	 * @return 两个参数的积
	 */
	public static double mul(double v1, double v2) {
		BigDecimal b1 = new BigDecimal(Double.toString(v1));
		BigDecimal b2 = new BigDecimal(Double.toString(v2));
		return b1.multiply(b2).doubleValue();
	}

	/**
	 * 提供（相对）精确的除法运算，当发生除不尽的情况时，精确到 小数点以后10位，以后的数字四舍五入。
	 * 
	 * @param v1
	 *            被除数
	 * @param v2
	 *            除数
	 * @return 两个参数的商
	 */
	public static double div(double v1, double v2) {
		return div(v1, v2, DEF_DIV_SCALE);
	}

	public static double div(double v1, double v2, int scale) {
		if (scale < 0) {
			throw new IllegalArgumentException(
					"The scale must be a positive integer or zero");
		}
		BigDecimal b1 = new BigDecimal(Double.toString(v1));
		BigDecimal b2 = new BigDecimal(Double.toString(v2));
		return b1.divide(b2, scale, BigDecimal.ROUND_HALF_UP).doubleValue();
	}

	/**
	 * 提供（相对）精确的除法运算。当发生除不尽的情况时，由scale参数指 定精度，以后的数字四舍五入。
	 * 
	 * @param v1
	 *            被除数
	 * @param v2
	 *            除数
	 * @param scale
	 *            表示表示需要精确到小数点以后几位。
	 * @return 两个参数的商
	 */
	public static BigDecimal div1(double v1, double v2, int scale) {
		if (scale < 0) {
			throw new IllegalArgumentException(
					"The scale must be a positive integer or zero");
		}
		BigDecimal b1 = new BigDecimal(Double.toString(v1));
		BigDecimal b2 = new BigDecimal(Double.toString(v2));
		return b1.divide(b2, scale, BigDecimal.ROUND_HALF_UP);
	}

	/*
	 * public static void main(String args[]){ System.out.println(div(2.111111,
	 * 3.00, 2)); System.out.println(div1(2.111111, 3.00, 2)); }
	 */

	/**
	 * 提供精确的小数位四舍五入处理。
	 * 
	 * @param v
	 *            需要四舍五入的数字
	 * @param scale
	 *            小数点后保留几位
	 * @return 四舍五入后的结果
	 */
	public static double round(double v, int scale) {
		if (scale < 0) {
			throw new IllegalArgumentException(
					"The scale must be a positive integer or zero");
		}
		BigDecimal b = new BigDecimal(Double.toString(v));
		BigDecimal one = new BigDecimal("1");
		return b.divide(one, scale, BigDecimal.ROUND_HALF_UP).doubleValue();
	}
	
	
	/**
	 * 函数说明：获取表名的随机ID值TableId
     * 参数说明：IDtype 为ID的前缀类型，如加入"RO"等；
     *ISUsedate 为是否加入当前日期；0：不加日期；1：加日期；
     * RandomNum 为返回随机数长度
     * 函数编写人：金鑫 
     * 编写日期：2011-6-16
	 */
	public static String GetTableId(String TableIdtype , int ISUsedate ,int RandomNum )
	{
		String GetStrValue="";
		Date nowDate=new Date();
		SimpleDateFormat formatter=new SimpleDateFormat("yyyymmdd");
		String DateTimeStr=formatter.format(nowDate);
		int intRomNum=RandomNum;
		String StrRandomNum=GenRandomNum(intRomNum);
		if (ISUsedate==0)
		{
			GetStrValue=TableIdtype+StrRandomNum;
		}
		else
		{
			GetStrValue=TableIdtype+new Date().getTime()+StrRandomNum;
		}
		return GetStrValue;
	}
	
	//获取指定位数的随机码
	private static String GenRandomNum(int pwd_len){
	    //35是因为数组是从0开始的，26个字母+10个数字
	    final int maxNum = 36;
	    int i; //生成的随机数
	    int count = 0; //生成的随机的长度
	    char[] str = { '0', '1', '2', '3', '4', '5', '6', '7', '8', '9' };

	    StringBuffer pwd = new StringBuffer("");
	    Random r = new Random();
	    while(count < pwd_len){
	     //生成随机数，取绝对值，防止生成负数，
	   
	     i = Math.abs(r.nextInt(maxNum)); //生成的数最大为36-1
	   
	     if (i >= 0 && i < str.length) {
	      pwd.append(str[i]);
	      count ++;
	     }
	    }

	    return pwd.toString();
	 }
	
	public static void main(String[] args) {
		System.out.println(MathUtil.GetTableId("", 0, 5));
	}


}
