package com.jingCaiBack.util;

import com.ibatis.common.resources.Resources;
import com.ibatis.sqlmap.client.SqlMapClient;
import com.ibatis.sqlmap.client.SqlMapClientBuilder;
import java.io.IOException;
import java.io.Reader;

public class SqlMapClientFactory
{
  private static SqlMapClient sqlMap;

  public static SqlMapClient getInstance()
  {
     if (sqlMap == null)
    {
       Reader reader = null;
      try {
         reader = Resources.getResourceAsReader("sqlmap-config.xml");
         sqlMap = SqlMapClientBuilder.buildSqlMapClient(reader);
      } catch (IOException e) {
         e.printStackTrace();
      } finally {
        try {
           reader.close();
        } catch (IOException e) {
           e.printStackTrace();
        }
      }
    }
     return sqlMap;
  }
}
