/**
 * <p>项目名称：公共模块</p>
 * <p>版权所有 (c) 2006 </p>
 * <p>作者：</p>
 * <p>版本：1.0</p>
 * <p>日期：2006-7-14</p>
 * <p>更新：</p>
 */
package com.jingCaiBack.util;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.jingCaiBack.dao.CoreDAO;



public class SqlUtil {

CoreDAO coreDAO=new CoreDAO();
String sqlStr=null;
Map sqlMap=new HashMap();
Map map=null;
Object object=null;
List list=null;
int count=-1;
/****
 * 描叙:查询某一个字段的值
 * @param tableName 表名
 * @param tableID 表的主键,或者是区分表的唯一字段
 * @param tableIDValue 表的主键的值,或者是区分表的唯一字段的值
 * @param queryName 查询的表的列
 * @return 返回表的列
 */
public Object getColumnNameById(String tableName,String tableID,String tableIDValue,String queryName){
	sqlStr="select "+queryName+" from "+tableName+" where "+tableID+" ='"+tableIDValue+"'";
	sqlMap.put("sql", sqlStr);
	try {
		 map=coreDAO.getMap("Core.generalSelect", sqlMap);
		 object=map.get(queryName.toUpperCase());
	} catch (SQLException e) {
		System.out.println("查询数据出错!!!");
		e.printStackTrace();
	}
	return object;
}
/****
 * 描叙:查询一条记录
 * @param tableName 表名
 * @param tableID 表的主键,或者是区分表的唯一字段
 * @param tableIDValue 表的主键的值,或者是区分表的唯一字段的值
 * @return 返回一条记录
 */
public Map getMapById(String tableName,String tableID,String tableIDValue){
	sqlStr="select * from "+tableName+" where "+tableID+" ='"+tableIDValue+"'";
	sqlMap.put("sql", sqlStr);
	try {
		 map=coreDAO.getMap("Core.generalSelect", sqlMap);
	} catch (SQLException e) {
		System.out.println("查询数据出错!!!");
		e.printStackTrace();
	}
	return map;
	
}
/****
 * 描叙:查询符合某一条件的集合
 * @param tableName 表名
 * @param conditionName 条件字段
 * @param conditionValue 条件字段的值
 * @param queryFlag "in"表示在一个区间内,如果为空或非"in"表示"="值查询
 * @return 返回一条或多条记录
 */
public List getListByCondition(String tableName,String conditionName,String conditionValue,String queryFlag){
	if("in".equalsIgnoreCase(queryFlag)){
		sqlStr="select * from "+tableName+" where "+conditionName+" in("+conditionValue+")";
	}else{
		sqlStr="select * from "+tableName+" where "+conditionName+" ='"+conditionValue+"'";
	}
	sqlMap.put("sql", sqlStr);
	try {
		 list=coreDAO.getList("Core.generalSelect", sqlMap);
	} catch (SQLException e) {
		System.out.println("查询数据出错!!!");
		e.printStackTrace();
	}
	return list;
}

/****
 * 描叙:查询符合某一条件的记录数
 * @param tableName 表名
 * @param conditionName 条件字段
 * @param conditionValue 条件字段的值
 * @return 返回记录数
 */
public int getCountByCondition(String tableName,String conditionName,String conditionValue){
	sqlStr="select count(1)NUM from "+tableName+" where "+conditionName+" ='"+conditionValue+"'";
	sqlMap.put("sql", sqlStr);
	try {
		 map=coreDAO.getMap("Core.generalSelect", sqlMap);
		 count=Integer.valueOf(map.get("NUM").toString());
	} catch (SQLException e) {
		System.out.println("查询数据记录数出错!!!");
		e.printStackTrace();
	}
	return count;
}
/****
 * 根据条件删除某一张表的数据,并返回删除的记录数
 * @param tableName 表名
 * @param conditionName 条件字段
 * @param conditionValue 条件字段的值
 * @return 返回删除的记录数
 */
public int deleteById(String tableName,String conditionName,String conditionValue){
	sqlStr="delete from  "+tableName+" where "+conditionName+" ='"+conditionValue+"'";
	sqlMap.put("sql", sqlStr);
	try {
		 count=coreDAO.delete("Core.generalDelete", sqlMap);
	} catch (SQLException e) {
		System.out.println("删除数据出错!!!");
		e.printStackTrace();
	}
	return count;
}
/****
 * 描叙:根据某一个条件更新一个字段
 * @param tableName 表名
 * @param conditionName 条件字段
 * @param conditionValue 条件字段的值
 * @param updateColumn 需要更新的列名
 * @param updateColumnValue 需要跟新的列名对应的值
 * @return 返回-2表示更新失败,-1表示更新成功
 */
public int updateById(String tableName,String conditionName,String conditionValue,String updateColumn,Object updateColumnValue){
	sqlStr="update  "+tableName+" set "+updateColumn+" ='"+updateColumnValue+"' where "+conditionName+" ='"+conditionValue+"'";
	sqlMap.put("sql", sqlStr);
	try {
		 coreDAO.update("Core.generalUpdate", sqlMap);
	} catch (SQLException e) {
		System.out.println("更新数据出错!!!");
		count=-2;
		e.printStackTrace();
	}
	return count;
}

public List getListBySql(String sqlStr){
	sqlMap.put("sql", sqlStr);
	List list=null;
	try {
		 list=coreDAO.getList("Core.generalSelect", sqlMap);
	} catch (Exception e) {
		e.printStackTrace();
	}
	return list;
}

}
