/*
 * Decompiled with CFR 0.152.
 */
package org.snaker.engine.cache.ehcache;

import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import org.snaker.engine.cache.Cache;
import org.snaker.engine.cache.CacheException;
import org.snaker.engine.helper.AssertHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EhCache<K, V>
implements Cache<K, V> {
    private Ehcache cache;

    public EhCache(Ehcache cache) {
        AssertHelper.notNull((Object)cache);
        this.cache = cache;
    }

    public V get(K key) throws CacheException {
        if (key == null) {
            return null;
        }
        try {
            Element element = this.cache.get(key);
            if (element == null) {
                return null;
            }
            return (V)element.getObjectValue();
        }
        catch (Throwable t) {
            throw new CacheException(t);
        }
    }

    public V put(K key, V value) throws CacheException {
        try {
            V previous = this.get(key);
            Element element = new Element(key, value);
            this.cache.put(element);
            return previous;
        }
        catch (Throwable t) {
            throw new CacheException(t);
        }
    }

    public V remove(K key) throws CacheException {
        try {
            V previous = this.get(key);
            this.cache.remove(key);
            return previous;
        }
        catch (Throwable t) {
            throw new CacheException(t);
        }
    }

    public void clear() throws CacheException {
        try {
            this.cache.removeAll();
        }
        catch (Throwable t) {
            throw new CacheException(t);
        }
    }
}

