/*
 * Decompiled with CFR 0.152.
 */
package org.snaker.engine.cache.ehcache;

import java.io.InputStream;
import net.sf.ehcache.Ehcache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snaker.engine.cache.Cache;
import org.snaker.engine.cache.CacheException;
import org.snaker.engine.cache.CacheManager;
import org.snaker.engine.cache.ehcache.EhCache;
import org.snaker.engine.helper.ConfigHelper;
import org.snaker.engine.helper.StreamHelper;
import org.snaker.engine.helper.StringHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EhCacheManager
implements CacheManager {
    private static final Logger log = LoggerFactory.getLogger(EhCacheManager.class);
    protected net.sf.ehcache.CacheManager manager;
    private String configFile = "org/snaker/engine/cache/ehcache/ehcache.xml";

    public <K, V> Cache<K, V> getCache(String name) throws CacheException {
        try {
            Ehcache cache = this.ensureCacheManager().getEhcache(name);
            if (cache == null) {
                if (log.isInfoEnabled()) {
                    log.info("Cache with name '{}' does not yet exist.  Creating now.", (Object)name);
                }
                this.manager.addCache(name);
                cache = this.manager.getCache(name);
                if (log.isInfoEnabled()) {
                    log.info("Added EhCache named [" + name + "]");
                }
            } else if (log.isInfoEnabled()) {
                log.info("Using existing EHCache named [" + cache.getName() + "]");
            }
            return new EhCache(cache);
        }
        catch (net.sf.ehcache.CacheException e) {
            throw new CacheException((Throwable)e);
        }
    }

    public void destroy() throws CacheException {
        block2: {
            try {
                this.manager.shutdown();
            }
            catch (Exception e) {
                if (!log.isWarnEnabled()) break block2;
                log.warn("Unable to cleanly shutdown implicitly created CacheManager instance.  Ignoring (shutting down)...");
            }
        }
    }

    private net.sf.ehcache.CacheManager ensureCacheManager() {
        try {
            if (this.manager == null) {
                String cacheConfig;
                if (log.isDebugEnabled()) {
                    log.debug("cacheManager property not set.  Constructing CacheManager instance... ");
                }
                if (StringHelper.isNotEmpty((String)(cacheConfig = ConfigHelper.getProperty((String)"cache.config")))) {
                    this.configFile = cacheConfig;
                }
                InputStream input = StreamHelper.getStreamFromClasspath((String)this.configFile);
                this.manager = new net.sf.ehcache.CacheManager(input);
                if (log.isInfoEnabled()) {
                    log.info("instantiated Ehcache CacheManager instance.");
                }
                if (log.isDebugEnabled()) {
                    log.debug("implicit cacheManager created successfully.");
                }
            }
            return this.manager;
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }
}

