/*
 * Decompiled with CFR 0.152.
 */
package org.snaker.engine.scheduling.quartz;

import java.util.Map;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snaker.engine.SnakerEngine;
import org.snaker.engine.core.ServiceContext;
import org.snaker.engine.entity.Process;
import org.snaker.engine.helper.AssertHelper;
import org.snaker.engine.helper.StringHelper;
import org.snaker.engine.model.NodeModel;
import org.snaker.engine.model.ProcessModel;
import org.snaker.engine.scheduling.IScheduler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJob
implements Job {
    private static final Logger log = LoggerFactory.getLogger(AbstractJob.class);
    private IScheduler scheduler;
    protected SnakerEngine engine = ServiceContext.getEngine();

    public void execute(JobExecutionContext context) throws JobExecutionException {
        if (this.engine == null) {
            throw new JobExecutionException("Snaker\u6d41\u7a0b\u5f15\u64ce\u521d\u59cb\u5316\u5931\u8d25.");
        }
        Map data = context.getJobDetail().getJobDataMap().getWrappedMap();
        if (data == null) {
            throw new JobExecutionException("\u6839\u636ejob\u6267\u884c\u7684\u4e0a\u4e0b\u6587\u83b7\u53d6\u4e0d\u5230snaker\u76f8\u5173\u4fe1\u606f.");
        }
        String key = (String)data.get("id");
        String model = (String)data.get("model");
        AssertHelper.notEmpty((String)key);
        data.remove("id");
        data.remove("model");
        String[] ids = key.split("-");
        if (ids.length != 3) {
            log.warn("id\u503c\u4e0d\u5408\u6cd5,\u6267\u884c\u64cd\u4f5c\u88ab\u5ffd\u7565.");
            return;
        }
        String processId = ids[0];
        String orderId = ids[1];
        String taskId = ids[2];
        Process process = this.engine.process().getProcessById(processId);
        ProcessModel processModel = process.getModel();
        NodeModel nodeModel = null;
        if (processModel != null && StringHelper.isNotEmpty((String)model)) {
            nodeModel = processModel.getNode(model);
        }
        this.exec(process, orderId, taskId, nodeModel, data);
    }

    abstract void exec(Process var1, String var2, String var3, NodeModel var4, Map<String, Object> var5) throws JobExecutionException;

    protected IScheduler schedule() {
        if (this.scheduler == null) {
            this.scheduler = (IScheduler)ServiceContext.getContext().find(IScheduler.class);
        }
        return this.scheduler;
    }
}

