/*
 * Decompiled with CFR 0.152.
 */
package org.snaker.engine.scheduling.quartz;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.commons.lang.math.NumberUtils;
import org.quartz.Calendar;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SchedulerFactory;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.impl.calendar.AnnualCalendar;
import org.quartz.impl.calendar.BaseCalendar;
import org.quartz.impl.calendar.DailyCalendar;
import org.quartz.impl.calendar.WeeklyCalendar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snaker.engine.SnakerException;
import org.snaker.engine.helper.AssertHelper;
import org.snaker.engine.helper.ConfigHelper;
import org.snaker.engine.helper.StringHelper;
import org.snaker.engine.scheduling.IScheduler;
import org.snaker.engine.scheduling.JobEntity;
import org.snaker.engine.scheduling.quartz.ExecutorJob;
import org.snaker.engine.scheduling.quartz.ReminderJob;

public class QuartzScheduler
implements IScheduler {
    private static final Logger log = LoggerFactory.getLogger(QuartzScheduler.class);
    private SchedulerFactory schedulerFactory = new StdSchedulerFactory();
    private boolean isUseCalendar = false;

    private Scheduler getScheduler() {
        try {
            Scheduler scheduler = this.schedulerFactory.getScheduler();
            String useCalendarStr = ConfigHelper.getProperty((String)"scheduler.useCalendar");
            boolean isUse = Boolean.parseBoolean(useCalendarStr);
            if (isUse) {
                BaseCalendar cal = null;
                try {
                    cal = this.build();
                }
                catch (Exception e) {
                    log.error("\u6784\u9020BaseCalendar\u5931\u8d25->" + e.getMessage());
                }
                if (cal != null) {
                    scheduler.addCalendar("snakerCalendar", (Calendar)cal, false, false);
                    this.isUseCalendar = true;
                }
            }
            scheduler.start();
            return scheduler;
        }
        catch (SchedulerException e) {
            throw new SnakerException((Throwable)e);
        }
    }

    public void schedule(JobEntity entity) {
        AssertHelper.notNull((Object)entity);
        JobDataMap data = new JobDataMap(entity.getArgs());
        data.put("id", entity.getId());
        data.put("model", entity.getModelName());
        Class jobClazz = null;
        String jobId = "";
        switch (entity.getJobType()) {
            case 0: {
                jobClazz = ExecutorJob.class;
                jobId = "executor." + entity.getTask().getId();
                break;
            }
            case 1: {
                jobClazz = ReminderJob.class;
                jobId = "reminder." + entity.getTask().getId();
            }
        }
        if (jobClazz == null) {
            log.error("Quartz\u4e0d\u652f\u6301\u7684JOB\u7c7b\u578b:{}", (Object)entity.getJobType());
            return;
        }
        JobDetail job = JobBuilder.newJob(jobClazz).usingJobData(data).withIdentity(jobId, "snaker").build();
        Trigger trigger = null;
        TriggerBuilder builder = TriggerBuilder.newTrigger().withIdentity(StringHelper.getPrimaryKey(), "snaker").startAt(entity.getStartTime());
        if (jobClazz == ReminderJob.class && entity.getPeriod() > 0) {
            int count = ConfigHelper.getNumerProperty((String)"scheduler.repeat");
            if (count <= 0) {
                count = 1;
            }
            builder.withSchedule((ScheduleBuilder)SimpleScheduleBuilder.repeatMinutelyForTotalCount((int)count, (int)entity.getPeriod()));
            if (this.isUseCalendar) {
                builder.modifiedByCalendar("snakerCalendar");
            }
        }
        trigger = builder.build();
        try {
            log.info("jobId:{} class:{} starting......", (Object)jobId, jobClazz);
            this.getScheduler().scheduleJob(job, trigger);
        }
        catch (SchedulerException e) {
            log.error(e.getMessage());
        }
    }

    public void delete(String key) {
        AssertHelper.notEmpty((String)key);
        try {
            log.info("jobId:{} deleted......", (Object)key);
            this.getScheduler().deleteJob(new JobKey(key, "snaker"));
        }
        catch (SchedulerException e) {
            log.error(e.getMessage());
        }
    }

    private BaseCalendar build() {
        String[] workTimeArray;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String holidays = ConfigHelper.getProperty((String)"scheduler.holidays");
        String weeks = ConfigHelper.getProperty((String)"scheduler.weeks");
        String workTime = ConfigHelper.getProperty((String)"scheduler.workTime");
        WeeklyCalendar holidayCal = null;
        if (StringHelper.isNotEmpty((String)holidays)) {
            String[] holidayArray = holidays.split(",");
            ArrayList<GregorianCalendar> calendars = new ArrayList<GregorianCalendar>();
            try {
                for (String holiday : holidayArray) {
                    Date date = sdf.parse(holiday);
                    java.util.Calendar cal = java.util.Calendar.getInstance();
                    cal.setTime(date);
                    calendars.add(new GregorianCalendar(cal.get(1), cal.get(2), cal.get(5)));
                }
            }
            catch (Exception e) {
                log.warn("\u8282\u5047\u65e5\u914d\u7f6e\u683c\u5f0f\u6709\u8bef,\u8bf7\u786e\u8ba4\u662f\u5426\u6ee1\u8db32013-01-04\u683c\u5f0f");
            }
            if (calendars.size() > 0) {
                holidayCal = new AnnualCalendar();
                holidayCal.setDaysExcluded(calendars);
            }
        }
        WeeklyCalendar weekdayCal = null;
        if (StringHelper.isNotEmpty((String)weeks)) {
            String[] weekArray;
            weekdayCal = new WeeklyCalendar(holidayCal);
            for (String week : weekArray = weeks.split(",")) {
                if (NumberUtils.isNumber((String)week)) {
                    int w = Integer.parseInt(week);
                    weekdayCal.setDayExcluded(w + 1, true);
                    continue;
                }
                log.warn("{} \u4e0d\u662f\u5408\u6cd5\u7684\u661f\u671f\u6570\u503c,\u8bf7\u68c0\u67e5\u661f\u671f\u7684\u914d\u7f6e\u57281~7\u5185");
            }
        }
        WeeklyCalendar dailyCal = null;
        if (StringHelper.isNotEmpty((String)workTime) && (workTimeArray = workTime.split("-")).length == 2) {
            dailyCal = new DailyCalendar((Calendar)(weekdayCal == null ? holidayCal : weekdayCal), workTimeArray[0], workTimeArray[1]);
        }
        return dailyCal == null ? (weekdayCal == null ? holidayCal : weekdayCal) : dailyCal;
    }
}

