/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi;

import com.deepoove.poi.NiceXWPFDocument;
import com.deepoove.poi.policy.PictureRenderPolicy;
import com.deepoove.poi.policy.RenderPolicy;
import com.deepoove.poi.policy.SimpleTableRenderPolicy;
import com.deepoove.poi.policy.TextRenderPolicy;
import com.deepoove.poi.resolver.TemplateResolver;
import com.deepoove.poi.template.ElementTemplate;
import com.deepoove.poi.template.run.PictureRunTemplate;
import com.deepoove.poi.template.run.TableRunTemplate;
import com.deepoove.poi.template.run.TextRunTemplate;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XWPFTemplate {
    private static Logger logger = LoggerFactory.getLogger(XWPFTemplate.class);
    private NiceXWPFDocument doc;
    private List<ElementTemplate> eleTemplates;
    private Map<String, RenderPolicy> policys = new HashMap<String, RenderPolicy>();

    private XWPFTemplate() {
    }

    public static XWPFTemplate create(String filePath) {
        return XWPFTemplate.create(new File(filePath));
    }

    public static XWPFTemplate create(File file) {
        XWPFTemplate xwpfTemplate = new XWPFTemplate();
        try {
            NiceXWPFDocument doc;
            xwpfTemplate.doc = doc = new NiceXWPFDocument(new FileInputStream(file));
            xwpfTemplate.parseElementTemplates();
            xwpfTemplate.initPolicy();
        }
        catch (FileNotFoundException e) {
            logger.error("cannot find the file", (Throwable)e);
        }
        catch (IOException e) {
            logger.error("create template failed", (Throwable)e);
        }
        return xwpfTemplate;
    }

    private List<ElementTemplate> parseElementTemplates() {
        if (null == this.eleTemplates) {
            this.eleTemplates = TemplateResolver.parseElementTemplates(this.doc);
        }
        return this.eleTemplates;
    }

    private void initPolicy() {
        this.registerPolicy(TextRunTemplate.class, (RenderPolicy)new TextRenderPolicy());
        this.registerPolicy(PictureRunTemplate.class, (RenderPolicy)new PictureRenderPolicy());
        this.registerPolicy(TableRunTemplate.class, (RenderPolicy)new SimpleTableRenderPolicy());
    }

    public void registerPolicy(Class<?> templateClass, RenderPolicy policy) {
        this.policys.put(templateClass.getName(), policy);
    }

    public void registerPolicy(String templateName, RenderPolicy policy) {
        this.policys.put(templateName, policy);
    }

    public RenderPolicy getPolicy(Class<? extends ElementTemplate> clazz) {
        return this.policys.get(clazz.getName());
    }

    public RenderPolicy getPolicy(String tagName) {
        return this.policys.get(tagName);
    }

    public void write(OutputStream out) throws IOException {
        this.doc.write(out);
    }

    public List<ElementTemplate> getElementTemplates() {
        return this.eleTemplates;
    }

    public NiceXWPFDocument getXWPFDocument() {
        return this.doc;
    }
}

